<?php
###############################################################################
# Alexa.php
#
# @author Anil Kumar <akumar@codepunch.com>
# @link   https://codepunch.com
#
############################################################################### 

namespace 	CodePunch\LU;
use 		CodePunch\Base\Util as UTIL;
use			CodePunch\Base\Text as TEXT;

###############################################################################

class Alexa  {
	
	private $lookupManager = null;
	
	###########################################################################
	
	public function __construct($lum=null) {
		$this->lookupManager = $lum;
	}
	
	###############################################################################

	public function lookup(&$ludata)
	{
		$db = $this->lookupManager->getAuthentication()->getDatabase();
		$did = $ludata['sid'];
		$domain = $db->getDomainName($did);
		$lookupcount = 0;
		if($did !== false && $did > 0) {
			$subdomain = "";
			$dataarray = $this->get_alexa_records($domain, $subdomain);
			if(count($dataarray)) {
				//$status = $db->updateDomainTable($dataarray);
				$status = $this->lookupManager->updateDomainTable(\CodePunch\LU\LookupManager::ALEXA_DATA, $dataarray);
				if($status !== false)
					$lookupcount++;
			}
		}
		$ludata['status'] = \CodePunch\LU\LookupManager::LUQ_COMPLETE;
		return $lookupcount;
	}
	
	###############################################################################

	public function get_alexa_data($domain, &$rank, &$reach) 
	{ 
		$url = "https://data.alexa.com/data?cli=10&dat=s&url=" . 'http://' . $domain; 
		// Alexa is dead. Don't try to connect.
		$xml = "";//file_get_contents($url); 
		
		$rank  = (preg_match('/POPULARITY URL="[a-z0-9\\-\\.\\/]{1,}" TEXT="([0-9]{1,12})"/',$xml,$regs) ? number_format($regs[1]) : 0); 
		$reach = (preg_match('/REACH RANK="([0-9]{1,12})"/',$xml,$regs) ? number_format($regs[1]) : 0); 
		//$links = (preg_match('/LINKSIN NUM="([0-9]{1,12})"/',$xml,$regs) ? number_format($regs[1]) : 0); 
		
		$rank  = str_replace(array(",", "."), "", $rank);
		$reach = str_replace(array(",", "."), "", $reach);
	} 
	 
	###############################################################################

	public function get_alexa_records($domain, $subdomain="www")
	{
		$data_array = array();
		$host = UTIL::idn_convert_to_host_name($domain, $subdomain);
		$this->get_alexa_data($domain, $rank, $reach);
		$data_array['domain'] = $domain;
		$data_array['alexa_rank'] = $rank;
		$data_array['alexa_reach'] = $reach;
		$data_array['alexa_checked_at'] = date("Y-m-d H:i:s");
		return $data_array;
	}
}

###############################################################################
