<?php
###############################################################################
# Database.php
#
#
# @author Anil Kumar <akumar@codepunch.com>
# @link   https://codepunch.com
#
############################################################################### 

namespace 	CodePunch\Base;

use 		CodePunch\Base\Util as UTIL;
use 		Exception;

###############################################################################

class Text {
	
	public static $language 		= "en";
	public static $messages        	= null;
	
	###########################################################################
	
	public static function setLanguage($lang) {
		if(strtolower(self::$language) != strtolower($lang) || self::$messages == null) {
			self::$language = strtolower($lang);
			// TODO
			// Try loading from custom language folder first
			$ifolder = realpath(dirname(__FILE__)) . DIRECTORY_SEPARATOR;
			$langfile = realpath($ifolder . "../Lang/") . DIRECTORY_SEPARATOR . self::$language . ".json";
			if(!is_file($langfile)) {
				$ifolder = realpath(dirname(__FILE__)) . DIRECTORY_SEPARATOR;
				$langfile = realpath($ifolder . "../Lang/") . DIRECTORY_SEPARATOR . "en.json";
			}
			if(is_file($langfile)) 
				self::$messages = json_decode(file_get_contents($langfile), true);
			if(self::$messages == null) {
				throw new Exception("Missing or bad language file: " . $lang);
			}
		}
	}
	###########################################################################
	
	public static function getLanguage() {
		return self::$language;
	}
	
	###########################################################################
	
	public static function get($input, $append="") {
		if(self::$messages == null) {
			try {
				self::setLanguage(self::$language);
			}
			catch(Exception $e) {
				$logger = new \CodePunch\Base\CPLogger();
				$logger->error($e->getMessage());
			}
		}
		if(isset(self::$messages[$input]))
			return self::$messages[$input] . ($append != "" ? ": $append" : "");
		else
			return $input . ($append != "" ? ": $append" : "");
	}
	
	###########################################################################
	
	public static function print($input) {
		UTIL::print(self::get($input));
	}
}
	
###############################################################################
