<?php
###############################################################################
# config-extended-sample.php
#
# @author Anil Kumar <akumar@codepunch.com>
# @link   https://codepunch.com
#
# Installation instructions are available at
#
# https://domainpunch.com/sed/guidev5/install/
#
###############################################################################


###############################################################################
# Specify the database selection from one of mysql, oracle, mssql, postgres or
# sqlite. Standard and Basic Editions support only mysql and sqlite.
# Make sure that the database settings are specified in $db_extended_config
# for the specified database.

$db_extended_config_name	= 'mysql';

###############################################################################
# Specify your DB settings for the databases you are going to use.
# If you are using SQLite, provide only the database name (dbname)
# as an an absolute file path (eg.: /home/softnik/db/db.sqlite). The database
# will be created on first run. PHP cli and Apache (Web Server) should have 
# proper access rights to the containing folder and the DB file.
#
# Choose the database driver (dbdriver) from pdo_mysql, mysqli (MySQL),
# oci8 (oracle), pdo_sqlsrv (MS SQL), pdo_pgsql (PostgreSQL) or pdo_sqlite
# (SQLite 3). These are already filled in, but you may change if you have a 
# different driver. Ensure that the required PHP extensions are installed for 
# whatever driver you want to use.
#
# Some drivers support an additional 'port' parameter. If your installation
# uses a non-standard port, specify that too by adding a 'port' => 'xxxx'
# entry. For an example, see the commented entry under 'oracle' below.

$db_extended_config			= array(
	'mysql'		=> 	array(
					'dbname' 	=> 	'dbname_here',
					'dbuser'	=>	'dbuser_here',
					'dbpass'	=>	'secret_here',
					'dbhost'	=>	'localhost',
					'dbdriver'	=>	'pdo_mysql'
					),
	'mssql'		=>	array(
					'dbname' 	=> 	'dbname_here',
					'dbuser'	=>	'dbuser_here',
					'dbpass'	=>	'secret_here',
					'dbhost'	=>	'localhost',
					'dbdriver'	=>	'pdo_sqlsrv'
					),
	'postgres'	=>	array(
					'dbname' 	=> 	'dbname_here',
					'dbuser'	=>	'dbuser_here',
					'dbpass'	=>	'secret_here',
					'dbhost'	=>	'localhost',
					'dbdriver'	=>	'pdo_pgsql'
					),
	'oracle'	=>	array(
					'dbname' 	=> 	'dbname_here',
					'dbuser'	=>	'dbuser_here',
					'dbpass'	=>	'secret_here',
					'dbhost'	=>	'localhost',
					//'port'		=>  '19710',
					'dbdriver'	=>	'oci8'
					),
	'sqlite'	=>	array(
					'dbname' 	=> 	'path/to/db/file',
					'dbuser'	=>	'',
					'dbpass'	=>	'',
					'dbhost'	=>	'',
					'dbdriver'	=>	'pdo_sqlite'
					)
);

###############################################################################
# The default user who can configure the system for the first time. You have
# to specify a valid username and password here to get started. You can delete
# this user after you have created at least one administrative user using the 
# interface. The password should have minimum 8 letters. The default password
# shown here is only a placeholder and will not work.

$db_config_setup_name		= 'setup';
$db_config_setup_password	= 'secret';

###############################################################################
# Specify a common prefix for all the database tables that will be created. 
# Please avoid using a blank prefix entry. It is better to just leave this 
# entry as it is ("wmdsed_"). You can use a different prefix if you are 
# using the same database for multiple installations.

$db_config_table_prefix		= 'wmdsed_';

###############################################################################
# Specify a log folder path. For example, "/home/wmdsed/logs"
# If this is left blank the logs folder at the application root will be used. 
# If you specify a folder here, please make sure that it is writable from both 
# Apache (Web Server) and PHP command line. You will have to use extra commands 
# to write enable this folder for Apache if you are installing under SELinux.

$cfg_log_folder_path		= '/path/to/logs/';

###############################################################################
# In some servers and in specific cases the application may not be able to 
# accurately determine if the connection has SSL. Set this flag to 'http', 
# 'https' or 'detect'. If set to 'detect' the application will auto-detect.
# Change this to https or http (depending on if you are using http/https) if 
# you see javascript errors about invalid certificate or content loaded 
# over https requesting insecure resource over http.

$cfg_http_protocol = 'detect';

###############################################################################
# A unique name for this installation. Do not change this if you are setting 
# up a single server installation. This should be set to blank ("") on 
# secondary installations in a multi-server setup with a central database
# Only professional edition supports multi server setup.

$this_server_id				= 'master';

###############################################################################
# This key is unique to each installation and is set by the download script.
# The key is used to encrypt some of the important settings before saving
# to DB. This encryption is purely to protect sensitive information like   
# passwords and API keys should a database dump be made public.
# If you change this key, the existing settings will have to be re-applied
# It would be a good idea to change the key if you didn't use the download 
# script to obtain the application.
# Use something like 
# base64_encode(openssl_random_pseudo_bytes(64)); 
# to get a random string.

$db_config_publickey		= 'mhKz4JJk/C2bOfJgC+oalSPmhpko4TR7HjreVPSNU0Y7SxWfLMqa2YUiVAuX9WeEiDF+aG4EOULt4qRR6XocjA==';

