/*
 * codepunch-popup
 *
 * Copyright (c) 2020-2021, CodePunch Solutions.
 * https://codepunch.com
 * Author: Anil Kumar
 * 
 */

class PopupPanel {
    static _POPUP_PANELS = {};
    
    static getPanel(id) {
		if(PopupPanel._POPUP_PANELS.hasOwnProperty(id)) 
			return PopupPanel._POPUP_PANELS[id];
		return undefined;
	}

    static hidePanel(id) {
        var panel = PopupPanel.getPanel(id);
        if(panel)
            panel.hide();
    }

    static hideLast() {
        if(PopupPanel._POPUP_PANELS.hasOwnProperty('visible') && PopupPanel._POPUP_PANELS.visible.length) {
            let popupid = PopupPanel._POPUP_PANELS.visible[PopupPanel._POPUP_PANELS.visible.length-1];
            PopupPanel.hidePanel(popupid);
            return PopupPanel._POPUP_PANELS.visible.length;
        }
        return false;
    }

    static hideAll() {
        while(PopupPanel.hideLast());
    }

    static getConfirmHTML() {
        return '' +
            '<div id="confirmaction" class="controls popup modal">' +
                '<div class="dtcard">' +
                    '<div class="dtcard-header">' +
                        '<h3 id="confirmaction-title" class="draggable"></h3>' +
                    '</div>' +
                    '<div class="dtcard-body">' +
                        '<div class="text-justify" id="confirmaction-data"></div>' +
                        //'<hr>' +
                        '<p id="confirmaction-msg" class="text-center mb-1"></p>' +
                        //'<hr>' +
                    '</div>' +
					'<div class="dtcard-footer">' +
						'<div class="mt-3 panel-buttons">' +
                            '<div></div>' +
                            '<div><a class="btn btn-sm btn-block btn-primary" id="confirmaction-no">No</a></div>' +
                            '<div><a class="btn btn-sm btn-block btn-danger" id="confirmaction-yes">Yes</a></div>' +
                            '<div></div>' +
                        '</div>' +
					'</div>' +
                '</div>' +
            '</div>';
    }
	
	static getPopupInformationHTML() {
        return '' +
            '<div id="popupinformation" class="controls popup modal">' +
                '<div class="dtcard">' +
                    '<div class="dtcard-header">' +
                        '<h3 id="popupinformation-title" class="draggable"></h3>' +
                    '</div>' +
                    '<div class="dtcard-body">' +
                        '<div class="text-justify" id="popupinformation-data"></div>' +
                        //'<hr>' +
                        '<p id="popupinformation-msg" class="text-center mb-1"></p>' +
                        //'<hr>' +
                    '</div>' +
					'<div class="dtcard-footer">' +
						'<div class="mt-3 panel-buttons">' +
                            '<div></div>' +
							'<div></div>' +
							'<div></div>' +
                            '<div><a class="btn btn-sm btn-block btn-primary" id="popup-close">Close</a></div>' +
                        '</div>' +
					'</div>' +
                '</div>' +
            '</div>';
    }

    static confirmAction(option) {
        var confirm = PopupPanel.getPanel('confirmaction');
		if(!confirm) {
            $("body").append(PopupPanel.getConfirmHTML);
			$('#confirmaction-title').html(option.title);
			$('#confirmaction-data').html(option.information);
			$('#confirmaction-msg').html(option.message);
			confirm = new PopupPanel('confirmaction', {removeOnClose:true});

            $('#confirmaction-no').click(function() {
                PopupPanel.hidePanel('confirmaction');
            });

            $('#confirmaction-yes').click(function() {
                PopupPanel.hidePanel('confirmaction');
                option.onyes(option.data);
            });
		}
    }
	
	static showInformation(option) {
        var confirm = PopupPanel.getPanel('popupinformation');
		if(!confirm) {
            $("body").append(PopupPanel.getPopupInformationHTML);
			$('#popupinformation-title').html(option.title);
			$('#popupinformation-data').html(option.information);
			$('#popupinformation-msg').html(option.message);
			confirm = new PopupPanel('popupinformation', {removeOnClose:true});

            $('#popupinformation-close').click(function() {
                PopupPanel.hidePanel('popupinformation');
            });
		}
    }

    constructor(id, options={}) {
        this.popupid = id;
        this.options = options;

        if(!this.options.hasOwnProperty('show'))
            this.options['show'] = true;
        
        if(this.options.show)
           this.show();
        $('#'+id).draggable({handle: 'h3', containment: 'window' });
        PopupPanel._POPUP_PANELS[id] = this;

        if(!PopupPanel._POPUP_PANELS.hasOwnProperty('escapehandler')) {
            var thisobj = this;
            $(document).keydown(function(event) { 
                if (event.keyCode == 27) { 
                    event.preventDefault();
                    PopupPanel.hideLast();
                }
            });
            PopupPanel._POPUP_PANELS['escapehandler'] = true;
        }
    }

    setOption(key, value) {
        this.options[key] = value;
    }

    isModal() {
        return ($('#'+this.popupid).hasClass('modal')) || (this.options.modal !== undefined && this.options.modal === true);
    }

    getOptions() {
        return this.options;
    }

    show() {
        if(this.isModal()) {
            var appendthis =  ("<div class='modal-overlay'></div>");
            $("body").append(appendthis);
            $(".modal-overlay").fadeTo(500, 0.7);
            $('#'+this.popupid).css('z-index', 1000);
        }

        $('#'+this.popupid).show();

        if(typeof this.options.left === 'undefined')
            this.options.left = ($(window).width()/2)-($('#'+this.popupid).outerWidth()/2);
        if(typeof this.options.top === 'undefined')
            this.options.top = ($(window).height()/2)-($('#'+this.popupid).outerHeight()/2);
        $('#'+this.popupid).css('left', this.options.left);
        $('#'+this.popupid).css('top', this.options.top);

        if(!PopupPanel._POPUP_PANELS.hasOwnProperty('visible'))
            PopupPanel._POPUP_PANELS['visible'] = [];
        PopupPanel._POPUP_PANELS.visible.push(this.popupid);

        var popupid = this.popupid;
        $('#' + popupid + ' #popup-close').click(function() {
            PopupPanel.hidePanel(popupid);
        });
    }

    hide() {
        if(this.isModal()) {
            $(".modal-overlay").fadeOut(200, function() {
                $(".modal-overlay").remove();
            });
        }
        $('#'+this.popupid).hide();
        if(PopupPanel._POPUP_PANELS.hasOwnProperty('visible'))
            PopupPanel._POPUP_PANELS.visible.pop();
            
        if(PopupPanel._POPUP_PANELS.hasOwnProperty(this.popupid))
            delete PopupPanel._POPUP_PANELS[this.popupid];

        if(this.options.removeOnClose)
            $('#'+this.popupid).remove();
    }

    isVisible() {
        return $('#'+this.popupid).is(':visible');
    }
}
