<?php
###############################################################################
# testpad.php
#
#
# @author Anil Kumar <akumar@codepunch.com>
# @link   https://codepunch.com
#
############################################################################### 

require 'lib/php/loader.php';

###############################################################################

use CodePunch\Base\Util as UTIL;
use	CodePunch\Base\Text as TEXT;
use Doctrine\DBAL\DBALException;

###############################################################################

try {
	$auth = new \CodePunch\Config\Auth(\CodePunch\DB\Database::READONLY_TABLES);
	if($auth) {
		$db = $auth->getDatabase();
		$luManager = new \CodePunch\LU\LookupManager($auth);
		if($db) {
			UTIL::print("OK");
		}
	}
}
catch(Exception $e) {
	$logger = new \CodePunch\Base\CPLogger();
	$logger->error($e->getMessage());
	if(UTIL::is_cli()) {
		UTIL::print($e->getMessage());
	}
	else {
		$layout = new \CodePunch\UI\Layout();
		$pageinfo = array(
		'heading'=>'<h3>There was a Problem!</h3>',
		'body'=>$e->getMessage() . " - " . $e->getFile() . " - " . $e->getLine()
		);
		$layout->show($pageinfo);
	}
	exit;
}

###############################################################################

?>
