<?php
###############################################################################
# index.php
# SAML Handler
#
# @author Anil Kumar <akumar@codepunch.com>
# @link   https://codepunch.com
#
############################################################################### 

require 'lib/php/loader.php';
session_start();

###############################################################################

use 	CodePunch\Base\Util as UTIL;
use		CodePunch\Base\Text as TEXT;
use 	CodePunch\Config\Auth as AUTH;
error_reporting(E_ALL ^ (E_NOTICE | E_WARNING | E_DEPRECATED));

###############################################################################

try {
	$auth = new \CodePunch\Config\Auth();
	$setup = new \CodePunch\Config\Settings($auth);
	$samlidp = $setup->getOption("saml_idp", "");
	if($samlidp != "") {
		$class = "\\CodePunch\\Config\\SAML\\" . $samlidp;
		if(class_exists($class)) {
			$saml = new $class($auth);
			if (isset($_GET['sso'])) 
				$saml->login();
			else if (isset($_GET['slo'])) 
				$saml->logout(); 
			else if (isset($_GET['acs'])) 
			   $saml->ACS();
			else if (isset($_GET['sls'])) 
			   $saml->SLS();
			else if (isset($_GET['lo'])) {
				UTIL::print("Logged out");
				exit;
			}
			$saml->process();
			exit;
		}
	}
	throw new Exception(TEXT::get("saml_invalidsetup"));
}
catch(Exception $e) {
	$logger = new \CodePunch\Base\CPLogger();
	$logger->error($e->getMessage());
	$layout = new \CodePunch\UI\Layout(null, $e->getMessage());
	$pageinfo['heading'] = "<h1>" . TEXT::get("db_therewasaproblem") . "</h1>";
	$pageinfo['body'] = "<p class=\"problem\">" . $e->getMessage() . "</p>";
	$layout->show($pageinfo);
	exit;
}

###############################################################################
