<?php
###############################################################################
# Reports.php
#
#
# @author Anil Kumar <akumar@codepunch.com>
# @link   https://codepunch.com
#
############################################################################### 

namespace 	CodePunch\UI\Modules;

use 		CodePunch\Base\Util as UTIL;
use			CodePunch\Base\Text as TEXT;
use 		Exception;

###############################################################################

class Reports {

	###########################################################################
	
	public function get($auth) 
	{		
		$pagecontent = array();
		if($auth && $auth->isAdmin()) {
			$folder = UTIL::get_install_folder_path();
			$datafile = $folder . "lib/layouts/default/reports/reports.inc.htm";
			$pagecontent['heading'] = "<h1>" . TEXT::get("Domain Reports") . "</h1>";
			$pagecontent['body'] = file_get_contents($datafile);
		}
		else {
			$pagecontent['heading'] = "<h1>" . TEXT::get("Problem") . "</h1>";
			$pagecontent['body'] = "<p>Access Denied</p>";
		}
		$pagecontent['template'] = "reports";
		return $pagecontent;
	}
	
	###########################################################################
}
