<?php
###############################################################################
# IPWhois.php
#
# @author Anil Kumar <akumar@codepunch.com>
# @link   https://codepunch.com
#
############################################################################### 

namespace 	CodePunch\LU;
use 		CodePunch\Base\Util as UTIL;
use			CodePunch\Base\Text as TEXT;

###############################################################################

class IPWhois  {
	
	private $lookupManager = null;
	
	###########################################################################
	
	public function __construct($lum=null) {
		$this->lookupManager = $lum;
	}
	
	###############################################################################

	public function lookup(&$ludata)
	{
		$db = $this->lookupManager->getAuthentication()->getDatabase();
		$did = $ludata['sid'];
		$domain = $db->getDomainName($did);
		$lookupcount = 0;
		if($did !== false && $did > 0) {
			$dataarray = $this->domainipwhois($domain);
			if(count($dataarray)) {
				//$status = $db->updateDomainTable($dataarray);
				$status = $this->lookupManager->updateDomainTable(\CodePunch\LU\LookupManager::IP_WHOIS, $dataarray);
				if($status !== false)
					$lookupcount++;
			}
		}
		$ludata['status'] = \CodePunch\LU\LookupManager::LUQ_COMPLETE;
		return $lookupcount;
	}
	
	###############################################################################

	private function ipwhois($ip, $whoisserver, $port=43)
	{
		$whoisserver = strtolower($whoisserver);
		$query = trim($ip);
		$validip = filter_var($query, FILTER_VALIDATE_IP);
		if($whoisserver == "whois.arin.net" && $validip == $query && $query != "")
			$query = "n " . $query;
		else if($whoisserver == "whois.arin.net" && $query != "")
			$query = "z " . $query;
		
		$m_connectiontimeout = 10;
		$m_sockettimeout = 30;
		$output = UTIL::Whois($query, $whoisserver, $port, $m_connectiontimeout);
		if($output['status'] === false) 
			$data = "Error - unable to connect to $whoisserver\n\n" . $output['error'];
		else
			$data = $output['data'];
		return $data;
	}
	
	###############################################################################

	public function whois($ip)
	{
		$whoisserver = "whois.arin.net";
		$data = $this->ipwhois($ip, $whoisserver);
		if(stristr($data, "ReferralServer:")) {
			$port = 43;
			$p1 = trim(UTIL::get_string_between($data, "ReferralServer:", "\n"));
			$p1 = str_replace("rwhois://", "", $p1);
			$p1 = str_replace("whois://", "", $p1);
			$s1 = strpos($p1, ":");
			if($s1 !== false)
			{
				$port = substr($p1, $s1+1);
				$p1 = substr($p1, 0, strlen($p1)-strlen($port)-1);
			}
			$whoisserver = $p1;
			$ndata = $this->ipwhois($ip, $whoisserver, $port);
			if(strlen($ndata) > 200)
				$data = $ndata;
		}
		else if(stristr($data, "Allocated to APNIC")) {
			$whoisserver = "whois.apnic.net";
			$data = $this->ipwhois($ip, $whoisserver);
		}
		else if(stristr($data, "Allocated to RIPE")) {
			$whoisserver = "whois.ripe.net";
			$data = $this->ipwhois($ip, $whoisserver);
		}
		else if(stristr($data, "Allocated to AfriNIC")) {
			$whoisserver = "whois.afrinic.net";
			$data = $this->ipwhois($ip, $whoisserver);
		}
		else if(stristr($data, "Allocated to LACNIC")) {
			$whoisserver = "whois.lacnic.net";
			$data = $this->ipwhois($ip, $whoisserver);
		}
		else if(stristr($data, "NetHandle:")) {
			$handle = trim(UTIL::get_string_between($data, "NetHandle:", "\n"));
			$data = $this->ipwhois($handle, $whoisserver);
		}
		else {
			$dcopy = $data;
			$netblocks = array();
			while(1)
			{
				$p1 = trim(UTIL::get_string_between($dcopy, "(NET", ")", true));
				if($p1 != "")
				{
					$netblocks[] = substr($p1, 1, strlen($p1)-2);
					$dcopy = str_replace($p1, "", $dcopy);
				}
				else
					break;
			}
			$count = count($netblocks);
			if($count)
			{
				$lookup = $netblocks[$count-1];
				$data = $this->ipwhois($lookup, $whoisserver);
			}
		}
		
		$db = $this->lookupManager->getAuthentication()->getDatabase();
		$parser = new \CodePunch\LU\WhoisParser($db, $data, $whoisserver);
		$dataarray = $parser->genericIPWhoisParser();
					
		return $dataarray;
	}

	###############################################################################
	
	function domainipwhois($domain_name)
	{
		$db = $this->lookupManager->getAuthentication()->getDatabase();
		$ip = $db->findOneOf($db->getDomainTableName(), "domain", $domain_name, "ip");
		if($ip === false || $ip == "") {
			$sid = $db->findOneOf($db->getDomainTableName(), "domain", $domain_name, "sid"); 
			if($sid > 0) {
				$host = UTIL::idn_convert_to_host_name($domain_name, "");
				$ip = gethostbyname($host);
				if($ip == $host)
					$ip = "";
			}
		}
		$data_array = array();
		if($ip != "" && $ip != "-" && $ip != "error" && $ip !== false)
			$data_array = $this->whois($ip);
		$data_array['ip_whois_at'] = date("Y-m-d H:i:s");
		$data_array['domain'] = $domain_name;
		return $data_array;
	}

}

###############################################################################
