// Panels
// Rules
// One one panel may be visible at a time.
// Modal Panels will prevent interaction with the 
// rest of the application till it is dismissed

function getPanelHeight(ewh) {
	return ewh-0-150;
}

/////////////////////////////////////////////////////////////////////////////////////////

function showPanel(panelid, dir)
{
	hideAllPanelsExcept(panelid);
	var buttonid = panelid.replace("panel-", "");
	
	var ww = $(window).width();
	var wh = $(window).height();
	
	var hh = 0;
	if($("#header").length != 0)
		hh = $('#header').height();
	var fh = 0;
	if($("#footer").length != 0)
		fh = $('#footer').outerHeight();
	
	var ewh = wh-hh-fh;
	var popmenuwidth = $('#popmenu').is(':visible') ? $('#popmenu').width() : 0;
	
	var toppos = 0;//$('#' + buttonid).offset();
	var top = hh;
	if(typeof toppos !== 'undefined')
		top = toppos.top - ($('#' + panelid).height()/2) - 60;
	if(top < hh)
		top = hh+5;
	
	var topoffset = $('#' + buttonid).data('topoffset');
	if(typeof topoffset !== 'undefined')
		top = topoffset;
	
	var pmaxwidth = ww*2/5;
	if(pmaxwidth < 500 && ww >= 768)
		pmaxwidth = 500;
	else if(pmaxwidth < 320 && ww >= 320)
		pmaxwidth = ww;
	
	var lpw = $('#leftpane').width();
	if(typeof lpw === 'undefined')
		lpw = 0;
	
	var pminwidth = 0;
	if($('#' + panelid).hasClass('panel-wide') || $('#' + panelid).hasClass('panel-medium')) {
		pminwidth = ww < 768 ? ww : (ww-popmenuwidth-lpw);
		if(pminwidth < 768 && ww > pminwidth)
			pminwidth = ww;
		var mw = $('#' + panelid).hasClass('panel-medium') ? 480 : 720;
		pminwidth = pminwidth > mw ? mw : pminwidth
		$('#' + panelid).css('min-width', pminwidth); 
	}
	if($('#' + panelid).hasClass('panel-widest')) {
		pminwidth = ww;
		$('#' + panelid).css('min-width', pminwidth); 
	}
	
	var pmaxheight = getPanelHeight(ewh);
	if(pmaxheight > wh) {
		pmaxheight = wh;
		top = 0;
	}
	
	if(panelid.indexOf("-alert") >= 0) {
		$('#'+panelid).css('width', ww-popmenuwidth);
		$('#'+panelid).css('bottom', fh);
		$('#'+panelid).css('top', 'auto');
		$('#'+panelid).css('right', 0);
		$('#'+panelid).css('border-radius', 0);
	}
	else {
		if(ww < 768) {
			$('#'+panelid).css('bottom', 0);
			top = 0;
			pmaxheight = wh-140;
		}
		if(pmaxwidth < pminwidth)
			pmaxwidth = pminwidth;
		$('#'+panelid).css('max-width', pmaxwidth);
		$('.panel-card-body').css('max-height', pmaxheight);
		$('#' + panelid).css('top', top);
	}
	
	if(dir == "left") {
		var pw = pminwidth > pmaxwidth ? pminwidth : pmaxwidth;
		var leftpos = lpw+popmenuwidth;
		if((pw+leftpos) > ww)
			leftpos = (ww-pw) < 0 ? 0 : (ww-pw);
		leftpos = (leftpos-popmenuwidth) < 0 ? 0 : (leftpos-popmenuwidth);
		$('#'+panelid).css('left', leftpos);
		$('#'+panelid).css('right', 'auto');
	}
	else {
		var right = ww < 768 ? 0 : popmenuwidth;
		$('#'+panelid).css('right', right);
		$('#'+panelid).css('left', 'auto');
	}
	
	var fnName = panelid.replace("panel-", "") + "_before_popup";
	try {
		if(typeof window[fnName] == "function")
			processed = window[fnName]();
	}
	catch(err) {
		console.log('Error: '+ fnName + ': ' + err);
	}
	
	if(!$('#' + panelid).is(':visible')) 
		$('#' + panelid).show("drop",  {direction:dir}, 600 );
}

/////////////////////////////////////////////////////////////////////////////////////////

function getPanelBodyHeight()
{
	var ww = $(window).width();
	var wh = $(window).height();
	var hh = $('#header').height();
	var fh = $('#footer').outerHeight();
	var ewh = wh-hh-fh;
	var pmaxheight = getPanelHeight(ewh);
	if(pmaxheight > wh) 
		pmaxheight = wh;
	if(ww < 768) {
		$('#'+panelid).css('bottom', 0);
		top = 0;
		pmaxheight = wh-140;
	}
	return pmaxheight;
}

/////////////////////////////////////////////////////////////////////////////////////////

function hideAllPanelsExcept(panelid)
{
	var found = false;
	var zi = parseInt($('#hider').css("z-index"), 10);
	$(".panel").each(function() {
		var pid = $(this).attr('id');
		if(panelid != pid) {
			if(pid.indexOf("-alert") < 0 || panelid == "non-existent") {
				$('#' + pid).css("z-index", "auto");
				hidePanelWithId(pid);
			}
		}
		else {
			found = true;
			var pzi = zi+1;
			if(panelid.indexOf("alert") > 0)
				pzi = zi++;
			$('#' + panelid).css("z-index", pzi);
			$('#' + panelid).css("top", 50);
		}
	});
	if($('#' + panelid).hasClass("panel-modal")) {
		$("#hider").css("background-color", 'rgba(0,0,0,0.7)');
		$("#hider").fadeIn("slow");
	}
	else
		$('#hider').hide();
}

/////////////////////////////////////////////////////////////////////////////////////////

function hidePanelWithId(panelid)
{
	if($('#' + panelid).is(':visible')) {
		
		var fnName = "close_" + panelid;
		fnName = fnName.replace(/-/g, "_");
		var processed = false;
		try {
			if(typeof window[fnName] == "function")
				processed = window[fnName]();
		}
		catch(err) {
			console.log('Error: '+ fnName + ': ' + err);
		}
		if(!processed) {
			//$('#' + panelid).hide("drop",  {direction:'right'}, 600 );
			$('#' + panelid).fadeOut("slow");
		}
		if($('#' + panelid).hasClass("panel-modal"))
			$("#hider").fadeOut("slow");
		return true;
	}
	return false;
}

/////////////////////////////////////////////////////////////////////////////////////////

function hideAllPanels()
{
	// Remember not to name any panel "non-existent"
	hideAllPanelsExcept("non-existent");
}

function hideAllPanelsOnEscape()
{
	hideAllPanels();
}

/////////////////////////////////////////////////////////////////////////////////////////

function showAlert(message)
{
	$('#alert-message').html(message);
	showPanel('panel-alert', 'bottom');
}

/////////////////////////////////////////////////////////////////////////////////////////

function showPopup(heading, message, title)
{
	$('#popup-title').html(title);
	$('#popup-heading').html(heading);
	$('#popup-message').html(message);
	showPanel('panel-popup', 'left');
}

/////////////////////////////////////////////////////////////////////////////////////////
/* jQuery.values: get or set all of the name/value pairs from child input controls   
 * @argument data {array} If included, will populate all child controls.
 * @returns element if data was provided, or array of values if not
*/

$.fn.values = function(data) {
	var els = this.find(':input').get();

	if(arguments.length === 0) {
		// return all data
		data = {};

		$.each(els, function() {
			if (this.name && !this.disabled && (this.checked
							|| /select|textarea/i.test(this.nodeName)
							|| /text|hidden|password/i.test(this.type))) {
				if(data[this.name] == undefined){
					data[this.name] = [];
				}
				data[this.name].push($(this).val());
			}
		});
		return data;
	} else {
		$.each(els, function() {
			if (this.name && data[this.name]) {
				var names = data[this.name];
				var $this = $(this);
				if(Object.prototype.toString.call(names) !== '[object Array]'){
					names = [names]; //backwards compat to old version of this code
				}
				if(this.type == 'checkbox' || this.type == 'radio') { 
					var val = $this.val();
					var found = false;
					for(var i = 0; i < names.length; i++){
						if(names[i] == val){
							found = true;
							break;
						}
					}
					$this.attr("checked", found);
				} else {
					$this.val(names[0]);
				}
			}
		});
		return this;
	}
};

/////////////////////////////////////////////////////////////////////////////////////////



