/////////////////////////////////////////////////////////////////////////////////////////

function saveCookie(name, value)
{
	$.cookie(name, value, {expires:30});
}

/////////////////////////////////////////////////////////////////////////////////////////

function getCookie(name, defval)
{
	var value = $.cookie(name);
	if(value == "" || value == null)
		return defval;
	return value
}

/////////////////////////////////////////////////////////////////////////////////////////

function getCookieInt(name, defval)
{
	var value = $.cookie(name);
	if(value == "" || value == null || isNaN(value))
		return defval;
	return Math.round(parseFloat(value));
}

/////////////////////////////////////////////////////////////////////////////////////////

function getCookiePercent(name, defval)
{
	var value = getCookieInt(name, defval);
	if(value < 0 || value > 100)
		value = defval;
	return value;
}
