/////////////////////////////////////////////////////////////////////

function HandleEscapeKey(e) {
	var hidden = 0;
	var keycode = (e.keyCode ? e.keyCode : (e.which ? e.which : e.charCode));
	if (keycode == 27) {
		hideAllPanelsOnEscape();
	}
	return true;
}

/////////////////////////////////////////////////////////////////////

function adddomains_reset() {
	$('#domaindata').val('');
	$('.cb-regapilist').prop('checked', false);
}

/////////////////////////////////////////////////////////////////////

function adddomains_submit() {
	var user_entry_data = $('#domaindata').val();
	var tlds = $('#appendtlds').val();
	var catid = getCookieInt('current_category', 0);
	if($('#catadd').is(':checked') == false && catid > 1)
		catid = 0;
	if($('#catempty').is(':checked') == true && catid > 1 && allow_category_edit())
		add_domains(user_entry_data, tlds, catid, true);
	else
		add_domains(user_entry_data, tlds, catid, false);
}

/////////////////////////////////////////////////////////////////////

function adddomains_apisetup()
{
	init_panel_apisetup();
	showPanel("panel-apisetup");
}

/////////////////////////////////////////////////////////////////////

function initButtons()
{
	$(".btn-menu, .btn-dlg").mouseover(function(event){
		$(this).css("background-color", theme['button']['hover']['bg']);
		$(this).css("border-color", theme['button']['hover']['border']);
		$(this).css("color", theme['button']['hover']['text']);
	});
	$(".btn-menu,.btn-dlg").mouseout(function(event){
		if($(this).hasClass('.btn-selected')) {
			$(this).css("background-color", theme['button']['select']['bg']);
			$(this).css("color", theme['button']['select']['text']);
			$(this).css("border-color", theme['button']['select']['border']);
		}
		else {
			$(this).css("background-color", theme['button']['normal']['bg']);
			$(this).css("color", theme['button']['normal']['text']);
			$(this).css("border-color", theme['button']['normal']['border']);
		}
	});
	
	$(".btn-menu, .btn-dlg").css("color", theme['button']['normal']['text']);
	$(".btn-menu, .btn-dlg").css("background-color", theme['button']['normal']['bg']);
	$(".btn-menu, .btn-dlg").css("border-color", theme['button']['normal']['border']);
	
	$(window).keydown(function(event) {
		if(!HandleEscapeKey(event))
			return false;
	});
	
	$('.close-button').click(function(event){
		event.preventDefault();
		hideAllPanels();
	});
	
	$('.btn-queue').click(function(event){
		event.preventDefault();
		var cpid = $(this).attr('id');
		if(cpid.substr(0,5) == "luqa-") {
			var luqtype = cpid.replace("luqa-", "");
			doLookups(luqtype);
		}
	});
	
	$('.btn-dlg-cancel').click(function(event){
		event.preventDefault();
		var parentPanel = $(this).closest('.panel').attr('id');
		if($('#'+parentPanel).length)
			hidePanelWithId(parentPanel);
		else
			hideAllPanels();
	});
	
	$('.btn-dlg-ok').click(function(event){
		event.preventDefault();
		var cpid = $(this).attr('id');
		var fnName = cpid.replace(/-/g, "_");
		try {
			if(typeof window[fnName] == "function")
				window[fnName]();
		}
		catch(err) {
			console.log('Error: ' + cpid + ": " + err);
		}
	});
	
	$('.btn-menu').click(function(event){
		if(!$(this).hasClass("btn-nav") && !$(this).hasClass("btn-dlg")) {
			event.preventDefault();
			var cpid = $(this).attr('id');
			if(cpid.substr(0,5) == "luqw-") {
				var luqtype = cpid.replace("luqw-", "");
				deleteLookupQueue(luqtype);
			}
			else if($('#panel-' + cpid).is(':visible')) 
				hidePanelWithId('panel-'+cpid);
			else {
				var fnName = "init_panel_" + cpid;
				var processed = false;
				try {
					if(typeof window[fnName] == "function")
						processed = window[fnName]();
				}
				catch(err) {
					console.log('Error: '+ fnName + ': ' + err);
				}
				if(!processed)
					showPanel("panel-" + cpid, 'right');
			}
		}
	});
	
	$(document).on('change', '.btn-file :file', function() 
	{
		var filename = $('#csv_file').val();
		filename = filename.replace(/^.*[\\\/]/, '');
		$('#csv_name').val(filename);
	});
	
	$('#btn-logout').click(function(event){
		event.preventDefault();
		var page = app_current_url.replace(".php", "");
		if(page == "")
			page = "index";
		window.location = app_root_url + "?logout&return=" + encodeURIComponent(page);
	});
	$('#btn-monitor').click(function(event){
		event.preventDefault();
		window.location = app_root_url + "monitor.php";
	});
	$('#btn-domaintable,.btn-domaintable').click(function(event){
		event.preventDefault();
		window.location = app_root_url + "domains.php";
	});
	$('#btn-dashboard').click(function(event){
		event.preventDefault();
		window.location = app_root_url + "dashboard.php";
	});
	$('#btn-toolbox,.btn-toolbox').click(function(event){
		event.preventDefault();
		window.location = app_root_url + "toolbox.php";
	});
	$('#btn-navbarmenu').click(function(event){
		event.preventDefault();
		window.location = app_root_url + "dashboard.php";
	});
	$('#btn-reports,.btn-reports').click(function(event){
		event.preventDefault();
		window.location = app_root_url + "reports.php";
	});
	$("#btn-verify").click(function(event){
		event.preventDefault();
		window.location = app_root_url + "verify.php";
	});
	$("#btn-settings").click(function(event){
		event.preventDefault();
		window.location = app_root_url + "admin.php";
	});
	$("#sedhome").click(function(event){
		event.preventDefault();
		window.open(app_root_url + "?link=home");
	});
	$("#userguide").click(function(event){
		event.preventDefault();
		window.open(app_root_url + "?link=guide");
	});
	$("#contactus").click(function(event){
		event.preventDefault();
		window.open(app_root_url + "?link=contact");
	});
	$(".btn-check-updates").click(function(event){
		event.preventDefault();
		window.open(app_root_url + "?link=changelog");
	});
	$("#btn-buy-now").click(function(event){
		event.preventDefault();
		window.open(app_root_url + "?link=buy");
	});
	
	$("#btn-reset-license").click(function(event){
		event.preventDefault();
		resetLicense();
	});
}


function ajax_reset_license(x, jqXHR, textStatus, params)
{
	if(x != null) {
		if(x.status == 'ok') {
			window.location = app_root_url;
		}
	}
}

function ajax_add_license(x, jqXHR, textStatus, params)
{
	window.location = app_root_url;
}

function set_license_code()
{
	var code = $('#license-code').val();
	var datastr = "c=add&t=license&data=" + encodeURIComponent(code);
	ajax_call(datastr, ajax_add_license, null);
}

function confirm_resetLicense()
{
	var datastr = "c=admin&t=license&oper=set&data=" + encodeURIComponent("-");
	ajax_call(datastr, ajax_reset_license, null);
}

function resetLicense()
{
	
	$('#confirm-message').html("<h4>Are you sure you want to reset your license?</h4><p>You will not be able to access the application unless you provide a new valid license code.</p>");
	$('#confirm-caller').val("confirm_resetLicense");
	showPanel("panel-confirm");
}

function btn_confirm_action()
{
	var fnName = $('#confirm-caller').val();
	try {
		if(typeof window[fnName] == "function")
			window[fnName]();
	}
	catch(err) {
		console.log('Error: ' + fnName + ": " + err);
	}
	hidePanelWithId("panel-confirm");
}

