
/////////////////////////////////////////////////////////////////////////////////////////

function ajax_parse(msg)
{
	try {
		x = jQuery.parseJSON(msg);
		if(typeof x.validate != "undefined") {
			if(x.validate == 1)
				sessionRestart("auth_error_session_timeout");
			else if(x.validate == -1 || x.validate == -2)
				sessionRestart("notloggedin");
		}
		return x;
	}
	catch(err) {
		console.log('Error: JSON Parser');
	}
	return [];
}

/////////////////////////////////////////////////////////////////////////////////////////

function ajax_call(datastr, callbackFn, param)
{
	var ajax_url = app_root_url + api_url_path;
	var request = $.ajax({type: "POST",	url: ajax_url, data: datastr});
	request.done(function(msg) {  
		var x = ajax_parse(msg);
		callbackFn(x, null, null, param);
	});
	request.fail(function(jqXHR, textStatus) {
		callbackFn(null, jqXHR, textStatus, param);
	});
}

/////////////////////////////////////////////////////////////////////////////////////////

function ajax_formdata_call(fd, callbackFn, param)
{
	var ajax_url = app_root_url + api_url_path;
	var request = $.ajax({type: "POST",	url: ajax_url, data: fd, contentType: false, processData: false, cache: false});
	request.done(function(msg) {  
		var x = ajax_parse(msg);
		callbackFn(x, null, null, param);
	});
	request.fail(function(jqXHR, textStatus) {
		callbackFn(null, jqXHR, textStatus, param);
	});
}

/////////////////////////////////////////////////////////////////////////////////////////

function ajax_dummy_return(x, jqXHR, textStatus, params)
{
	if(x != null) {
		if(x.status == 'ok') {
		}
	}
}

/////////////////////////////////////////////////////////////////////////////////////////

function sessionRestart(reason)
{
	var location = app_root_url + "?logout&r=" + reason;
	window.location = location;
}

/////////////////////////////////////////////////////////////////////////////////////////
