var allow_hidden_leftpane = true;
var gutter_size = 6;

function initSplitter()
{
	setupPanes();
	setupTabs();
	fixDivSizes();
}

/////////////////////////////////////////////////////////////////////////////////////////
// The width percentages are tricky. Make sure that 
// the width calculated from percentage is not less 
// than the minSize (in pixels) specified

function setupPanes()
{
	var ww = $(window).width();
	// Percentage corresponding to 6 pixels
	var minwidth = (6/ww)*100; 
	var lp01 = getCookiePercent("left-pane-width", 20);
	
	// Hide leftpane in small screens
	if(ww >= 768 && lp01 < 20 && !allow_hidden_leftpane)
		lp01 = 20;
	if(lp01 < minwidth || ww <= 767)
		lp01 = minwidth;
	
	var lp02 = 100 - lp01;
	Split(['#leftpane', '#reportpane'], {
		sizes: [lp01, lp02],
		minSize: [2,150],
		snapOffset: 10,
		gutterSize: gutter_size,
		onDragEnd: function() {
			var lw = $("#leftpane").width();
			var rw = $("#reportpane").width();
			var p = lw * 100 / (lw+rw);
			saveCookie("left-pane-width", p);
			fixDivSizes();
			setTimeout(function(){fixDivSizes();}, 50);
		}
	});
	
	$(window).scroll(function () 
	{
		fixDivSizes();
	});
}

/////////////////////////////////////////////////////////////////////////////////////////

function setupTabs()
{
	$('#categorytab').tabs(
	{
		activate: function(event ,ui) 
		{
			var active = $('#categorytab').tabs('option', 'active');
			$.cookie('category_tab', active);
			fixDivSizes();
			fixDivSizes();
		}
    });
	var cti = getCookieInt('category_tab', 0);
	if(cti >= 0 && cti < 3)
		$( "#categorytab" ).tabs("option", "active", cti);
}
