
/////////////////////////////////////////////////////////////////////////////////////////

function download_report_data()
{
	var reportname = getCookie('current_report', "Subdomain Records");
	var filename = $('#download_file_name').val();
	var delimiter = $('#download_delimiter').val();
	var coltype = $('#column-type').val();
	downloadReportTableRows(reportname, coltype, filename, delimiter);
}

/////////////////////////////////////////////////////////////////////////////////////////

function init_panel_download()
{
	var datastr = get_ajax_datastr("download", "csvdata", "get");
	ajax_call(datastr, ajax_init_downloadlist, null);
	
	$('#download-error').html('');
	
	var reportname = getCookie('current_report', "Subdomain Records");
	$('#download_report_name').html(reportname);

	$("#download-bgprocess").off('change');
	$("#download-bgprocess").change(function(event){
		downloadModeChanged();
	});
	downloadModeChanged();
}

/////////////////////////////////////////////////////////////////////////////////////////

function ajax_init_downloadlist(x, jqXHR, textStatus, params)
{
	if(x != null) {
		$('#download-error').html('');
		var cbdata = '';
		if(x.status == 'ok') {
			var count = x.data.length;
			for(var i = 0; i < count; i++) {
				var name = x.data[i].name;
				var id = parseInt(x.data[i].id);
				var desc = x.data[i].description;
				if(desc != "")
					desc = " [" + desc + "]";
				if(id > 0) {
					cbdata += '<option value="' + id + '">' + name + desc + '</option>';
				}
			}
			$('#select_csv_report').html(cbdata);
		}
	}
}

/////////////////////////////////////////////////////////////////////////////////////////

function refresh_download_list()
{
	var datastr = get_ajax_datastr("download", "csvdata", "get");
	ajax_call(datastr, ajax_init_downloadlist, null);
}

/////////////////////////////////////////////////////////////////////////////////////////

function download_domain_report()
{
	$('#download-error').html('');
	var rid = $('#select_csv_report').val();
	if(parseInt(rid) > 0) {
		var datastr = get_ajax_datastr("download", "csvdata", "get");
		datastr += "&id=" + encodeURIComponent(rid);
		datastr += "&mode=csv"
		var posturl = app_root_url + api_url_path + "?";
		$("#csvdownload").append('<form id="exportform" action="' + posturl + datastr + '" method="post"></form>');
		$("#exportform").submit().remove();
	}
	return true;
}

/////////////////////////////////////////////////////////////////////////////////////////

function delete_domain_report()
{
	$('#download-error').html('');
	confirm_delete_domain_report();
}

/////////////////////////////////////////////////////////////////////////////////////////

function confirm_delete_domain_report()
{
	var rid = $('#select_csv_report').val();
	if(parseInt(rid) > 0) {
		var datastr = get_ajax_datastr("download", "csvdata", "del");
		datastr += "&id=" + encodeURIComponent(rid);
		ajax_call(datastr, ajax_init_downloadlist, null);
	}
}

/////////////////////////////////////////////////////////////////////////////////////////

function downloadModeChanged()
{
	var bgproc = $('#download-bgprocess').is(':checked') ? "1" : "0";
	if(parseInt(bgproc)) {
		$('#download-report-data').text('Schedule');
	}
	else {
		$('#download-report-data').text('Download Now');
	}
}

/////////////////////////////////////////////////////////////////////////////////////////

function downloadReportTableRows(reportname, coltype, filename, delimiter)
{
	$('#download-error').html('');
	var bgproc = $('#download-bgprocess').is(':checked') ? "1" : "0";
	var description = reportname;
	var posturl = app_root_url + api_url_path + "?";
	datastr = get_ajax_datastr("download", "domain", "");
	datastr += "&_repname=" + encodeURIComponent(reportname);
	datastr += "&csv_sep=" + encodeURIComponent(delimiter);
	datastr += "&description=" + encodeURIComponent(description);
	datastr += "&colmode=" + encodeURIComponent(coltype);
	datastr += "&mt=1";
	
	var sortname = $("#reportstable").jqGrid('getGridParam','sortname');
	var sortorder = $("#reportstable").jqGrid('getGridParam','sortorder');
	datastr += "&sidx=" + encodeURIComponent(sortname);
	datastr += "&sord=" + encodeURIComponent(sortorder);
	
	var aqid = getCookieInt('current_autoquery', 0);
	var cid = getCookieInt('current_category', 0);
	if(cid > 0)
		datastr += "&cid=" + cid;
	else if(aqid > 0)
		datastr += "&aqid=" + aqid;
	else if(custom_query_in_use) {
		var querydata = getCustomQueryData();
		datastr += "&" + querydata;
	}
	datastr += "&filename=" + encodeURIComponent(filename);
	if(parseInt(bgproc)) {
		datastr += "&bgproc=" + encodeURIComponent(bgproc);
		ajax_call(datastr, ajax_download_csvdata, null);
	}
	else {
		$("#csvdownload").append('<form id="exportform" action="' + posturl + datastr + '" method="post"></form>');
		$("#exportform").submit().remove();
		return true;
	}
}

/////////////////////////////////////////////////////////////////////////////////////////

function ajax_download_csvdata(x, jqXHR, textStatus, params)
{
	if(x != null) {
		if(x.status == 'ok') {
		}
		$('#download-error').html(x.error);
	}
}