var what_to_show = 0;
var sort_column_name = "d.r_h_disp";
var current_grid_page = 1;
var rows_per_grid_page = 50;
var total_grid_pages = 0;
var font_size_increment = 0;
var record_sorting_order = "ASC";
var data_card_class = "col-lg-6";

$(function() 
{
	what_to_show = getCookieInt("domain_monitor_group", 0);
	if(what_to_show == 0)
		show_domain_monitor();
	else if(what_to_show == 1)
		show_ssl_monitor();
	
	$('#domain-domain-expiry-report').off('click');
	$('#domain-domain-expiry-report').click(function(event){
		event.preventDefault();
		show_domain_monitor();
	});
	
	$('#domain-ssl-expiry-report').off('click');
	$('#domain-ssl-expiry-report').click(function(event){
		event.preventDefault();
		show_ssl_monitor();
	});
	
	initFilterLists();
	
	if(typeof user_details != "undefined") {
		if(user_details['uid'] >= 0) {
			showServerTime();
			setInterval(function() {showServerTime();}, 30000);
		}
	}
	
	$(window).bind('resize', function() {hideAllPanels(); resize_monitor_window(); setTimeout(function(){resize_monitor_window();}, 50);}).trigger('resize');

	$(window).keydown(function(event) {
		var keycode = (event.keyCode ? event.keyCode : (event.which ? event.which : event.charCode));
		if (keycode == 27)
			toggleControlBox('');
	});

	$('body').show();
});

function show_domain_monitor()
{
	what_to_show = 0;
	sort_column_name = "d.r_h_disp";
	record_sorting_order = "DESC";
	current_grid_page = 1;
	$('#category-list').val(1);
	$('#autoquery-list').val(1);
	populate_domain_list();
}

function show_ssl_monitor()
{
	what_to_show = 1;
	sort_column_name = "s.ssl_valid_to";
	record_sorting_order = "ASC";
	current_grid_page = 1;
	$('#category-list').val(1);
	$('#autoquery-list').val(1);
	populate_domain_list();
}

function resize_monitor_window()
{
	var wht = $(window).height();
	var wwd = $(window).width();
	var sbht = wwd > 767 ? wht : 'auto';
	$('#content-side').css('height', sbht);
	if(wwd > 767) {
		$('#biglogo').attr("src", header_logo_big_image);
		$('#biglogo').css("padding-bottom", '8px');
		var cdht = wht-$('.content-footer').height()-$('.content-header').height()-20-32-12+16;
		cdht -= $('#content-info').height()+16-12;
		$('.content-data').css('height', cdht);
		$('html').css('overflow-y', 'hidden');
	}
	else {
		$('#biglogo').attr("src", header_logo_image);
		$('#biglogo').css("padding-bottom", '8px');
		var cdht = wht-$('.content-footer').height()-$('.content-header').height()-24-$('#content-side').height()-24;
		cdht -= $('#content-info').height()+16-12;
		if(cdht < 300)
			cdht = 300;
		$('.content-data').css('height', cdht);
		$('html').css('overflow-y', 'auto');
	}

	var columnclass = data_card_class;
	if(wwd >= 2560)
		columnclass = "col-lg-2";
	else if(wwd >= 1920)
		columnclass = "col-lg-3";
	else if(wwd >= 1440)
		columnclass = "col-lg-4";
	else
		columnclass = "col-lg-6";
	if(columnclass != data_card_class) {
		$('.column-card').removeClass(data_card_class);
		$('.column-card').addClass(columnclass);
		data_card_class = columnclass;
	}
}

function populate_domain_list()
{
	var selected_category_id = $('#category-list').val();
	var selected_autoquery_id = $('#autoquery-list').val();
	setupMonitorFilters();
	
	var datastr = "";
	if(what_to_show == 0) {
		$('#domain-ssl-expiry-report').removeClass('btn-pager-select');
		$('#domain-domain-expiry-report').addClass('btn-pager-select');
		datastr = get_ajax_datastr("grid", "domain", "") + "&columns=sid,d.r_h_disp,d.domain,d.registry_expiry,d.ip,d.registrar_expiry,d.created_on,d.primary_whois_checked_at,d.registrar,d.home_page_title,d.availability,d.ip_asname,d.ns1,d.ns2,d.mx1,d.mx2,d.home_page_status";
		datastr += "&sidx=" + sort_column_name + "&sord=" + record_sorting_order + "&page=" + current_grid_page;
		$('#content-header-heading').html('Domain Records');
	}
	else if(what_to_show == 1) {
		$('#domain-domain-expiry-report').removeClass('btn-pager-select');
		$('#domain-ssl-expiry-report').addClass('btn-pager-select');
		var datastr = get_ajax_datastr("grid", "domain", "");
		datastr += "&columns=sid,s.hid,d.domain,s.hostname,s.ip,s.subdomain,d.registry_expiry,d.registrar_expiry,d.primary_whois_checked_at,d.home_page_title,s.ssl_valid_to,s.ssl_issued_by,s.ssl_issued_to,s.ptr,d.ssl_checked_at,s.subject_alt_name";
		datastr += "&sidx=" + sort_column_name + "&sord=" + record_sorting_order + "&page=" + current_grid_page;
		datastr += "&query=(s.ssl_valid_to IS NOT NULL AND s.auto_added = 2)";
		$('#content-header-heading').html('SSL Certificates');
	}
	saveCookie('domain_monitor_group', what_to_show); 
	datastr += "&rows=" + rows_per_grid_page;
	if(selected_category_id > 1)
		datastr += "&cid=" + selected_category_id;
	else if(selected_autoquery_id > 1)
		datastr += "&aqid=" + selected_autoquery_id;

	datastr += getSearchFilterParams();
	datastr = encodeURI(datastr);
	//console.log(datastr);
	ajax_call(datastr, ajax_get_domain_list, null);
}

function get_time_value(thedate) 
{
	try {
		return thedate.getTime();
	}
	catch(err) {
		//console.log('Error: date parsing ' + thedate);
		return "-";
	}
}

function show_first_grid_page()
{
	if(current_grid_page != 1) {
		current_grid_page = 1;
		populate_domain_list();
	}
}

function show_last_grid_page()
{
	if(current_grid_page != total_grid_pages) {
		current_grid_page = total_grid_pages;
		populate_domain_list();
	}
}

function show_next_grid_page()
{
	if(current_grid_page < total_grid_pages) {
		current_grid_page++;
		populate_domain_list();
	}
}

function show_prev_grid_page()
{
	if(current_grid_page > 1) {
		current_grid_page--;
		populate_domain_list();
	}
}
