var domain_name_filter_timer = null;

function setupMonitorFilters()
{
	var domain_name_filter = $('#domain_name_filter').val();
	var selected_category_id = $('#category-list').val();
	var selected_autoquery_id = $('#autoquery-list').val();
	var current_filtername = "";
	if(selected_category_id > 1)
		current_filtername += " " + $( "#category-list option:selected" ).text() + " ";
	else if(selected_autoquery_id > 1)
		current_filtername += " " + $( "#autoquery-list option:selected" ).text() + " ";
	if(current_filtername == "")
		current_filtername = "";
	if(domain_name_filter != "")
		current_filtername += " containing '" + domain_name_filter + "', ";
	
	$('#btn-autoquery-filter').removeClass('btn-pager-select');
	$('#btn-category-filter').removeClass('btn-pager-select');
	if(selected_category_id > 1) 
		$('#btn-category-filter').addClass('btn-pager-select');
	else if(selected_autoquery_id > 1) 
		$('#btn-autoquery-filter').addClass('btn-pager-select');
	
	var sortname = sort_column_name;
	var sortorder = record_sorting_order.toLowerCase() == "desc" ? "descending" : "ascending";
	if(sortname == "r_h_disp" || sortname == "d.r_h_disp" || sortname == "s.r_h_disp")
		sortname = "alerts";
	else
		sortname = replaceAll(sortname, "s.", "");
	sortname = replaceAll(sortname, "_", " ");
	
	$('#current_sort_name').html(current_filtername + "sorted on " + " '" + sortname + "'");
	showSortingIcon();
}

function getSearchFilterParams()
{
	var domain_name_filter_mode = "bw";
	var domain_name_filter = $('#domain_name_filter').val();
	if(domain_name_filter != "") {
		if(domain_name_filter.indexOf("%") < 0)
			domain_name_filter_mode = "cn";
	}
	if(domain_name_filter != "")
		return "&_search=1&searchField=domain&searchString=" + domain_name_filter + "&searchOper=" + domain_name_filter_mode;
	else
		return "";
}

function initFilterLists()
{
	clearLookupMessage();
	
	$('#btn-category-filter').off('click');
	$('#btn-category-filter').click(function(event){
		event.preventDefault();
		toggleControlBox('category-selector');
	});
	
	$('#btn-autoquery-filter').off('click');
	$('#btn-autoquery-filter').click(function(event){
		event.preventDefault();
		toggleControlBox('autoquery-selector');
	});
	
	$('#domain-add-domains').off('click');
	$('#domain-add-domains').click(function(event){
		event.preventDefault();
		toggleControlBox('add-domains-panel');
	});
	
	$('.close-filter-selector').off('click');
	$('.close-filter-selector').click(function(event){
		event.preventDefault();
		toggleControlBox('');
	});

	$('#domain-filter-clear').off('click');
	$('#domain-filter-clear').click(function(event){
		event.preventDefault();
		$('#domain_name_filter').val('');
		populate_domain_list();
	});
	
	if(grid_search_on_enter)
		initEnterKeyHandler("domain_name_filter", "domain-data-refresh");
	else {
		$('#domain_name_filter').bind('input', function() {
			if(domain_name_filter_timer)
				window.clearTimeout(domain_name_filter_timer);
			domain_name_filter_timer = window.setTimeout(function(){
				  populate_domain_list();
			}, grid_auto_search_delay);
		});
	}
	
	$('#category-list').on('change', function() {
		event.preventDefault();
		populate_domain_list();	
	});
	$('#autoquery-list').on('change', function() {
		event.preventDefault();
		populate_domain_list();	
	});

	$('#btn-confirm-action-yes').off('click');
	$('#btn-confirm-action-yes').click(function(event){
		event.preventDefault();
		var did = $('#confirm-action-msg').attr("data-did");
		var domain = $('#confirm-action-msg').attr("data-domain");
		if(did > 0 && domain != "")
			deleteDomainByID(did, domain);
		toggleControlBox('');
	});
	
	var datastr = get_ajax_datastr("list", "category", "user");
	ajax_call(datastr, ajax_get_category_list, null);
	
	datastr = get_ajax_datastr("grid", "query", "");
	datastr += "&columns=id,name,sortindex&sidx=sortindex&sord=asc&rows=100";
	ajax_call(datastr, ajax_get_autoquery_list, null);
	
	$('.btn-swap-sort-order').off('click');
	$('.btn-swap-sort-order').click(function(event){
		event.preventDefault();
		if(record_sorting_order.toLowerCase() == "desc") 
			record_sorting_order = "ASC";
		else
			record_sorting_order = "DESC";
		populate_domain_list();
	});
	
	$('#btn-reset-sorting').off('click');
	$('#btn-reset-sorting').click(function(event){
		event.preventDefault();
		$('#domain_name_filter').val('');
		clearLookupMessage();
		hideControlBox();
		if(what_to_show == 0)
			show_domain_monitor();
		else 
			show_ssl_monitor();
	});
	
	initAddDomains();
	hideControlBox();
}

function showSortingIcon()
{
	if(record_sorting_order.toLowerCase() == "asc")
		$('#btn_toggle_sort').find('img').attr('src', 'lib/layouts/images/menu/sort-asc.png');
	else 
		$('#btn_toggle_sort').find('img').attr('src', 'lib/layouts/images/menu/sort-desc.png');
}

function ajax_get_category_list(x, jqXHR, textStatus, params)
{
	var options = "<option value=\"" + 1 + "\">" + "All Domains" + "</option>";
	if(x != null) {
		if(x.status == "ok") {
			var count = x.ids.length;
			for(var i = 0; i < count; i++) {
				var name = x.ids[i].name;
				var cid = parseInt(x.ids[i].id);
				var icon = x.ids[i].caticon;
				if(cid > 1)
					options += "<option value=\"" + cid + "\">" + name + "</option>";
			}
		}
	}
	$('.category-list-control').html(options);
}

function ajax_get_autoquery_list(x, jqXHR, textStatus, params)
{
	var options = "";
	if(x != null) {
		var count = x.rows.length;
		for(var i = 0; i < count; i++) {
			var name = x.rows[i].name;
			var aid = x.rows[i].id;
			options += "<option value=\"" + aid + "\">" + name + "</option>";
		}
	}
	$('#autoquery-list').html(options);
}
