function do_domain_sslcheck(did, domain, hid, hostname)
{
	clearLookupMessage();
	var luw = SSL_CERTS;
	var rowKey = did;
	var luint = 0;
	var datastr = get_ajax_datastr("set", "luq", "");
	datastr += "&what=" + luw + "&id=" + rowKey + "&ri=" + luint;
	ajax_call(datastr, ajax_do_lookups, domain);
}

function  do_domain_whois(did, domain)
{
	clearLookupMessage();
	var luw = DOMAIN_RECORDS;
	var rowKey = did;
	var luint = 0;
	var datastr = get_ajax_datastr("set", "luq", "");
	datastr += "&what=" + luw + "&id=" + rowKey + "&ri=" + luint;
	ajax_call(datastr, ajax_do_lookups, domain);
}

/////////////////////////////////////////////////////////////////////////////////////////

function deleteDomainByID(did, domain)
{
	var datastr = get_ajax_datastr("grid", "domain", "del");
	datastr += "&id=" + did;
	ajax_call(datastr, ajax_delete_domain, domain);
}

/////////////////////////////////////////////////////////////////////////////////////////

function ajax_delete_domain(x, jqXHR, textStatus, params)
{
	if(x != null) {
		if(x.status == 'ok') {
			populate_domain_list();
			showLookupMessage("The domain " + params + " was deleted.");
		}
		else {
			showLookupMessage("There was an error deleteing the domain " + params);
		}
	}
}

/////////////////////////////////////////////////////////////////////////////////////////

function ajax_do_lookups(x, jqXHR, textStatus, params)
{
	if(x != null) {
		if(x.status == 'ok') {
			if(x.status == 'ok' && x.count > 0) {
				showLookupMessage(params + " added to lookup queue");
			}
			else if(x.status == 'ok' && x.count == 0) {
				showLookupMessage("Nothing queued. The domain may already be in queue or write protected.");
			}
			else {
				showLookupMessage(x.msg);
			}
		}
		else
			showLookupMessage(x.error);
	}
}

function initAddDomains()
{
	var datastr = get_ajax_datastr("admin", "regapi", "list");
	ajax_call(datastr, ajax_regapi_list, null);
	$('#select_datasource').change(function() {
		addDomainSourceChanged();
	});
	addDomainSourceChanged();
	
	$('#add-domains-submit').off('click');
	$('#add-domains-submit').click(function(event){
		event.preventDefault();
		add_domains_submit();
	});
}

/////////////////////////////////////////////////////////////////////////////////////////

function addDomainSourceChanged()
{
	var source = $('#select_datasource').val();
	if(source == "manual") {
		$('#domaindata, #domaindata-label').show();
		$('#regapiselect, #datasource-label').hide();
	}
	else {
		$('#domaindata, #domaindata-label').hide();
		$('#regapiselect, #datasource-label').show();
	}
}

/////////////////////////////////////////////////////////////////////////////////////////

function ajax_regapi_list(x, jqXHR, textStatus, params)
{
	if(x != null) {
		if(x.status == 'ok') {
			var count = x.profiles.length;
			var cbdata = "";
			for(var i = 0; i < count; i++) {
				var name = x.profiles[i];
				var params = x.data[name];
				cbdata += '<label class="checkbox-inline no_indent">';
				cbdata += '<input type="checkbox" class="cb-regapilist" name="regapi-' + name + '" id="regapi-' + name + '"> ' + name + '</label>';
			}
			$('#regapichecklist').html(cbdata);
		}
	}
}

/////////////////////////////////////////////////////////////////////////////////////////

function add_domains(domaindata, catid) {
	$('#adddomains-error').html('');
	var addmode = $('#select_datasource').val();
	var datastr = get_ajax_datastr("add", "domain", "");
	if(addmode == "manual") {
		datastr += "&data=" + encodeURIComponent(domaindata) + "&cid=" + catid + '&emptycat=0';
		ajax_call(datastr, ajax_add_domains, null);
	}
	else {
		var checkedIds = $("#regapichecklist :checkbox:checked").map(function() {
			return this.id.replace("regapi-", "");
		}).get();
		var ids = checkedIds.join(",");
		var bgproc = $('#add-bgprocess').is(':checked') ? "1" : "0";
		datastr += "&regapi=" + encodeURIComponent(ids) + "&cid=" + catid + '&emptycat=0';
		datastr += "&bgproc=" + bgproc;
		ajax_call(datastr, ajax_regapi_add_domains, null);
	}
}

/////////////////////////////////////////////////////////////////////////////////////////

function ajax_add_domains(x, jqXHR, textStatus, params)
{
	if(x != null) {
		if(x.status == 'ok') {
			if(x.added > 0) {
				populate_domain_list();
				$('#add-domains-error').html(x.added + " domains added");
				toggleControlBox('');
			}
			else {
				if(x.category > 1) {
					populate_domain_list();
				}
				$('#add-domains-error').html(x.error);
			}
		}
		else
			$('#add-domains-error').html(x.error);
	}
}

/////////////////////////////////////////////////////////////////////////////////////////

function ajax_regapi_add_domains(x, jqXHR, textStatus, params)
{
	ajax_add_domains(x, jqXHR, textStatus, params);
}

/////////////////////////////////////////////////////////////////////

function add_domains_submit() {
	var user_entry_data = $('#domaindata').val();
	var catid = $('#addto-category-list').val();
	if(catid <= 1)
		catid = 0;
	add_domains(user_entry_data, catid);
}

