function ajax_get_domain_list(x, jqXHR, textStatus, params)
{
	if(x != null) {
		var page = x.page;
		var count = 0;
		if(typeof x.rows != "undefined") {
			count = x.rows.length;
			total_grid_pages = x.total;
			current_grid_page = x.page;
		}
		var info = "";
		var index = x.start;
		
		var records = "Records " + (x.start + 1) + " to " + (x.start+count) + " of " + x.records;
		if(!count)
			records = "No records found";
		var pager = "<a id=\"btn-scroll-to-top\" class=\"btn-pager\"><img src=\"lib/layouts/images/menu/scrolltotop.png\" alt=\"Scroll To Top\" title=\"Scroll To Top\"></a>";
		pager += "<a id=\"btn-scroll-to-bottom\" class=\"btn-pager\"><img src=\"lib/layouts/images/menu/scrolltobottom.png\" alt=\"Scroll To Bottom\" title=\"Scroll To Bottom\"></a>";

		pager += "<a id=\"domain-data-refresh\" class=\"btn-pager\"><img src=\"lib/layouts/images/icons/16/refresh.png\" alt=\"Refresh Data\" title=\"Refresh Data\"></a>";
		pager += "<a id=\"domain-pager-first\" class=\"btn-pager\"><img src=\"lib/layouts/images/menu/firstpage.png\" alt=\"First Page\" title=\"First Page\"></a>";
		pager += "<a id=\"domain-pager-prev\" class=\"btn-pager\"><img src=\"lib/layouts/images/menu/prevpage.png\" alt=\"Previous Page\" title=\"Previous Page\"></a>";
		pager += "<a id=\"domain-pager-next\" class=\"btn-pager\"><img src=\"lib/layouts/images/menu/nextpage.png\" alt=\"Next Page\" title=\"Next Page\"></a>";
		pager += "<a id=\"domain-pager-last\" class=\"btn-pager\"><img src=\"lib/layouts/images/menu/lastpage.png\" alt=\"Last Page\" title=\"Last Page\"></a>";

		$('.content-footer').html("<div class=\"content-footer-data\">" + records + "<div class=\"domain-list-pager\">" + pager + "</div></div>");
		
		var has_ssl_columns = false;
		if(what_to_show == 1)
			has_ssl_columns = 1;
		var ssl_highlight_days = 30;
		var domain_highlight_days = 30;
		var user_access_rights = parseInt(user_details['rights']);
		var adel = bit_test(user_access_rights, ALLOW_DELETE_BITPOS);
		
		for(var i = 0; i < count; i++) {
			var classname = "domain-list-stamp";
			var domain_has_alert = false;
			var availability = (typeof x.rows[i]["d.availability"] != "undefined" ? x.rows[i]["d.availability"] : "");
			var itemname = (typeof x.rows[i]["s.hostname"] != "undefined" ? x.rows[i]["s.hostname"] : x.rows[i]["d.domain"]);
			
			var diff = "-";
			var date1 = Date.parse(x.rows[i]["d.registry_expiry"]);
			var date2 = Date.parse(x.rows[i]["d.registrar_expiry"]);
			var datet = Date.parse("today");
			var datee = date1;

			if(!isNaN(date1) && !isNaN(date2) && date1 != "" && date2 != "") {
				if(get_time_value(date1) > get_time_value(date2))
					datee = date2;
			}
			
			if(!isNaN(datee) && !isNaN(datet) && datet != "" && datee != "") {
				diff = Math.floor((get_time_value(datee)-get_time_value(datet))/3600/24/1000);
				if(diff < domain_highlight_days) {
					classname = "domain-list-stamp domain-list-stamp-danger";
					domain_has_alert = true;
				}
			}

			var ssldiff = "-";
			if(has_ssl_columns) {
				if(x.rows[i]["s.ssl_valid_to"] != "") {
					var datessl = Date.parse(replaceAll(x.rows[i]["s.ssl_valid_to"], ".000000", ""));
					ssldiff = Math.floor((get_time_value(datessl)-get_time_value(datet))/3600/24/1000);
					if(ssldiff < ssl_highlight_days) {
						domain_has_alert = true;
					}
				}
			}
			
			var listentry = "<div class=\"column-card " + data_card_class + " mb-3\"><div class=\"domain-list-group-item\"><div class=\"domain-list-header\">";
			if(availability.toLowerCase() == "available")
				listentry += "<div class=\"domain-list-index domain-list-stamp-success\">" + (index+1) + "</div>";
			else if(domain_has_alert)
				listentry += "<div class=\"domain-list-index domain-list-stamp-orange\">" + (index+1) + "</div>";
			else
				listentry += "<div class=\"domain-list-index\">" + (index+1) + "</div>";
			
			listentry += "<div class=\"text-left domain-heading-name\">" + itemname + "</div>";
			if(adel && what_to_show == 0) {
				listentry += "<div class=\"domain-heading-controls\">" + "<a data-domain=\"" + x.rows[i]["d.domain"] + "\"  data-did=\"" + x.rows[i]["sid"] + "\"class=\"btn-domain-delete\"><img src=\"lib/layouts/images/menu/delete.png\" alt=\"Delete Domain\" title=\"Delete Domain\"></a>" + "</div>";
			}
			
			listentry += "</div>";
			listentry += "<div class=\"domain-list-content\">";
			
			if(!has_ssl_columns && availability.toLowerCase() != "available") {
				var home_page_status = typeof (x.rows[i]["d.home_page_status"]) != "undefined" ? x.rows[i]["d.home_page_status"] : "";
				var home_page_title = x.rows[i]["d.home_page_title"];
				if(home_page_title == "")
					home_page_title = x.rows[i]["d.home_page_status"] == "" ? "&nbsp;" : "&nbsp;" + home_page_status;
				listentry += "<div class=\"" + "domain-list-stamp domain-list-stamp-normal domain-list-ssldays" + "\">Home Page</div>";
				listentry += "<p class=\"page-title\">" + home_page_title + "</p>";
			}
			
			if(availability.toLowerCase() != "available") {
				if(!has_ssl_columns) {
					if(availability.toLowerCase() != "available") {
						if(!isNaN(diff)) {
							if(diff < domain_highlight_days) {
								if(diff < 0)
									listentry += "<div class=\"" + "domain-list-stamp domain-list-stamp-danger domain-list-stamp-expired domain-list-expirydays" + "\">Expired " + (diff*-1) + "&nbsp;days ago</div>";
								else 
									listentry += "<div class=\"" + "domain-list-stamp domain-list-stamp-danger domain-list-expirydays" + "\">Expires in " + diff + "&nbsp;days</div>";
							}
							else
								listentry += "<div class=\"" + "domain-list-stamp domain-list-stamp-normal domain-list-expirydays" + "\">Expires in " + diff + "&nbsp;days</div>";
						}
						else {
							if(x.rows[i]["d.primary_whois_checked_at"] == "")
								listentry += "<div class=\"" + "domain-list-stamp domain-list-stamp-warning domain-list-expirydays" + "\">Not Checked Yet</div>";
							else
								listentry += "<div class=\"" + "domain-list-stamp domain-list-stamp-danger domain-list-expirydays" + "\">Unknown Expiry Date</div>";
						}
					}
					listentry += "<div data-sortname=\"registry_expiry\" class=\"" + "domain-list-stamp domain-list-stamp-warning btn-record-sort" + "\">Registry: " + x.rows[i]["d.registry_expiry"] + "</div>";
					listentry += "<div data-sortname=\"registrar_expiry\" class=\"" + "domain-list-stamp domain-list-stamp-warning btn-record-sort" + "\">Registrar: " + x.rows[i]["d.registrar_expiry"] + "</div>";
					listentry += "<div data-sortname=\"primary_whois_checked_at\" class=\"" + "domain-list-stamp domain-list-stamp-normal btn-record-sort" + "\">Primary Whois At: " + replaceAll(x.rows[i]["d.primary_whois_checked_at"], ".000000", "") + "</div>";
					listentry += "<a data-did=\"" + x.rows[i]["sid"] + "\" data-domain=\"" + x.rows[i]["d.domain"] + "\" class=\"btn-pager btn-domain-whois\"><img src=\"lib/layouts/images/menu/domaincheck.png\" alt=\"lookup Domain\" title=\"Lookup Domain\"></a>";

					listentry += "<img src=\"" + app_root_url + "api.php?c=get&t=webshot&domain=" + x.rows[i]["d.domain"] + "\" class=\"" + "img-fluid domain-list-webshot" + "\">";
				}
			}
	
			if(availability.toLowerCase() == "available") {
				listentry += "<div class=\"" + "domain-list-stamp domain-list-stamp-success" + "\">" + "Unregistered" + "</div>";
				listentry += "<div data-sortname=\"primary_whois_checked_at\" class=\"" + "domain-list-stamp domain-list-stamp-normal btn-record-sort" + "\">Last Lookup: " + replaceAll(x.rows[i]["d.primary_whois_checked_at"], ".000000", "") + "</div>";
				listentry += "<a data-did=\"" + x.rows[i]["sid"] + "\" data-domain=\"" + x.rows[i]["d.domain"] + "\" class=\"btn-pager btn-domain-whois\"><img src=\"lib/layouts/images/menu/domaincheck.png\" alt=\"lookup Domain\" title=\"Lookup Domain\"></a>";
			}
			
			if(has_ssl_columns) {
				if(x.rows[i]["s.ssl_valid_to"] != "") {
					if(ssldiff < ssl_highlight_days && !isNaN(ssldiff))
						listentry += "<div class=\"" + "domain-list-stamp domain-list-stamp-danger domain-list-ssldays" + "\">SSL expires in " + ssldiff + "&nbsp;days</div>";
					else
						listentry += "<div class=\"" + "domain-list-stamp domain-list-stamp-warning domain-list-ssldays" + "\">SSL expires in " + ssldiff + "&nbsp;days</div>";
				}
				if(x.rows[i]["s.ssl_valid_to"] != "") {
					listentry += "<div data-sortname=\"s.ssl_valid_to\"  class=\"" + "domain-list-stamp domain-list-stamp-warning btn-record-sort" + "\">SSL Expiry:" + replaceAll(x.rows[i]["s.ssl_valid_to"], ".000000", "") + "</div>";
				}
				
				listentry += "<div data-sortname=\"s.ssl_issued_by\" class=\"" + "domain-list-stamp domain-list-stamp-normal btn-record-sort" + "\">" + x.rows[i]["s.ssl_issued_by"] + "</div>";
				listentry += "<div data-sortname=\"ssl_checked_at\" class=\"" + "domain-list-stamp domain-list-stamp-normal btn-record-sort" + "\">SSL Checked At: " + replaceAll(x.rows[i]["d.ssl_checked_at"], ".000000", "") + "</div>";
				listentry += "<a data-did=\"" + x.rows[i]["sid"] + "\" data-domain=\"" + x.rows[i]["d.domain"] + "\" data-hid=\"" + x.rows[i]["s.hid"] + "\" data-hostname=\"" + x.rows[i]["s.hostname"] + "\" class=\"btn-pager btn-domain-sslcheck\"><img src=\"lib/layouts/images/menu/domaincheck.png\" alt=\"SSL Check Domain\" title=\"SSL Check Domain\"></a>";
				
				listentry += "<br>";
				listentry += "<div class=\"" + "domain-list-stamp domain-list-stamp-normal domain-list-ssldays" + "\">SAN</div>";
				listentry += "<div data-sortname=\"subject_alt_name\" class=\"" + "domain-list-stamp domain-list-stamp-normal domain-list-stamp-san btn-record-sort" + "\">" + x.rows[i]["s.subject_alt_name"] + "</div>";
			}
			else if(availability.toLowerCase() != "available") {
				listentry += "<div data-sortname=\"created_on\" class=\"" + "domain-list-stamp domain-list-stamp-normal btn-record-sort" + "\">Created: " + x.rows[i]["d.created_on"] + "</div>";
				listentry += "<div data-sortname=\"registrar\" class=\"" + "domain-list-stamp domain-list-stamp-normal btn-record-sort" + "\">Registrar: " + x.rows[i]["d.registrar"] + "</div>";

				listentry += "<div data-sortname=\"ns1\" class=\"" + "domain-list-stamp domain-list-stamp-normal btn-record-sort" + "\">NS1: " + x.rows[i]["d.ns1"] + "</div>";
				listentry += "<div data-sortname=\"ns2\" class=\"" + "domain-list-stamp domain-list-stamp-normal btn-record-sort" + "\">NS2: " + x.rows[i]["d.ns2"] + "</div>";
				listentry += "<div data-sortname=\"mx1\" class=\"" + "domain-list-stamp domain-list-stamp-normal btn-record-sort" + "\">MX1: " + x.rows[i]["d.mx1"] + "</div>";
				listentry += "<div data-sortname=\"mx2\" class=\"" + "domain-list-stamp domain-list-stamp-normal btn-record-sort" + "\">MX2: " + x.rows[i]["d.mx2"] + "</div>";
			}
			
			listentry += "<br>";
			if(has_ssl_columns) {
				listentry += "<div class=\"" + "domain-list-stamp domain-list-stamp-normal domain-list-ssldays" + "\">IP</div>";
				listentry += "<div data-sortname=\"s.ip\" class=\"domain-list-stamp domain-list-stamp-normal domain-list-stamp-ip btn-record-sort\">" + x.rows[i]["s.ip"] + "</div>";
				listentry += "<div data-sortname=\"s.ptr\" class=\"" + "domain-list-stamp domain-list-stamp-normal btn-record-sort" + "\">PTR: " + x.rows[i]["s.ptr"] + "</div>";
			}
			else if(availability.toLowerCase() != "available") {
				listentry += "<div class=\"" + "domain-list-stamp domain-list-stamp-normal domain-list-ssldays" + "\">IP</div>";
				listentry += "<div data-sortname=\"ip\" class=\"domain-list-stamp domain-list-stamp-normal domain-list-stamp-ip btn-record-sort\">" + x.rows[i]["d.ip"] + "</div>";
				listentry += "<div data-sortname=\"ip_asname\"  class=\"" + "domain-list-stamp domain-list-stamp-normal btn-record-sort" + "\">ASN: " + x.rows[i]["d.ip_asname"] + "</div>";
			}
			listentry += "</div></div></div>";
			
			info += listentry;
			index++;
		}
		if(count == 0 && what_to_show == 0) {
			var selected_category_id = $('#category-list').val();
			var selected_autoquery_id = $('#autoquery-list').val();
			var domain_name_filter = $('#domain_name_filter').val();
			if(selected_category_id <= 1 && selected_autoquery_id <= 1 && domain_name_filter == "") {
				var data = "<p class=\"text-center mb-3\">No domain records were found. Please add  domains using the <b>Add Domains</b> button above.</p>";
				var listentry = "<div class=\"col-lg-12 mb-3\"><div class=\"domain-list-group-item\"><div class=\"domain-list-header\">&nbsp;</div><div class=\"domain-list-content\">";
				listentry += data + "</div></div></div>"
				info = listentry;
			}
		}

		$('#domain_list_data').html(info);
		
		setStampFontSize(getCookieInt("table-font-size", DEFAULT_TABLE_FONT_SIZE));
		
		setTimeout(function(){resize_monitor_window();}, 50);
		
		$('#domain-pager-next').off('click');
		$('#domain-pager-next').click(function(event){
			event.preventDefault();
			show_next_grid_page();
		});
		$('#domain-pager-prev').off('click');
		$('#domain-pager-prev').click(function(event){
			event.preventDefault();
			show_prev_grid_page();
		});
		$('#domain-pager-first').off('click');
		$('#domain-pager-first').click(function(event){
			event.preventDefault();
			show_first_grid_page();
		});
		$('#domain-pager-last').off('click');
		$('#domain-pager-last').click(function(event){
			event.preventDefault();
			show_last_grid_page();
		});
		
		$('.btn-record-sort').off('click');
		$('.btn-record-sort').click(function(event){
			event.preventDefault();
				sort_column_name = $(this).attr("data-sortname");
			if(what_to_show == 0)
				record_sorting_order = "ASC";
			populate_domain_list();
		});
		
		$('#domain-data-refresh').off('click');
		$('#domain-data-refresh').click(function(event){
			event.preventDefault();
			populate_domain_list();
		});
		

		$('.btn-domain-whois').off('click');
		$('.btn-domain-whois').click(function(event){
			event.preventDefault();
			var did = $(this).attr("data-did");
			var domain = $(this).attr("data-domain");
			do_domain_whois(did, domain);
		});
		
		$('.btn-domain-sslcheck').off('click');
		$('.btn-domain-sslcheck').click(function(event){
			event.preventDefault();
			var did = $(this).attr("data-did");
			var hid = $(this).attr("data-hid");
			var domain = $(this).attr("data-domain");
			var hostname = $(this).attr("data-hostname");
			do_domain_sslcheck(did, domain, hid, hostname);
		});

		$('#btn-scroll-to-top').off('click');
		$('#btn-scroll-to-top').click(function(event){
			event.preventDefault();
			$('.content-data').animate({scrollTop: 0}, 'slow');
		});

		$('#btn-scroll-to-bottom').off('click');
		$('#btn-scroll-to-bottom').click(function(event){
			event.preventDefault();
			$('.content-data').animate({scrollTop: $('#domain_list_data').height()}, 'slow');
		});

		$('.btn-domain-delete').off('click');
		$('.btn-domain-delete').click(function(event){
			event.preventDefault();
			var did = $(this).attr("data-did");
			var domain = $(this).attr("data-domain");

			var msg = "Are you sure you want to delete the domain <span class=\"highlight\">" + domain + "</span>? ";
			msg += "This will remove every data associated with this domain and you will not be able to undo it.";
			hideControlBox();
			$('#confirm-action-msg').html(msg);
			$('#confirm-action-msg').attr('data-domain',domain);
			$('#confirm-action-msg').attr('data-did',did);
			toggleControlBox("confirm-action-panel");
		});
	}
}

function setStampFontSize(fs)
{
	var wwd = $(window).width();
	if(wwd <= 575)
		fs = 12;
	else
		fs -= font_size_increment;
	var lcfs = fs;
	var lsfs = fs-1;
	var lhfs = fs+7;
	var lifs = fs+2;
	$('.domain-list-content').css('font-size', lcfs+'px');
	$('.domain-list-stamp').css('font-size', lsfs+'px');
	$('.domain-list-header').css('font-size', lhfs+'px');
	$('.option-heading-name').css('font-size', (lhfs-2)+'px');
	$('#current_sort_name').css('font-size', (lifs)+'px');
	$('.domain-ip-address').css('font-size', lifs+'px');
	$('.domain-list-index').css('font-size', lifs+'px');
	$('#content-header-heading').css('font-size', lifs+'px');
	$('panel-subheading').css('font-size', lifs+'px');
	var listpadding = $('.domain-list-content').css('padding-left');
	if(typeof listpadding != "undefined" && listpadding != "") {
		var pa = parseInt(listpadding.slice(0, -2))+8;
		$('.domain-heading-name').css('padding-left', (pa-8)+'px');
		$('.domain-list-expirydays').css('width', (pa-18) + 'px');
		$('.domain-list-ssldays').css('width', (pa-18) + 'px');
		$('.domain-list-webshot').css('width', (pa-18+6) + 'px');
	}
	
	var hht = $('.domain-heading-name').height() + 6;
	$('.domain-list-header').css('height', hht);
}
