function init_panel_whoissetup()
{
	$('#whoissetup-error').html('');
	initEnterKeyHandler("whoisdiag-tld", "whoisetup-get-server");
	initEnterKeyHandler("whoisdiag-server", "whoisetup-get-server");
}

function whoisetup_save_server()
{
	$('#whoissetup-error').html('');
	var server = $('#whoisdiag-server').val();
	var tld = $('#whoisdiag-tld').val();
	if(server != "" && tld != "") {
		var datastr = get_ajax_datastr("set", "whois", "server");
		datastr += "&server=" + encodeURIComponent(server);
		datastr += "&tld=" + encodeURIComponent(tld);
		ajax_call(datastr, ajax_whois_set_server, null);
	}
}

function whoissetup_submit()
{
	var server = $('#whoisdiag-server').val();
	if(server != "") {
		var emdata = $('#tldform').serialize();
		if(!$('#whoissetup-stop_lookups').is(":checked"))
			emdata += "&whoissetup-stop_lookups=0";
		var datastr = get_ajax_datastr("set", "whois", "server");
		datastr += "&server=" + encodeURIComponent(server);
		datastr += "&" + emdata;
		datastr = replaceAll(datastr, "whoissetup-", "");
		$('#whoissetup-error').html('Please wait');
		ajax_call(datastr, ajax_whois_set_server, null);
	}
}

function ajax_whois_set_server(x, jqXHR, textStatus, params)
{
	if(x != null) {
		if(x.status == 'ok') {
			$('#whoissetup-error').html('OK');
		}
		$('#whoissetup-error').html(x.error);
	}
}

function whoisetup_get_server()
{
	var tld = $('#whoisdiag-tld').val();
	var server = $('#whoisdiag-server').val();
	$('#whoisdiag-server').val('')
	if(tld != "" || server != "") {
		$('#whoissetup-error').html('Please wait');
		var datastr = get_ajax_datastr("get", "whois", "server");
		datastr += "&tld=" + encodeURIComponent(tld);
		datastr += "&server=" + encodeURIComponent(server);
		ajax_call(datastr, ajax_whois_get_server, null);
	}
}

function ajax_whois_get_server(x, jqXHR, textStatus, params)
{
	if(x != null) {
		if(x.status == 'ok') {
			var server = x.server;
			$('#whoisdiag-server').val(server);
			$('#whoissetup-port').val(x.port);
			$('#whoissetup-query').val(x.query);
			$('#whoissetup-searchtoken').val(x.searchtoken);
			if(x.dateformat == null || x.dateformat == "")
				x.dateformat = 'auto'
			$('#whoissetup-dateformat').val(x.dateformat);
			$('#whoissetup-proxy').val(x.proxy);
			$('#whoissetup-conninterval').val(x.conninterval);
			$('#whoissetup-bannedtext').val(x.bannedtext);
			$('#whoissetup-last_connected_at').html(x.last_connected_at);
			if(x.stop_lookups == "1" || x.stop_lookups == 1)
				$('#whoissetup-stop_lookups').prop('checked', true);
			else
				$('#whoissetup-stop_lookups').prop('checked', false);
			$('#whoissetup-xlate').val(x.xlate);
		}
		$('#whoissetup-error').html(x.error);
	}
}


function whoissetup_resetlastconnect()
{
	$('#whoissetup-error').html('');
	var server = $('#whoisdiag-server').val();
	if(server != "") {
		var emdata = 'null';
		var datastr = get_ajax_datastr("set", "whois", "server");
		datastr += "&server=" + encodeURIComponent(server);
		datastr += "&last_connected_at=" + encodeURIComponent(emdata);
		ajax_call(datastr, ajax_whois_set_server, null);
	}
}

function whoissetup_xlate_submit()
{
	$('#whoissetup-error').html('');
	var server = $('#whoisdiag-server').val();
	if(server != "") {
		var emdata = $('#whoissetup-xlate').val();
		var datastr = get_ajax_datastr("set", "whois", "server");
		datastr += "&server=" + encodeURIComponent(server);
		datastr += "&xlate=" + encodeURIComponent(emdata);
		ajax_call(datastr, ajax_whois_set_server, null);
	}
}
