var font_preview_link = [];
var current_fonts = [];

//////////////////////////////////////////////////////////////////////////

function get_theme_fonts(index)
{
	var default_fonts = [];
	default_fonts.push(theme['font']['gf1']);
	default_fonts.push(theme['font']['gf2']);
	if(typeof theme['font']['gf3'] != "undefined" && theme['font']['gf3'] != "") 
		default_fonts.push(theme['font']['gf3']);
	else
		default_fonts.push('');
	var gfonts = getCookie('gfonts', default_fonts.join());
	var gf = gfonts.split(",");
	if(index >= 0 && index < gf.length)
		return gf[index];
}

//////////////////////////////////////////////////////////////////////////

function ajax_fill_fontlist(x, jqXHR, textStatus, params)
{
	if(x != null) {
		if(x.status == 'ok') {
			var fontindex = $('#fontindex').val();
			current_fonts[0] = get_theme_fonts(0);
			current_fonts[1] = get_theme_fonts(1);
			current_fonts[2] = get_theme_fonts(2);
			showGoogleFont("font-normal", current_fonts[0]);
			showGoogleFont("font-heading", current_fonts[1]);
			if(current_fonts[2] != "") {
				showGoogleFont("font-heading", current_fonts[2]);
				$('#font-special').show();
			}
			else {
				$('#font-special').hide();
				$("#fontindex option[value='font-special']").remove();
			}
			var current_font = get_current_font();
			var vfont = current_font.replace(/ /g,"_");
			var font_list = '';

			var count = x.fonts.length;
			for(var i = 0; i < count; i++) {
				var font = x.fonts[i]['font_name'];
				vfont = font.replace(/ /g,"_");
				var option = '<li id="' + vfont + '" class="list-group-item ui-selectee font-' + x.fonts[i]['category'] + '">';
				option += font + "</li>";
				font_list += option;
			}
			$('#fontlist').html(font_list);

			makeListSelectable("fontlist", "font-preview");
			$("#fontindex").off('change');
			$("#fontindex").change(function(event){
				fontIndexChanged();
			});
			fontIndexChanged();
			
			$('#themeselect').off('change');
			$("#themeselect").change(function(event){
				themeSelectChanged();
			});
			
			var themes = "";
			var cc = x.themes.length;
			for(var i = 0; i < cc; i++) {
				var theme = x.themes[i].toLowerCase();
				theme = theme.replace(/ /g,"_");
				themes += "<option value=\"" + theme + "\">" + x.themes[i] + "</option>";
			}
			$('#themeselect').html(themes);
			$('#themeselect').val(x.current);
			setTableFontSize(getCookieInt("table-font-size", DEFAULT_TABLE_FONT_SIZE));
			
			var it = (x.minimize_transparency_level) ? true : false;
			$('#minimize_transparency_level').prop("checked", it);
		}
	}
}

//////////////////////////////////////////////////////////////////////////

function themeSelectChanged()
{
	$.cookie('sed4colr', $('#themeselect').val());
	reloadApp();
}

//////////////////////////////////////////////////////////////////////////

function get_current_font()
{
	var fontindex = $('#fontindex').val();
	if(fontindex == "font-heading") 
		return current_fonts[1];
	else if(fontindex == "font-normal") 
		return current_fonts[0];
	else if(fontindex == "font-special")
		return current_fonts[2];
	else
		return "";
}

//////////////////////////////////////////////////////////////////////////

function fontIndexChanged()
{
	var fn = get_current_font();
	var vfont = fn.replace(/ /g,"_");
	$('#fontlist' + ' li').each(function() {
		$(this).removeClass('ui-state-highlight');
		$(this).removeClass('ui-selected');
	});
	goToByScroll('#fontlist', '#'+vfont);
	$('#'+vfont).addClass('ui-state-highlight');
	$('#'+vfont).addClass('ui-selected');
}

//////////////////////////////////////////////////////////////////////////

function init_panel_uisetup()
{
	$('.fontlist').css('height', 100);
	$('.fontlist').css('overflow', 'auto');
	
	// Fix for IE 11
	$('.fontlist').css('font-size', getCookieInt("table-font-size", DEFAULT_TABLE_FONT_SIZE)+1);
	
	var datastr = get_ajax_datastr("list", "ui", "all");
	ajax_call(datastr, ajax_fill_fontlist, null);

	var dgaw = (getCookieInt("domaingrid_auto_width", 1) == 1) ? true : false;
	$('#domaingrid_auto_width').prop("checked", dgaw);
}

//////////////////////////////////////////////////////////////////////////

function close_panel_uisetup()
{
	$('#fontlist').html('');
	if(font_preview_link['font-heading'] != null)
		document.getElementsByTagName("head")[0].removeChild(font_preview_link['font-heading']);
	if(font_preview_link['font-normal'] != null)
		document.getElementsByTagName("head")[0].removeChild(font_preview_link['font-normal']);
	if(font_preview_link['font-special'] != null)
		document.getElementsByTagName("head")[0].removeChild(font_preview_link['font-special']);
	font_preview_link = [];
}

//////////////////////////////////////////////////////////////////////////

function showGoogleFont(elemid, fontname)
{
	if(fontname != "") {
		var gfont = fontname.replace(/ /g,"+");
		if(font_preview_link[elemid] != null)
			document.getElementsByTagName("head")[0].removeChild(font_preview_link[elemid]);
		font_preview_link[elemid] = document.createElement("link")
		font_preview_link[elemid].setAttribute("rel", "stylesheet")
		font_preview_link[elemid].setAttribute("type", "text/css")
		font_preview_link[elemid].setAttribute("href", "https://fonts.googleapis.com/css?family=" + gfont)
		document.getElementsByTagName("head")[0].appendChild(font_preview_link[elemid]);
		$('#'+elemid).css('font-family', fontname);
		$('#'+elemid+'-name').html(fontname);
		
		if(elemid == "font-normal")
			current_fonts[0] = fontname;
		else if(elemid == "font-heading")
			current_fonts[1] = fontname;
		else if(elemid == "font-special")
			current_fonts[2] = fontname;
	}
}

//////////////////////////////////////////////////////////////////////////

function saveUISettings()
{
	$.cookie('gfonts', current_fonts.join(","));
}

//////////////////////////////////////////////////////////////////////////

function resetUISettings()
{
	$.cookie('gfonts', '');
}

//////////////////////////////////////////////////////////////////////////

function save_uisetup()
{
	saveUISettings();
	reloadApp();
}

//////////////////////////////////////////////////////////////////////////

function reset_uisetup()
{
	close_panel_uisetup();
	resetUISettings();
	reloadApp("?theme=");
}

//////////////////////////////////////////////////////////////////////////

function ajax_transparency_changed(x, jqXHR, textStatus, params)
{
	if(x != null) {
		if(x.status == 'ok') {
			reloadApp();
		}
	}
}

//////////////////////////////////////////////////////////////////////////

