/////////////////////////////////////////////////////////////////////////////////////////
// subgrids.js
// Watch My Domains SED v3
// (c) Softnik Technologies. All rights reserved.
/////////////////////////////////////////////////////////////////////////////////////////

var dns_table_jqgrid = null;
var ssl_table_jqgrid = null;

/////////////////////////////////////////////////////////////////////////////////////////

function LoadSubdomainGrid()
{
	var unloaded = false;
	if(dns_table_jqgrid != null)
	{
		dns_table_jqgrid.GridUnload();
		unloaded = true;
	}
	var editurl = base_grid_ajax_url + "?c=grid&t=dns";
	dns_table_jqgrid = jQuery("#dnstable").jqGrid({
		hidegrid: false,
		height: $("#dnsdata").height()-120,
		width: $("#dnsdata").width()-24,
		altRows:true,
		altclass: "dns_grid_alt_row",
		url: '',
		editurl: editurl,
		datatype: "json",
		colModel: subdomaingrid_columns_array,
		rowNum:100,
		rowList:[100,200,500],
		rownumWidth: 50,
		rownumbers: true,
		viewrecords: false,
		caption:"DNS",
		multiselect: false,
		pager: "#dnstablepager",
		scrollOffset:18,
		sortname: 'hid',
		shrinkToFit: false,
		scroll:1,
		loadError: function (jqXHR, textStatus, errorThrown) 
		{
			gridSessionTimedoutError(jqXHR);
		},
		loadComplete : function () 
		{
			var sid = $("#domaintable").getGridParam('selrow');
			var domainname = jQuery("#domaintable").getCell(sid, "d.domain");
			jQuery("#dnstable").setCaption(domainname);
        },
		beforeRequest: function() 
		{
			var sid = $("#domaintable").getGridParam('selrow');
			if(sid == null) {
				jQuery("#dnstable").setCaption("DNS");
				return false;
			}
			var datastr = get_ajax_datastr("grid", "dns", "");
			var columns = jQuery("#dnstable").getGridParam("colModel");
			var colnum = columns.length;
			var edurl = base_grid_ajax_url + "?" + datastr + "&sid=" + sid;
			var durl = base_grid_ajax_url + "?" + datastr + "&sid=" + sid + "&columns=hid,";
			for(i = 0; i < colnum; i++)
			{
				if(columns[i].name != "rn" && columns[i].name != "cb")
				{
					durl += encodeURIComponent(columns[i].name);
					durl += ",";
				}
			}
			if(jQuery("#dnstable").setGridParam('url') !== durl)
				jQuery("#dnstable").setGridParam({url:durl});
			if(jQuery("#dnstable").setGridParam('editurl') !== edurl)
				jQuery("#dnstable").setGridParam({editurl:edurl});
			return true;
		}
	});
	
	var aedit = bit_test(user_access_rights, ALLOW_EDIT_BITPOS);
	var adel = bit_test(user_access_rights, ALLOW_DELETE_BITPOS);
	jQuery("#dnstable").navGrid('#dnstablepager', {add:false,edit:aedit,del:adel,search:false},
	{	// Edit
		width: 'auto',
		viewPagerButtons: false,
		resize: false,
		closeOnEscape:true,
		afterShowForm: function(form) {
			centerDialog('editmoddnstable');
		},
		afterComplete : function (response, postdata, formid) {
			var aqid = getCookieInt('current_autoquery', 0);
			if(aqid > 0) {
				scrollToRow($("#dnstable"), aqid);
			}
		},
		beforeShowForm: function(form) {
			setTableFontSize(getCookieInt("table-font-size", DEFAULT_TABLE_FONT_SIZE));
		}
	},
	{	// Add
		width: 'auto',
		closeAfterAdd: true,
		resize: false,
		closeOnEscape:true,
		afterShowForm: function(form) {
			centerDialog('editmoddnstable');
		},
		beforeShowForm: function () {
			$('<span class="pull-left"<a href="#"><span class="ui-icon ui-icon-newwin"></span>Help</a></span>')
			.click(function() {
				window.open (app_root_url + "?link=guide");
			}).addClass("fm-button ui-state-default ui-corner-all fm-button-icon-left")
			  .prependTo("#Act_Buttons>td.EditButton");  
			setTableFontSize(getCookieInt("table-font-size", DEFAULT_TABLE_FONT_SIZE));
		}
	},
	{	// Delete
		width: 'auto',
		closeOnEscape:true,
		resize: false,
		afterShowForm: function(form) {
			centerDialog('delmoddnstable');
		},
		afterComplete:function() {
			$("#ssltable").trigger("reloadGrid");
		},
		beforeShowForm: function(form) {
			setTableFontSize(getCookieInt("table-font-size", DEFAULT_TABLE_FONT_SIZE));
		}
	}
	);
	
	if(bit_test(user_access_rights, ALLOW_ADD_BITPOS))
	{
		jQuery("#dnstable").navButtonAdd('#dnstablepager', {
			// Add domain names
			caption:"", 
			buttonicon:"ui-icon-plus", 
			onClickButton: function() { 
				add_subdomains();
				return false;
			}, 
			title:'Add subdomains',
			position:"first"
		})
	}
	
	jQuery("#dnstable").navButtonAdd('#dnstablepager',
	{
		// setup columns
		caption:"", 
		buttonicon:"ui-icon-wrench", 
		onClickButton: function() { 
			setupDNSColumns();
		}, 
		title:'Setup Columns',
		position:"last"
	})
	
	//centerGridTitle("dnstable");
	
	if(unloaded)
	{
		var fs = getCookieInt("table-font-size", DEFAULT_TABLE_FONT_SIZE);
		setTableFontSize(fs);
		fixDivSizes();
		setTimeout(function(){fixDivSizes();}, 150);
	}
}

/////////////////////////////////////////////////////////////////////////////////////////

function LoadSSLGrid()
{
	var unloaded = false;
	if(ssl_table_jqgrid != null)
	{
		ssl_table_jqgrid.GridUnload();
		unloaded = true;
	}
	
	ssl_table_jqgrid = jQuery("#ssltable").jqGrid({
		hidegrid: false,
		height: $("#ssldata").height()-120,
		width: $("#ssldata").width()-24,
		altRows:true,
		altclass: "ssl_grid_alt_row",
		url: '',
		editurl: '',
		datatype: "json",
		colModel:sslgrid_columns_array,
		rowNum:100,
		rowList:[100,200,500],
		rownumWidth: 50,
		rownumbers: true,
		viewrecords: false,
		caption:"SSL",
		multiselect: false,
		pager: "#ssltablepager",
		scrollOffset:18,
		sortname: 'hid',
		shrinkToFit: false,
		scroll:1,
		loadError: function (jqXHR, textStatus, errorThrown) 
		{
			gridSessionTimedoutError(jqXHR);
		},
		onSelectRow: function(ids) 
		{
		},
		beforeSelectRow: function(rowid, e) 
		{
			if ($(this).getGridParam('selrow') == rowid) 
				return false;
			else
				return true;
        },
		loadComplete : function () 
		{
			var sid = $("#domaintable").getGridParam('selrow');
			var domainname = jQuery("#domaintable").getCell(sid, "d.domain");
			jQuery("#ssltable").setCaption(domainname);
        },
		beforeRequest: function() 
		{
			var sid = $("#domaintable").getGridParam('selrow');
			if(sid == null) {
				jQuery("#ssltable").setCaption("SSL");
				return false;
			}
			var datastr = get_ajax_datastr("grid", "ssl", "");
			var columns = jQuery("#ssltable").getGridParam("colModel");
			var colnum = columns.length;
			var edurl = base_grid_ajax_url + "?" + datastr + "&sid=" + sid;
			var durl = base_grid_ajax_url + "?" + datastr + "&sid=" + sid + "&columns=hid,";
			for(i = 0; i < colnum; i++)
			{
				if(columns[i].name != "rn" && columns[i].name != "cb")
				{
					durl += encodeURIComponent(columns[i].name);
					durl += ",";
				}
			}
			if(jQuery("#ssltable").setGridParam('url') !== durl)
				jQuery("#ssltable").setGridParam({url:durl});
			if(jQuery("#ssltable").setGridParam('editurl') !== edurl)
				jQuery("#ssltable").setGridParam({editurl:edurl});
			return true;
		}
	});
	
	var aedit = bit_test(user_access_rights, ALLOW_EDIT_BITPOS);
	var adel = bit_test(user_access_rights, ALLOW_DELETE_BITPOS);
	jQuery("#ssltable").navGrid('#ssltablepager', {add:false,edit:aedit,del:adel,search:false},
	{	// Edit
		width: 'auto',
		viewPagerButtons: false,
		resize: false,
		closeOnEscape:true,
		afterShowForm: function(form) 
		{
			centerDialog('editmodssltable');
		},
		afterComplete : function (response, postdata, formid)
		{
		},
		beforeShowForm: function(form)
		{
			setTableFontSize(getCookieInt("table-font-size", DEFAULT_TABLE_FONT_SIZE));
		}
	},
	{	// Add
		width: 'auto',
		resize: false,
		closeAfterAdd: true,
		closeOnEscape:true,
		afterShowForm: function(form) 
		{
			centerDialog('editmodssltable');
		},
		beforeShowForm: function(form)
		{
			setTableFontSize(getCookieInt("table-font-size", DEFAULT_TABLE_FONT_SIZE));
		}
	},
	{	// Delete
		width: 'auto',
		resize: false,
		closeOnEscape:true,
		afterShowForm: function(form) 
		{
			centerDialog('delmodssltable');
		},
		afterComplete:function() 
		{
			$("#dnstable").trigger("reloadGrid");
		},
		beforeShowForm: function(form)
		{
			setTableFontSize(getCookieInt("table-font-size", DEFAULT_TABLE_FONT_SIZE));
		}
	}
	);
	
	jQuery("#ssltable").navButtonAdd('#ssltablepager',
	{
		// setup columns
		caption:"", 
		buttonicon:"ui-icon-wrench", 
		onClickButton: function()
		{ 
			setupSSLColumns();
		}, 
		title:'Setup Columns',
		position:"last"
	})
	
	if(unloaded)
	{
		var fs = getCookieInt("table-font-size", DEFAULT_TABLE_FONT_SIZE);
		setTableFontSize(fs);
		fixDivSizes();
		setTimeout(function(){fixDivSizes();}, 150);
	}
	
	//centerGridTitle("ssltable");
}
