/////////////////////////////////////////////////////////////////////////////////////////

function setupDNSColumns()
{
	showPanel("panel-sdcolumnsetup", 'right');
	init_panel_sdcolumnsetup('subdomaingrid_columns_array');
}

/////////////////////////////////////////////////////////////////////////////////////////

function setupSSLColumns()
{
	showPanel("panel-sdcolumnsetup", 'right');
	init_panel_sdcolumnsetup('sslgrid_columns_array');
}


function init_panel_sdcolumnsetup(dgroup)
{
	$('#sdcolumnsetup-error').html('');
	fillColumnNameRowsForSubdomainColumnSetup(dgroup);
}

/////////////////////////////////////////////////////////////////////////////////////////

function fillColumnNameRowsForSubdomainColumnSetup(dgroup)
{
	$('#sdtablecolumns').html("<img src=\"\lib/layouts/images/loaders/ajax-loader.gif\" class=\"mx-auto\">&nbsp;");
	$('#sdcolumnsetup-group').val(dgroup);
	var datastr = get_ajax_datastr("list", "subdomain", "columns");
	if(dgroup == "subdomaingrid_columns_array")
		datastr += "&grid=dns";
	else if(dgroup == "sslgrid_columns_array")
		datastr += "&grid=ssl";
	ajax_call(datastr, ajax_fill_subdomain_columns, dgroup);
}

/////////////////////////////////////////////////////////////////////////////////////////

function ajax_fill_subdomain_columns(x, jqXHR, textStatus, params)
{
	var list = "";
	if(x != null) {
		if(x.status == 'ok') {
			var exists = [];
			var datacolumns = getColModelFromGroupName(params);
			var colnum = datacolumns.length;
			for(i = 0; i < colnum; i++) {
				if(datacolumns[i].name != "rn" && datacolumns[i].name != "cb" && datacolumns[i].name != "domain") {
					var key = datacolumns[i].name;
					key = replaceAll(key, "s.", "");
					label = datacolumns[i].label;
					exists.push(key);
					var custom = 'button';
					if(x.columns.hasOwnProperty(key)) 
						custom = parseInt(x.columns[key]['custom']) ? 'custom' : 'button';
					if(key !== 'r_h_disp') {
						list += "<li><div class=\"handle\"><span class=\"ui-icon grip-drag-action-" + custom + "\"></span></div>\n"; //  + label + "</li>";
						list += "<label for=\"cb-" + key + "\"><input id=\"cb-" + key + "\" type=\"checkbox\" checked>" + label + "</label></li>\n";
					}
				}
			}
			
			for (var key in x.columns) {
				if (key === 'length' || !x.columns.hasOwnProperty(key) || key == "domain") continue;
				key = replaceAll(key, "s.", "");
				var custom = parseInt(x.columns[key]['custom']);
				if(!custom) continue;
				var label = x.columns[key]['label'];
				var ftype = x.columns[key]['fieldtype'];
				var gridview = parseInt(x.columns[key]['gridview']);
				var editable = parseInt(x.columns[key]['editable']);
				if(gridview != 0 && key != "r_h_disp" && exists.indexOf(key) < 0) {
					list += "<li><div class=\"handle\"><span class=\"ui-icon grip-drag-action-button grip-drag-action-custom\"></span></div>\n"; //  + label + "</li>";
					list += "<label for=\"cb-" + key + "\"><input id=\"cb-" + key + "\" type=\"checkbox\">" + label + "</label></li>\n";
				}
			}
			
			for (var key in x.columns) {
				if (key === 'length' || !x.columns.hasOwnProperty(key) || key == "domain") continue;
				key = replaceAll(key, "s.", "");
				var custom = parseInt(x.columns[key]['custom']);
				if(custom) continue;
				var label = x.columns[key]['label'];
				var ftype = x.columns[key]['fieldtype'];
				var gridview = parseInt(x.columns[key]['gridview']);
				var editable = parseInt(x.columns[key]['editable']);
				if(gridview != 0 && key != "r_h_disp" && exists.indexOf(key) < 0) {
					list += "<li><div class=\"handle\"><span class=\"ui-icon grip-drag-action-button\"></span></div>\n"; //  + label + "</li>";
					list += "<label for=\"cb-" + key + "\"><input id=\"cb-" + key + "\" type=\"checkbox\">" + label + "</label></li>\n";
				}
			}
		}
	}
	$('#sdtablecolumns').html(list);
}

/////////////////////////////////////////////////////////////////////////////////////////

function sdcolumnsetup_submit()
{
	var checkedIds = $("#sdtablecolumns :checkbox:checked").map(function() {
        return this.id;
    }).get();
	
	var dgroup = $('#sdcolumnsetup-group').val();
	var datastr = get_ajax_datastr("set", "subdomain", "colmodel");
	datastr += "&group=" + encodeURIComponent(dgroup);

	var colsetup = "";
	var length = checkedIds.length;
	var columns = new Array();
	for (var i = 0; i < length; i++) 
	{
	  columns[i] = checkedIds[i].replace("cb-", "");
	  colsetup += columns[i];
	  if(i != (length-1))
		colsetup += ";";
	}
	$('#columnsetup-error').html("");
	datastr += "&columns=" + encodeURIComponent(colsetup);
	ajax_call(datastr, ajax_sdcolumnsetup_done, dgroup); 
}

/////////////////////////////////////////////////////////////////////////////////////////

function sdcolumnsetup_reset()
{
	var dgroup = $('#sdcolumnsetup-group').val();
	var datastr = get_ajax_datastr("set", "subdomain", "colmodel");
	datastr += "&group=" + encodeURIComponent(dgroup);
	datastr += "&columns=";
	ajax_call(datastr, ajax_sdcolumnsetup_done, dgroup); 
}

/////////////////////////////////////////////////////////////////////////////////////////

function ajax_sdcolumnsetup_done(x, jqXHR, textStatus, params)
{
	if(x != null) {
		if(x.status == 'ok') {
			// Make sure that the edit grid will work.
			// this is a hack for fixing callback function names in JS code
			// See Layout > getJSFile
			var i;
			for(i = 0; i < x.colmodel.length; i++) {
				if(typeof x.colmodel[i].editrules != 'undefined') {
					if(typeof x.colmodel[i].editrules.custom_func != 'undefined') {
						if(x.colmodel[i].editrules.custom_func == 'jsf_validateDate_jsf')
							x.colmodel[i].editrules.custom_func = validateDate;
					}
				}
			}
			//

			window[params] = x.colmodel;
			if(params == "subdomaingrid_columns_array")
				LoadSubdomainGrid();
			else if(params == "sslgrid_columns_array")
				LoadSSLGrid();
			hidePanelWithId("panel-sdcolumnsetup");
			setTimeout(function(){fixDivSizes();}, 150); 
		}
		else
			$('#sdcolumnsetup-error').html(x.error);
	}
}

/////////////////////////////////////////////////////////////////////////////////////////

function add_subdomains()
{
	var rowKey = jQuery("#domaintable").getGridParam("selarrrow"); 
	var rl = rowKey.length;
	if(rl == 1) {
		var rowData = jQuery("#domaintable").jqGrid ('getRowData', rowKey[0]);
		$('.subdomdata-domain').html(rowData['d.domain']);
		$('#subdomdata-domain').html(rowData['d.domain']);
		showPanel("panel-addsdom", 'right');
	}
	else {
	}
}

/////////////////////////////////////////////////////////////////////////////////////////

function ajax_add_subdomains(x, jqXHR, textStatus, params)
{
	if(x != null) {
		if(x.status == 'ok') {
			if(x.added > 0) {
				hideAllPanels();
				show_selected_domain_info();
			}
			else {
				$('#addsdom-error').html("Nothing added");
			}
		}
	}
}

/////////////////////////////////////////////////////////////////////////////////////////

function addsdom_submit()
{
	var subdomdata = $('#subdomdata').val();
	var sdtype = $('#select_sdtype').val();
	var domain = $('#subdomdata-domain').text();
	var datastr = get_ajax_datastr("add", "domain", "subdomains");
	datastr += "&data=" + encodeURIComponent(subdomdata) + "&domain=" + encodeURIComponent(domain);
	datastr += "&type=" + encodeURIComponent(sdtype);
	ajax_call(datastr, ajax_add_subdomains, null);
}
