var allow_hidden_leftpane = true;
var gutter_size = 6;

function initSplitter()
{
	setupPanes();
	setupTabs();
	fixDivSizes();
}

/////////////////////////////////////////////////////////////////////////////////////////
// The width percentages are tricky. Make sure that 
// the width calculated from percentage is not less 
// than the minSize (in pixels) specified

function setupPanes()
{
	var ww = $(window).width();
	// Percentage corresponding to 6 pixels
	var minwidth = (6/ww)*100; 
	var lp01 = getCookiePercent("left-pane-width", 20);
	
	// Hide leftpane in small screens
	if(ww >= 768 && lp01 < 20 && !allow_hidden_leftpane)
		lp01 = 20;
	if(lp01 < minwidth || ww <= 767)
		lp01 = minwidth;
	
	var lp02 = 100 - lp01;
	Split(['#leftpane', '#rightpane'], {
		sizes: [lp01, lp02],
		minSize: [2,150],
		snapOffset: 10,
		gutterSize: gutter_size,
		onDragEnd: function() {
			var lw = $("#leftpane").width();
			var rw = $("#rightpane").width();
			var p = lw * 100 / (lw+rw);
			saveCookie("left-pane-width", p);
			fixDivSizes();
			setTimeout(function(){fixDivSizes();}, 50);
		}
	});
	
	var tp01 = getCookiePercent("top-pane-width", 60);
	var tp02 = 100 - tp01;
	Split(['#toppane', '#bottompane'], {
		direction: 'vertical',
		sizes: [tp01, tp02],
		minSize: [200,20],
		snapOffset: 10,
		gutterSize: gutter_size,
		onDragEnd: function() {
			var th = $("#toppane").height();
			var bh = $("#bottompane").height();
			var p = th * 100 / (th+bh);
			saveCookie("top-pane-width", p);
			fixDivSizes();
			setTimeout(function(){fixDivSizes();}, 50);
		}
    });
	
	$(window).scroll(function () 
	{
		fixDivSizes();
	});
}

/////////////////////////////////////////////////////////////////////////////////////////

function setupTabs()
{
	$('#detailstab').tabs({
		activate: function(event, ui) 
		{
			var active = $('#detailstab').tabs('option', 'active');
			$.cookie('details_tab', active);
			fixDivSizes();
			setTimeout(function(){fixDivSizes();}, 50);
		}
	});
	var dti = getCookieInt('details_tab', 0);
	if(dti >= 0 && dti < 9)
		$( "#detailstab" ).tabs("option", "active", dti);
	
	$('#categorytab').tabs(
	{
		activate: function(event ,ui) 
		{
			var active = $('#categorytab').tabs('option', 'active');
			$.cookie('category_tab', active);
			fixDivSizes();
			fixDivSizes();
		}
    });
	var cti = getCookieInt('category_tab', 0);
	if(cti >= 0 && cti < 3)
		$( "#categorytab" ).tabs("option", "active", cti);
}
