/////////////////////////////////////////////////////////////////////////////////////////

var domain_grid_frozen_columns = false;

/////////////////////////////////////////////////////////////////////////////////////////

function initSizing()
{
	initInterfaceDivs();
	
	$('#logo').attr("src", header_logo_image);
	$('#biglogo').attr("src", header_logo_big_image);
	
	//if(getCookieInt("popmenu", 1))
	togglePopupMenu();
	
	$(window).bind('resize', function() {hideAllPanels(); fixDivSizes(); setTimeout(function(){fixDivSizes();}, 50);}).trigger('resize');
	
	$('body').show();
	setTimeout(function(){$('#loader').hide();}, 250);
}

/////////////////////////////////////////////////////////////////////////////////////////

function fixDivSizes()
{
	positionMainInterface();
	
	var dtpadx = 0;
	var dtpady = 0;
	var sgpadx = 0;
	var sgpady = 0;
	var ctpadx = 0, ctpady = 0;
	var widefit = $('#categorypane').css('padding-left') == "0px" ? true : false;
	if(widefit === true) {
		dtpadx = 23;
		dtpady = 23;
		sgpadx = 23;
		sgpady = 31;
		ctpadx = 21;
		ctpady = 24;
	}
	
	var domain_title_height = $('#domainpane').find('.ui-jqgrid-titlebar').outerHeight();
	var domain_header_height = $('#domainpane').find('.ui-jqgrid-htable').outerHeight();
	var domain_pager_height = $('#pg_domaintablepager').height();
	
	var domaintablewidth = $("#toppane").width()-(11*2) + dtpadx;
	var domaintableheight = $("#toppane").height()-domain_title_height-domain_pager_height-domain_header_height-20-4 + dtpady;
	
	// Decide if a horizontal scroller should appear for domain table.
	var DOMAINGRID_AUTO_WIDTH = (getCookieInt("domaingrid_auto_width", 1) == 1) ? true : false;
	var cm = jQuery("#domaintable").jqGrid('getGridParam','colModel');
	if(typeof cm != 'undefined' && cm != null) {
		var cw = domaintablewidth/(cm.length);
		if(cw < 70 && domaintablewidth > 0) {
			DOMAINGRID_AUTO_WIDTH = false;
			/*
			// Doing this causes any reload to crash.
			if(!domain_grid_frozen_columns) {
				jQuery("#domaintable").jqGrid('setColProp','domain', {frozen:true});
				jQuery("#domaintable").jqGrid('setColProp','r_h_disp', {frozen:true});
				jQuery("#domaintable").jqGrid('setFrozenColumns');
				$("#domaintable").trigger('reloadGrid', [{current:true}]);
				domain_grid_frozen_columns = true;
			}
			*/
		}
		else if(domain_grid_frozen_columns) {
			//jQuery("#domaintable").jqGrid('destroyFrozenColumns');
			//domain_grid_frozen_columns = false;
		}
	}
	
	jQuery("#domaintable").setGridWidth(domaintablewidth, DOMAINGRID_AUTO_WIDTH); 
	jQuery("#domaintable").setGridHeight(domaintableheight);
	$('#domaintablepager_left').css('width', '');
	
	var lpw = 0;
	if($("#leftpane").length != 0)
		lpw = $("#leftpane").width();
	if(lpw < 0)
		lpw = 0;
	var lph = $("#rightpane").height();
	
	var tabh = $(".ui-tabs-nav").height() + 6; 
	var ctw = lpw-(10*2);
	if(ctw < 0)
		ctw = 0;
	
	if($('#domaincategorytable').is(':visible')) {
		domain_pager_height = $('#pg_domaincategorytablepager').height();
		domain_header_height = $('#gbox_domaincategorytable').find('.ui-jqgrid-htable').outerHeight();
		var cth = lph-domain_pager_height-domain_header_height-tabh-20;
		jQuery("#domaincategorytable").setGridWidth(ctw+ctpadx, true); 
		jQuery("#domaincategorytable").setGridHeight(cth+ctpady); 
	}
	else if($('#domainquerytable').is(':visible')) {
		domain_pager_height = $('#pg_domainquerytablepager').height();
		domain_header_height = $('#gbox_domainquerytable').find('.ui-jqgrid-htable').outerHeight();
		var qth = lph-domain_pager_height-domain_header_height-tabh-20;
		jQuery("#domainquerytable").setGridWidth(ctw+ctpadx, true); 
		jQuery("#domainquerytable").setGridHeight(qth+ctpady); 
	}
	
	var bph = $("#bottompane").height();
	var tabh = $('#detailstab').find(".ui-tabs-nav").height() + 6; 
	var dtw = $("#bottompane").width()-(10*2) + 4;
	var dth = $("#bottompane").height()-tabh-24+8+2;
	
	var tabpadx = 0;
	var tabpady = 0;
	if(widefit === true) {
		tabpadx = 16;
		tabpady = 19;
	}
	
	jQuery("#detailstab").css('width', dtw+tabpadx);
	jQuery("#detailstab").css('height', dth+tabh+tabpady); 
	
	if(widefit === false)
		dtw -= 6;  // padding+border
	
	jQuery(".detailsbox").css('height', dth+tabpady); 
	jQuery(".detailsbox").css('width', dtw+tabpadx);
	
	DOMAINGRID_AUTO_WIDTH = (getCookieInt("domaingrid_auto_width", 1) == 1) ? true : false;
	var dcm = jQuery("#dnstable").jqGrid('getGridParam','colModel');
	if(typeof dcm != 'undefined' && dcm != null) {
		var cw = domaintablewidth/(dcm.length);
		if(cw < 70 && domaintablewidth > 0) {
			DOMAINGRID_AUTO_WIDTH = false;
		}
	}
	
	if($('#dnstable').is(':visible'))
	{
		domain_pager_height = $('#pg_dnstablepager').height();
		domain_header_height = $('#gbox_dnstable').find('.ui-jqgrid-htable').outerHeight();
		domain_title_height = $('#dnsdata').find('.ui-jqgrid-titlebar').outerHeight();
		jQuery("#dnstable").setGridWidth(dtw-5+sgpadx, DOMAINGRID_AUTO_WIDTH); 
		jQuery("#dnstable").setGridHeight($("#bottompane").height()-tabh-domain_pager_height-domain_title_height-domain_header_height-20-7+sgpady); 
	}
	if($('#ssltable').is(':visible'))
	{
		domain_pager_height = $('#pg_ssltablepager').height();
		domain_header_height = $('#gbox_ssltable').find('.ui-jqgrid-htable').outerHeight();
		domain_title_height = $('#ssl').find('.ui-jqgrid-titlebar').outerHeight();
		jQuery("#ssltable").setGridWidth(dtw-5+sgpadx, DOMAINGRID_AUTO_WIDTH); 
		jQuery("#ssltable").setGridHeight($("#bottompane").height()-tabh-domain_pager_height-domain_title_height-domain_header_height-20-7+sgpady); 
	}
	
	$("#domaintable,#dnstable,#ssltable").closest("div.ui-jqgrid-view")
    .children("div.ui-jqgrid-titlebar")
    .css("text-align", "center")
    .children("span.ui-jqgrid-title")
    .css("float", "none");
	
	positionCustomQueriesWindow();
}

/////////////////////////////////////////////////////////////////////////////////////////

function positionCustomQueriesWindow()
{
	var lph = $("#leftpane").height();
	var tabh = $('#categorytab').find(".ui-tabs-nav").height() + 6; 
	var panel_height = lph-tabh-20;
	$("#customqueries").css('height', panel_height+1);
	
	var offset = 0;
	if($("#customqueries-box").height() >= panel_height)
		offset = 24;
}

/////////////////////////////////////////////////////////////////////////////////////////

function positionMainInterface()
{
	var fh = 0;
	if($('#footer').is(':visible'))
		fh = $('#footer').outerHeight();
	
	var popwidth = 48; // pop-menu width + 6px gap.
	if($(window).height() < 520)
		$('#navbarmenu').css('max-height', $(window).height()-20);
	else
		$('#navbarmenu').css('max-height', 500);
	if(getCookieInt("popmenu", 1))
	{
		//if($(window).height() < 612)
		//	$('#popmenu').hide();
		//else
		$('#popmenu').show();
	}
	var popmgap = ($('#popmenu').is(':visible')) ? popwidth : 0;
	$('#content').css('margin-right', popmgap);
	var maxpanelwidth = $(window).width()-popmgap;
	maxpanelwidth = maxpanelwidth > 750 ? 750 : maxpanelwidth;
	$('.navmenu-outer').css('width', $(window).width()-20);
	$('.ui-dialog').css('width', maxpanelwidth);
	
	var headheight = $("#header").outerHeight();
	var dheight = $(window).height()-fh-headheight;
	if($(window).height() <= 612) 
		dheight = 612-fh-headheight;
	
	jQuery("#content").height(dheight, true); 
	$('#popmenu').css('top', headheight);
	$('#popmenu').css('right', 0);
	$('#popmenu').css('width', popwidth);
	$('#popmenu').css('height', dheight);
	$(".domaindata").css('height', dheight);
	
	$('.ui-dialog').css('max-height', dheight);
}

/////////////////////////////////////////////////////////////////////////////////////////

function togglePopupMenu()
{
	if($('#popmenu').is(':visible'))
	{
		$('#popmenu').hide("drop",  {direction:'right'}, 100 );
		saveCookie("popmenu", 0);
	}
	else
	{
		$('#popmenu').show("drop",  {direction:'right'}, 100 );
		saveCookie("popmenu", 1);
	}
	setTimeout(function(){fixDivSizes();}, 150);
}

function initInterfaceDivs()
{
	// Add a bunch of dummy divs so that we can adjust the colors
	$("#header").append('<div class="ui-widget-content" style="display:none"></div>');
	$("#header").append('<div class="ui-widget-header" style="display:none"></div>');
	$("#header").append('<div class="ui-state-default" style="display:none"></div>');
	$("#header").append('<div class="ui-state-highlight" style="display:none"></div>');
	$("#header").append('<div class="ui-state-active" style="display:none"></div>');
	$("#header").append('<div class="ui-state-hover" style="display:none"></div>');
	$("#header").append('<div class="ui-state-error" style="display:none"></div>');
}
