

/////////////////////////////////////////////////////////////////////////////////////////

$(function() 
{	
	initSplitter();
	
	$("#ludomains").click(function(event) {event.preventDefault(); DoLookups();});
	setInterval(function() {showSessionQueueCount(false);}, 60000);
	$("#queue_refresh").click(function(e){showSessionQueueCount(true);e.preventDefault();});
	
	var cid = getCookieInt('current_category', 0);
	$.cookie('current_category', cid == 0 ? default_category_selection : cid);
	$.cookie('current_autoquery', "0");
	
	initAllGrids();
	
	initSizing();
	initToolbar();
	
	setupTableColumns('tablecolumns');
	setupTableColumns('sdtablecolumns');
	
	$( "#categorylist" ).sortable({ handle: ".handle" }).find("li").addClass( "ui-corner-all" );
	$( "#querylist" ).sortable({ handle: ".handle" }).find("li").addClass( "ui-corner-all" );
	makeListSelectable('categorylist', 'cateditor-category');
	makeListSelectable('querylist', 'queryeditor-name');
	makeListSelectable('caticonlist', 'caticon-name');
	makeListSelectable('qiconlist', 'qicon-name');
	makeListSelectable('categorize-category', 'categorize-selected');
	makeListSelectable('regapisetuplist', null);
	
	$("#field_name").change(function() {
		customFieldNameChanged();
	});
	$('#field_name').on('input',function(e) {
		customFieldNameChanged();
	});
	
	$("#uadmin_uid").change(function() {
		userNameChanged();
	});
	$('#uadmin_uid').on('input',function(e) {
		userNameChanged();
	});
	
	$('#whoissetuptab').tabs({});
	
	var fs = getCookieInt("table-font-size", DEFAULT_TABLE_FONT_SIZE);
	$("#font-size-slider").slider({
		min: 1,
		max: 10,
		value: fs-10,
		change: function(event, ui) 
		{
			var srow = domain_table_jqgrid.jqGrid ('getGridParam', 'selrow');
			var fs = ui.value + 10;
			setTableFontSize(fs);
			saveCookie("table-font-size", fs);
			fixDivSizes();
			scrollToRow($("#domaintable"), srow);
			setTimeout(function(){fixDivSizes();}, 50);
        }
	});
	
	$('#domaingrid_auto_width').change(function() {
		if(this.checked)
			saveCookie("domaingrid_auto_width", 1);
		else
			saveCookie("domaingrid_auto_width", 0);
		$("#domaintable").trigger("reloadGrid");
	});

	$('#select_regapi').change(function() {
		addDomainSourceChanged();
	});
	addDomainSourceChanged();
	
	initToolbox();
	
	$('#minimize_transparency_level').change(function() {
		var minimize_transparency_level = 0;
		if(this.checked) 
			minimize_transparency_level = 1;
		var datastr = get_ajax_datastr("set", "ui", "");
		datastr += "&minimize_transparency_level=" + minimize_transparency_level;
		ajax_call(datastr, ajax_transparency_changed, null);
	});
});



function initAllGrids()
{
	LoadSubdomainGrid();
	LoadSSLGrid();
	LoadDomainCategoryGrid();
	LoadDomainQueryGrid();
	LoadDomainDataGrid(false);
	
	setDefaultFontSizes();
	$('#addsubd-submit').click(function(event) { event.preventDefault(); addSubDomains(); });
}

function initToolbox()
{
	$('.toolsButton').button();
	$('.toolsButton').click(function() {
		var selids = jQuery("#domaintable").getGridParam("selarrrow"); 
		if(selids.length == 1) {
			var domainname = jQuery("#domaintable").getCell(selids[0], "d.domain"); 
			var tname = $(this).data('name');
			var turl = $(this).data('url');
			turl = turl.replace(/{{domain}}/g, domainname);
			window.open(turl);
		}
		else
			custom_alert("Please select a domain", "Problem");
	});
}

