jQuery.extend($.fn.fmatter , 
{
    booleanFormatter : function(cellvalue, options, rowdata) 
	{
		if(cellvalue == 1)
			return '<img title="True" src="lib/layouts/images/icons/alerts/available-alert.png" alt="' + cellvalue + '">';
		else if(cellvalue == 0)
			return '<img title="False" src="lib/layouts/images/icons/alerts/not-available-alert.png" alt="' + cellvalue + '">';
		else if(cellvalue == null)
			return "";
	},
	domAvailFormatter : function(cellvalue, options, rowdata) 
	{
		if(cellvalue == "Available")
			return '<img title="Available domain" src="lib/layouts/images/icons/alerts/available-alert.png" alt="' + cellvalue + '">';
		else if(cellvalue == "Not Available")
			return '<img title="Not Available" src="lib/layouts/images/icons/alerts/not-available-alert.png" alt="' + cellvalue + '">';
		else if(cellvalue == "Setup Error")
			return '<img title="Setup Error" src="lib/layouts/images/icons/alerts/setup-error-alert.png" alt="' + cellvalue + '">';
		else if(cellvalue == null)
			return "";
		else
			return cellvalue;
	},
	registrarFormatter : function(cellvalue, options, rowdata) 
	{
		if(cellvalue == null)
			return "";
		if (typeof registrar_aliases != 'undefined') {
			if(cellvalue in registrar_aliases)
				return registrar_aliases[cellvalue];
		}
		return cellvalue;
	},
	highlightFormatter : function(cellvalue, options, rowdata) 
	{
		if(cellvalue == 15 && cellvalue != null)
			return '<img title="Nearing expiry" src="lib/layouts/images/icons/alerts/registry-expiry-alert.png" alt="' + cellvalue + '">';
		else if(cellvalue == 17 && cellvalue != null)
			return '<img title="Past expiry" src="lib/layouts/images/icons/alerts/registrar-expiry-alert.png" alt="' + cellvalue + '">';
		else if(cellvalue == 18 && cellvalue != null)
			return '<img title="Domain status alert" src="lib/layouts/images/icons/alerts/domain-pending-del-alert.png" alt="' + cellvalue + '">';
		else if(cellvalue == 16 && cellvalue != null)
			return '<img title="Nearing or past expiry" src="lib/layouts/images/icons/alerts/registrar-expiry-alert.png" alt="' + cellvalue + '">';
		else if(cellvalue == 14 && cellvalue != null)
			return '<img title="Unknown expiry date" src="lib/layouts/images/icons/alerts/unknown-expiry-alert.png" alt="' + cellvalue + '">';
		else if(cellvalue == 13 && cellvalue != null)
			return '<img title="No recent whois" src="lib/layouts/images/icons/alerts/search-required-alert.png" alt="' + cellvalue + '">';
		else if(cellvalue == 12 && cellvalue != null)
			return '<img title="Available domain" src="lib/layouts/images/icons/alerts/available-alert.png" alt="' + cellvalue + '">';
		else if(cellvalue == 11 && cellvalue != null)
			return '<img title="Requires whois search token setup" src="lib/layouts/images/icons/alerts/setup-error-alert.png" alt="' + cellvalue + '">';
		else if(cellvalue == 10 && cellvalue != null)
			return '<img title="Manually edited" src="lib/layouts/images/icons/alerts/manually-edited.png" alt="' + cellvalue + '">';
		else if(cellvalue == 19 && cellvalue != null)
			return '<img title="Write Protected" src="lib/layouts/images/icons/alerts/alert-lock.png" alt="' + cellvalue + '">';
		else if(cellvalue == null)
			return '<img title="Unknown" src="lib/layouts/images/icons/alerts/question-alert.png" alt="' + cellvalue + '">';
		else
			return '<img title="Unknown" src="lib/layouts/images/icons/alerts/unknown-alert.png" alt="' + cellvalue + '">';
	},
	categoryFormatter : function(cellvalue, options, rowdata) 
	{
		if(cellvalue != null)
			return '<img title="' + cellvalue + '" src="lib/layouts/images/icons/categories/' + cellvalue + '" alt="' + cellvalue + '">';
	}
});

jQuery.extend($.fn.fmatter.domAvailFormatter , 
{
    unformat : function(cellvalue, options, cell) 
	{
		if(cellvalue == null)
			return "";
		return $('span', cell).attr('title');
	}
});

jQuery.extend($.fn.fmatter.booleanFormatter , 
{
    unformat : function(cellvalue, options, cell) 
	{
		if(cellvalue == null)
			return "";
		return $('span', cell).attr('title');
	}
});

jQuery.extend($.fn.fmatter.highlightFormatter , 
{
    unformat : function(cellvalue, options, cell) 
	{
		if(cellvalue == null)
			return "";
		return $('span', cell).attr('title');
	}
});

jQuery.extend($.fn.fmatter.categoryFormatter , 
{
    unformat : function(cellvalue, options, cell) 
	{
		if(cellvalue == null)
			return "";
		return $('span', cell).attr('title');
	}
});

jQuery.extend($.fn.fmatter.registrarFormatter , 
{
    unformat : function(cellvalue, options, cell) 
	{
		if(cellvalue == null)
			return "";
		if (typeof registrar_aliases != 'undefined') {
			var reg = getKeyByValue(registrar_aliases, cellvalue);
			if(typeof reg != "undefined" && reg !== false)
				return reg;
		}
		return cellvalue;
	}
});
