/////////////////////////////////////////////////////////////////////////////////////////

var SELECTED_GRID_ROWS = 1;
var ALL_GRID_ROWS = 2;
var ALL_DBTABLE_ROWS = 3;

/////////////////////////////////////////////////////////////////////////////////////////

function download_domain_data()
{
	var rowtype = parseInt($('#row-type').val());
	var coltype = $('#column-type').val();
	var filename = $('#download_file_name').val();
	var delimiter = $('#download_delimiter').val();
	downloadDomainTableRows("domaintable", rowtype, coltype, filename, delimiter);
}

/////////////////////////////////////////////////////////////////////////////////////////

function init_panel_download()
{
	var datastr = get_ajax_datastr("download", "csvdata", "get");
	ajax_call(datastr, ajax_init_downloadlist, null);
	
	show_selected_domains();
	$('#download-error').html('');
	$("#row-type").off('change');
	$("#row-type").change(function(event){
		rowTypeChanged();
	});
	rowTypeChanged();

	$("#download-bgprocess").off('change');
	$("#download-bgprocess").change(function(event){
		downloadModeChanged();
	});
	downloadModeChanged();
}

/////////////////////////////////////////////////////////////////////////////////////////

function ajax_init_downloadlist(x, jqXHR, textStatus, params)
{
	if(x != null) {
		$('#download-error').html('');
		var cbdata = '';
		if(x.status == 'ok') {
			var count = x.data.length;
			for(var i = 0; i < count; i++) {
				var name = x.data[i].name;
				var id = parseInt(x.data[i].id);
				var desc = x.data[i].description;
				if(desc != "")
					desc = " [" + desc + "]";
				if(id > 0) {
					cbdata += '<option value="' + id + '">' + name + desc + '</option>';
				}
			}
			$('#select_csv_report').html(cbdata);
		}
	}
}

/////////////////////////////////////////////////////////////////////////////////////////

function refresh_download_list()
{
	var datastr = get_ajax_datastr("download", "csvdata", "get");
	ajax_call(datastr, ajax_init_downloadlist, null);
}

/////////////////////////////////////////////////////////////////////////////////////////

function download_domain_report()
{
	$('#download-error').html('');
	var rid = $('#select_csv_report').val();
	if(parseInt(rid) > 0) {
		var datastr = get_ajax_datastr("download", "csvdata", "get");
		datastr += "&id=" + encodeURIComponent(rid);
		datastr += "&mode=csv"
		var posturl = app_root_url + api_url_path + "?";
		$("#csvdownload").append('<form id="exportform" action="' + posturl + datastr + '" method="post"></form>');
		$("#exportform").submit().remove();
	}
	return true;
}

/////////////////////////////////////////////////////////////////////////////////////////

function delete_domain_report()
{
	$('#download-error').html('');
	confirm_delete_domain_report();
}

/////////////////////////////////////////////////////////////////////////////////////////

function confirm_delete_domain_report()
{
	var rid = $('#select_csv_report').val();
	if(parseInt(rid) > 0) {
		var datastr = get_ajax_datastr("download", "csvdata", "del");
		datastr += "&id=" + encodeURIComponent(rid);
		ajax_call(datastr, ajax_init_downloadlist, null);
	}
}

/////////////////////////////////////////////////////////////////////////////////////////

function rowTypeChanged()
{
	var rowtype = parseInt($('#row-type').val());
	if(rowtype != SELECTED_GRID_ROWS) {
		$('#download-selected').hide();
	}
	else {
		$('#download-selected').show();
	}
	$('#download-error').html('');
}

/////////////////////////////////////////////////////////////////////////////////////////

function downloadModeChanged()
{
	var bgproc = $('#download-bgprocess').is(':checked') ? "1" : "0";
	if(parseInt(bgproc)) {
		$('#download-domain-data').text('Schedule');
	}
	else {
		$('#download-domain-data').text('Download Now');
	}
}

/////////////////////////////////////////////////////////////////////////////////////////

function downloadDomainTableRows(gridid, rowtype, colmode, filename, delimiter)
{
	$('#download-error').html('');
	var bgproc = $('#download-bgprocess').is(':checked') ? "1" : "0";

	var sids = "";
	if(rowtype == SELECTED_GRID_ROWS) {
		var rowids = [];
		sids = jQuery("#"+gridid).getGridParam("selarrrow");
		for(var i = 0; i < sids.length; i++) {
			var s = parseInt(sids[i]);
			rowids.push(s);
		}
		sids = rowids.join(",");
	}
	
	var tablecolumns = [];
	var columns = jQuery("#"+gridid).getGridParam("colModel");
	for(i = 0; i < columns.length; i++) {
		if(columns[i].name != "rn" && columns[i].name != "cb" && columns[i].name != "r_h_disp" && columns[i].name != "s.r_h_disp" && columns[i].name != "d.r_h_disp" && columns[i].name != "subgrid") {
			tablecolumns.push(columns[i].name);
		}
	}
	columns = tablecolumns.join(",");

	var description = "";
	if(rowtype == SELECTED_GRID_ROWS)
		description += " Selected Rows";
	else if(rowtype == ALL_GRID_ROWS)
		description += " Grid Rows";
	else if(rowtype == ALL_DBTABLE_ROWS)
		description += " All Rows";
	if(colmode == "domain")
		description += " & Domain Names";
	else if(colmode == "grid")
		description += " & Grid Columns";
	else if(colmode == "all")
		description += " & All Columns";

	var posturl = app_root_url + api_url_path + "?";
	datastr = get_ajax_datastr("download", "domain", "");
	datastr += "&id=" + encodeURIComponent(sids);
	datastr += "&columns=" + encodeURIComponent(columns);
	datastr += "&colmode=" + encodeURIComponent(colmode);
	datastr += "&csv_sep=" + encodeURIComponent(delimiter);
	datastr += "&description=" + encodeURIComponent(description);
	if(rowtype == ALL_GRID_ROWS) {
		var aqid = getCookieInt('current_autoquery', 0);
		var cid = getCookieInt('current_category', 0);
		if(cid > 0)
			datastr += "&cid=" + cid;
		else if(aqid > 0)
			datastr += "&aqid=" + aqid;
		else if(custom_query_in_use)
			datastr += "&" + getCustomQueryData();
	}

	if(rowtype == SELECTED_GRID_ROWS && sids == "") {
		$('#download-error').html('Nothing to download');
		return false;
	}
	var sortname = getCookie('current_sort_column', "sid");
	var sortorder = getCookie('current_sort_order', "desc");
	datastr += "&sidx=" + encodeURIComponent(sortname);
	datastr += "&sord=" + encodeURIComponent(sortorder);

	datastr += "&filename=" + encodeURIComponent(filename);
	if(parseInt(bgproc)) {
		datastr += "&bgproc=" + encodeURIComponent(bgproc);
		ajax_call(datastr, ajax_download_csvdata, null);
	}
	else {
		$("#csvdownload").append('<form id="exportform" action="' + posturl + datastr + '" method="post"></form>');
		$("#exportform").submit().remove();
		return true;
	}
}

/////////////////////////////////////////////////////////////////////////////////////////

function ajax_download_csvdata(x, jqXHR, textStatus, params)
{
	if(x != null) {
		if(x.status == 'ok') {
		}
		$('#download-error').html(x.error);
	}
}