/////////////////////////////////////////////////////////////////////////////////////////

var cateditor_selected_id = 0;
var userids_for_categories = []

/////////////////////////////////////////////////////////////////////////////////////////

function cateditor_before_popup()
{
	var ht = $('.panel-card-body').css('max-height');
	ht = parseInt(ht.replace("px", "")) - 40 - 24 - 18;
	var clht = ht -  $('#ce-legend-catlist').height() -  $('#cateditor-category').height();
	if(clht > 320)
		clht = 320;
	$('#categorylist').css('height', clht);
	var htu = clht - $('#ce-legend-users').height() - $('#ce-legend-icons').height();
	$('#catuserlist').css('height', htu/2);
	$('#caticonlist').css('height', htu/2);
}

/////////////////////////////////////////////////////////////////////////////////////////

function init_cateditor_for(catid)
{
	$('#cateditor-category').val('');
	cateditor_selected_id = catid;
	var datastr = get_ajax_datastr("get", "category", "info");
	datastr += "&users=yes";
	ajax_call(datastr, ajax_init_cateditor, null);
	return true;
}

/////////////////////////////////////////////////////////////////////////////////////////

function init_panel_cateditor()
{
	cateditor_selected_id = 0;
	$('#cateditor-category').val('')
	var datastr = get_ajax_datastr("get", "category", "info");
	datastr += "&users=yes";
	ajax_call(datastr, ajax_init_cateditor, null);
}

/////////////////////////////////////////////////////////////////////////////////////////

function ajax_init_cateditor(x, jqXHR, textStatus, params)
{
	if(x != null) {
		var cbdata = '';
		var list = '';
		var iconlist = '';
		if(x.status == 'ok') {
			count = x.users.length;
			for(var i = 0; i < count; i++) {
				var name = x.users[i].name;
				var id = x.users[i].id;
				var admin = x.users[i].admin;
				if(!admin) {
					list += '<li class="list-group-item ui-selectee">'; 
					list += "<label for=\"cb-cateditor-" + id + "\"><input class=\"cb-listgroup cb-userids\" id=\"cb-cateditor-" + id + "\" type=\"checkbox\">" + name + "</label></li>";
				}
			}
			
			userids_for_categories = [];
			var count = x.ids.length;
			for(var i = 0; i < count; i++) {
				var name = x.ids[i].name;
				var id = x.ids[i].id;
				var caticon = x.ids[i].caticon;
				var caticonidname = caticon.replace(".png", "-png");
				if(id > 1) {
					cbdata += "<li class=\"ui-selectee\" id=\"li-cateditor-" + id  + "\">";
					cbdata += "<div class=\"handle\"><span id=\"caticon-" + id + "-" + caticonidname + "\" class=\"ui-icon grip-drag-action-button\" style=\"background-position: 0 0; background-image: url(lib/layouts/images/icons/categories/" + caticon + ")\"></span></div>";
					cbdata += name + "</li>\n";
					var ulist = [];
					var uc = x.ids[i].userids.length;
					for(var j = 0; j < uc; j++) {
						var uid = x.ids[i].userids[j];
						ulist.push(uid);
					}
					userids_for_categories[id] = ulist;
				}
			}
			selectUsersForCategory(cateditor_selected_id);
			
			count = x.icons.length;
			for(var i = 0; i < count; i++) {
				var name = x.icons[i];
				var img = 'lib/layouts/images/icons/categories/' + name;
				var idname = name.replace(".png", "-png");
				iconlist += '<li id="li-caticon-' + idname + '" class="list-group-item ui-selectee" style=\"background-position: 0 0px; background-image: url(' + img + ')\">' + name + '</li>'; 
			}
		}
		$('#categorylist').html(cbdata);
		$('#catuserlist').html(list);
		$('#caticonlist').html(iconlist);
		$('#caticonlist').html(iconlist);
	}
	
	if(cateditor_selected_id != 0) {
		$('#categorylist' + ' li').each(function() {
			$(this).removeClass('ui-state-highlight');
			$(this).removeClass('ui-selected');
		});
		$('#li-cateditor-' + cateditor_selected_id).addClass('ui-state-highlight');
		$('#li-cateditor-' + cateditor_selected_id).addClass('ui-selected');
		setTimeout(function(){categoryEditorSelected('li-cateditor-'+cateditor_selected_id);}, 150); 
		showSelector('#categorylist', '#li-cateditor-' + cateditor_selected_id);
	}
	else {
		$("#caticonlist").addClass('disabled',true);
		$("#catuserlist").addClass('disabled',true);
	}
}

/////////////////////////////////////////////////////////////////////////////////////////

function selectUsersForCategory(cid)
{
	var thiscid = parseInt(cid);
	$('.cb-userids').prop('checked', false);
	if(typeof userids_for_categories[thiscid] != "undefined") {
		var uc = userids_for_categories[thiscid].length;
		for(var i = 0; i < uc; i++) {
			var uid = userids_for_categories[thiscid][i];
			$('#cb-cateditor-' + uid).prop('checked', true);
		}
	}
}

/////////////////////////////////////////////////////////////////////////////////////////

function categoryIconSelected(liid)
{
	//var iconname = liid.replace("li-caticon-", "").replace("-png", ".png");
}

/////////////////////////////////////////////////////////////////////////////////////////

function categoryEditorSelected(liid)
{
	cateditor_selected_id = liid.replace("li-cateditor-", "");
	
	var catname = $('#'+liid).text();
	$('#cateditor-category').val(catname);
	
	$('#caticonlist' + ' li').each(function() {
		$(this).removeClass('ui-state-highlight');
		$(this).removeClass('ui-selected');
	});
	
	var caticon = $("#"+liid).find(".grip-drag-action-button").attr("id");
	caticon = caticon.replace("caticon-"+cateditor_selected_id+"-", "");
	
	$('#li-caticon-' + caticon).addClass('ui-state-highlight');
	$('#li-caticon-' + caticon).addClass('ui-selected');
	
	showSelector('#caticonlist', '#li-caticon-' + caticon);
	
	$("#caticonlist").removeClass('disabled',true);
	$("#catuserlist").removeClass('disabled',true);
	
	selectUsersForCategory(cateditor_selected_id);
}

/////////////////////////////////////////////////////////////////////////////////////////

function ajax_submit_cateditor(x, jqXHR, textStatus, params)
{
	if(x != null) {
		var cbdata = '';
		var list = '';
		var iconlist = '';
		if(x.status == 'ok') {
			if(x.changed > 0) {
				$("#domaincategorytable").trigger("reloadGrid"); 
				var icon = x.icon;
				var iconidname = icon.replace(".png", "-png");
				var name = x.name;
				var id = x.id;
				var liid = "li-cateditor-" + id;
				var elem = $('#' + liid).find('span');
				var bgimage = 'url(lib/layouts/images/icons/categories/' + icon + ')';
				
				var cbdata = "<div class=\"handle\"><span id=\"caticon-" + id + "-" + iconidname + "\" class=\"ui-icon grip-drag-action-button\" style=\"background-position: 0 0; background-image: url(lib/layouts/images/icons/categories/" + icon + ")\"></span></div>";
				cbdata += name;
					
				$('#' + liid).html(cbdata);
				//$(elem).css('background-image',bgimage);
			}
		}
	}
}

/////////////////////////////////////////////////////////////////////////////////////////

function cateditor_submit()
{
	var iconid = "";
	$('#caticonlist' + ' li').each(function() {
		if($(this).hasClass('ui-selected')) {
			iconid = $(this).attr('id');
			iconid = iconid.replace("li-caticon-", "");
			iconid = iconid.replace("-png", ".png");
		}
	});
	
	var catids = [];
	$('#categorylist' + ' li').each(function() {
		var catid = $(this).attr('id').replace("li-cateditor-", "");
		catids.push(catid);
	});
	
	var uids = []
	$(".cb-userids").each(function() {
		if($(this).is(':checked')) 
			uids.push($(this).attr('id').replace("cb-cateditor-", ""));
	});
	userids_for_categories[cateditor_selected_id] = uids;
	
	var datastr = get_ajax_datastr("set", "category", "info");
	datastr += "&id=" + cateditor_selected_id;
	datastr += "&name=" + encodeURIComponent($('#cateditor-category').val());
	datastr += "&icon=" + encodeURIComponent(iconid);
	datastr += "&ids=" + encodeURIComponent(catids.join(","));
	datastr += "&uids=" + encodeURIComponent(uids.join(","));
	ajax_call(datastr, ajax_submit_cateditor, null);
}

