/////////////////////////////////////////////////////////////////////////////////////////

var user_names = [];

/////////////////////////////////////////////////////////////////////////////////////////

function ajax_init_userlist(x, jqXHR, textStatus, params)
{
	if(x != null) {
		var list = '';
		if(x.status == 'ok') {
			user_names = [];
			var count = x.users.length;
			for(var i = 0; i < count; i++) {
				var name = x.users[i].name;
				var id = x.users[i].id;
				var admin = x.users[i].admin;
				if(admin)
					list += '<li id="li-ua-' + name + '" class="list-group-item ui-selectee">' + name + '</li>'; 
				else
					list += '<li id="li-ua-' + name + '" class="list-group-item ui-selectee defaultcolumn">' + name + '</li>'; 
				user_names.push(name);
			}
			$('#userlist').html(list);
			$('#uadmin_uid').val('');
			userNameChanged();
			
			var ht = $('#userlist-editor').height();
			if($(window).width() < 768)
				ht = 220;
			$('#userlist').css('min-height', ht);
			$('#userlist').css('max-height', ht);
		}
		$('#useradmin-error').html(x.error);
		make_list_selectable("userlist", 'userSelected');
	}
}

/////////////////////////////////////////////////////////////////////////////////////////

function ajax_init_catlist(x, jqXHR, textStatus, params)
{
	if(x != null) {
		var cbdata = '';
		if(x.status == 'ok') {
			var count = x.ids.length;
			for(var i = 0; i < count; i++) {
				var name = x.ids[i].name;
				var id = x.ids[i].id;
				if(id > 1) {
					cbdata += '<option value="' + id + '">' + name + '</option>';
				}
			}
			$('#uadmin_catlist').html(cbdata);
			$('#uadmin_catlist').multipleSelect();
			userNameChanged();
		}
		var ht = $('#userlist-editor').height();
		if($(window).width() < 768)
			ht = 220;
		$('#userlist').css('min-height', ht);
		$('#userlist').css('max-height', ht);
	}
}


/////////////////////////////////////////////////////////////////////////////////////////

function init_useradmin()
{
	$("#uadmin_uid").off('change');
	$("#uadmin_uid").change(function() {
		userNameChanged();
	});
	
	$('#useradmin-add').off('click');
	$('#useradmin-add').click(function(event){
		event.preventDefault();
		useradmin_add();
	});
	$('#useradmin-delete').off('click');
	$('#useradmin-delete').click(function(event){
		event.preventDefault();
		useradmin_delete();
	});
	$('#useradmin-update').off('click');
	$('#useradmin-update').click(function(event){
		event.preventDefault();
		useradmin_update();
	});
	
	var datastr = get_ajax_datastr("admin", "users", "list");
	ajax_call(datastr, ajax_init_userlist, null);
}

/////////////////////////////////////////////////////////////////////////////////////////

function ajax_get_userinfo(x, jqXHR, textStatus, params)
{
	if(x != null) {
		if(x.status == 'ok') {
			$('#uadmin_display').val(x.data['dname']);
			var rights = x.data['rights'];
			var val = [];
			
			if(rights == 65535)
				val.push(rights);
			else {
				for(var i = 0; i < 11; i++) {
					var idx = Math.pow(2, i);
					if(idx & rights)
						val.push(idx);
				}
			}
			$('#uadmin_rights').multipleSelect('setSelects', val);
			
			$('#uadmin_status').val(x.data['active']);
			$('#uadmin_last_signin').html(x.data['last_sign_in_stamp']);
			$('#uadmin_added_on').html(x.data['added_on']);
			$('#uadmin_access').val(x.data['acslevel']);
			if(x.data['rights'] == 65535 || bit_test(x.data['rights'], ALLOW_ALLDOMAINS_BITPOS))
				$('#uadmin_catlist').multipleSelect('checkAll');
			else
				$('#uadmin_catlist').multipleSelect('setSelects', x.data['cids']);
			if(params !== false)
				userNameChanged();
		}
	}
}

/////////////////////////////////////////////////////////////////////////////////////////

function userSelected(liid)
{
	var username = liid.replace("li-ua-", "");
	$('#uadmin_uid').val(username);
	var datastr = get_ajax_datastr("admin", "users", "get");
	datastr += "&name=" + encodeURIComponent(username);
	ajax_call(datastr, ajax_get_userinfo, true);
}

/////////////////////////////////////////////////////////////////////
// Custom Columns

function userNameChanged()
{
	$("#useradmin-delete").hide();
	$("#useradmin-update").hide();
	$("#useradmin-add").hide();
		
	var name = $('#uadmin_uid').val();
	if(typeof name !== "undefined")
		name = name.trim();
	else
		name = "";
	if(jQuery.inArray(name,user_names) != -1 || name == "") {
		$("#useradmin-delete").show();
		$("#useradmin-update").show();
		
		var datastr = get_ajax_datastr("admin", "users", "get");
		datastr += "&name=" + encodeURIComponent(name);
		ajax_call(datastr, ajax_get_userinfo, false);
	}
	else if(name != "") {
		$("#useradmin-add").show();
		$('#uadmin_rights').multipleSelect('setSelects', []);
		$('#uadmin_status').val("1");
		$('#uadmin_access').val("0");
		$('#uadmin_catlist').multipleSelect('setSelects', []);
	}
}

/////////////////////////////////////////////////////////////////////////////////////////

function get_selected_user_rights()
{
	var selected = $('#uadmin_rights').multipleSelect('getSelects');
	var rights = 0;
	for(var i = 0; i < selected.length; i++) {
		var s = parseInt(selected[i]);
		rights |= s;
	}
	return rights;
}

/////////////////////////////////////////////////////////////////////////////////////////

function get_selected_categories()
{
	var selected = $('#uadmin_catlist').multipleSelect('getSelects');
	var rights = []
	for(var i = 0; i < selected.length; i++) {
		var s = parseInt(selected[i]);
		rights.push(s);
	}
	return rights;
}

/////////////////////////////////////////////////////////////////////////////////////////

function useradmin_add()
{
	var name = $('#uadmin_uid').val();
	var dname = $('#uadmin_display').val();
	var pass = $('#uadmin_key').val();
	var rights = get_selected_user_rights();
	var status = $('#uadmin_status').val();
	var acslevel = $('#uadmin_access').val();
	var cids = get_selected_categories();
	cids = cids.join(',');

	$('#useradmin-error').html('');
	if(name.length < 6) {
		$('#useradmin-error').html('User name should be 6 characters or more'); 
	}
	else if(pass.length < 8) {
		$('#useradmin-error').html('Password should be 8 characters or more'); 
	}
	else {
		var datastr = get_ajax_datastr("admin", "users", "add");
		datastr += "&name=" + encodeURIComponent(name);
		datastr += "&dname=" + encodeURIComponent(dname);
		datastr += "&pass=" + encodeURIComponent(pass);
		datastr += "&rights=" + encodeURIComponent(rights) + "&status=" + encodeURIComponent(status);
		datastr += "&cids=" + encodeURIComponent(cids);
		datastr += "&acslevel=" + encodeURIComponent(acslevel);
		datastr += "&list=1";
		ajax_call(datastr, ajax_init_userlist, null);
	}
}

/////////////////////////////////////////////////////////////////////////////////////////

function ajax_updated_userlist(x, jqXHR, textStatus, params)
{
	if(x != null) {
		var list = '';
		if(x.status == 'ok') {
			userNameChanged();
		}
	}
}

/////////////////////////////////////////////////////////////////////////////////////////

function useradmin_update()
{
	var name = $('#uadmin_uid').val();
	var dname = $('#uadmin_display').val();
	var pass = $('#uadmin_key').val();
	var rights = get_selected_user_rights();
	var status = $('#uadmin_status').val();
	var acslevel = $('#uadmin_access').val();
	var cids = get_selected_categories();
	cids = cids.join(',');
	
	$('#useradmin-error').html('');
	if(jQuery.inArray(name,user_names) != -1 || name == "") {
		if(pass != "" && pass.length < 8)
			$('#useradmin-error').html('The password should be 8 characters or more'); 
		else {
			var datastr = get_ajax_datastr("admin", "users", "edit");
			datastr += "&name=" + encodeURIComponent(name);
			datastr += "&dname=" + encodeURIComponent(dname);
			if(pass != "")
				datastr += "&pass=" + encodeURIComponent(pass);
			datastr += "&rights=" + encodeURIComponent(rights) + "&status=" + encodeURIComponent(status);
			datastr += "&cids=" + encodeURIComponent(cids);
			datastr += "&acslevel=" + encodeURIComponent(acslevel);
			ajax_call(datastr, ajax_updated_userlist, null);
		}
	}
}

/////////////////////////////////////////////////////////////////////////////////////////

function useradmin_delete()
{
	var name = $('#uadmin_uid').val();
	var datastr = get_ajax_datastr("admin", "users", "del");
	datastr += "&name=" + encodeURIComponent(name);
	datastr += "&list=1";
	ajax_call(datastr, ajax_init_userlist, null);
}
