/////////////////////////////////////////////////////////////////////////////////////////
// suffixlist.js
// Watch My Domains SED v4
// (c) Softnik Technologies. All rights reserved.
/////////////////////////////////////////////////////////////////////////////////////////

var suffix_table_jqgrid = null;
var base_grid_ajax_url  = app_root_url + api_url_path;
var user_access_rights  = parseInt(user_details['rights']);

/////////////////////////////////////////////////////////////////////////////////////////

var suffixlistgrid_columns_array = [
	{"label": "Suffix (eTLD)", "width": "150", "name": "suffix", "classes": "dtcell", "sortable": true, "search": true}, 
	{"label": "Base TLD", "width": "70", "name": "tld", "classes": "dtcell", "sortable": true, "search": true},
	{"label": "A", "width": "48", "name": "manual_added", "classes": "dtcell", "sortable": true, "sorttype": "int", "search": false, "fixed": true, "align":'center', formatter:'checkbox'}
	];

/////////////////////////////////////////////////////////////////////////////////////////

function init_suffixlist()
{
	$('#suffixlist-error').html('');
	$('#suffixdata').css('min-height', 300);
	LoadSuffixListGrid();
	setTableFontSize(getCookieInt("table-font-size", DEFAULT_TABLE_FONT_SIZE));
	$(window).bind('resize', function() {setGridWidth(); setTimeout(function(){setGridWidth();}, 50);}).trigger('resize');
	initEnterKeyHandler("domain_parser_input", "domain-parser-submit");
}

/////////////////////////////////////////////////////////////////////////////////////////

function setGridWidth()
{
	var wd = $("#suffixdata").width();
	var ht = $("#suffixdata").height()-24;
	jQuery("#suffixtable").setGridWidth(wd, true); 
	jQuery("#suffixtable").setGridHeight(ht < 200 ? ht : 200, true); 
}

/////////////////////////////////////////////////////////////////////////////////////////

function LoadSuffixListGrid()
{
	var unloaded = false;
	if(suffix_table_jqgrid != null) {
		suffix_table_jqgrid.GridUnload();
		unloaded = true;
	}
	var datastr = get_ajax_datastr("grid", "suffixlist", "");
	var durl = base_grid_ajax_url + "?" + datastr + "&columns=id,suffix,tld,manual_added";
	var rownumbers = $(window).width() > 768 ? true : false;
	suffix_table_jqgrid = jQuery("#suffixtable").jqGrid({
		hidegrid: false,
		height: $("#suffixdata").height()-120,
		width: $("#suffixdata").width()-24,
		altRows:true,
		altclass: "suffix_grid_alt_row",
		url: durl,
		datatype: "json",
		colModel: suffixlistgrid_columns_array,
		rowNum:200,
		rowList:[100,200,500,1000,2000],
		rownumWidth: 50,
		rownumbers: rownumbers,
		viewrecords: true,
		pginput: false,
		//caption:"Public Suffix List",
		pager: "#suffixtablepager",
		gridView: true,
		scrollOffset:18,
		sortname: 'manual_added',
		sortorder: 'desc',
		shrinkToFit: true,
		recordtext: "{2}",
		loadError: function (jqXHR, textStatus, errorThrown) {
			gridSessionTimedoutError(jqXHR);
		},
		loadComplete : function () {setGridWidth();},
		onCellSelect: function (rowid, iCol, cellcontent) {
			if(iCol == 1) {
				cellcontent = $("<div/>").html(cellcontent).text();
				var prefix = $('#domain_parser_input').val().trim();
				if(prefix == "") 
					prefix = "www.example";
				else {
					while (prefix[prefix.length-1] === ".")
						prefix = prefix.slice(0,-1);
				}
				var entry = prefix + "." + cellcontent;
				if(entry != "") {
					$('#suffixlist-error').html('Please wait');
					var datastr = get_ajax_datastr("get", "domain", "parse");
					datastr += "&data=" + encodeURIComponent(entry);
					ajax_call(datastr, ajax_suffix_parse, null);
				}
			}
		}
	});
	jQuery("#suffixtable").navGrid('#suffixtablepager', {add:false,edit:false,del:false,search:false},{},{},{});
	jQuery("#suffixtable").jqGrid('filterToolbar',{stringResult: true,searchOnEnter : false});
	if(unloaded) 
		setTableFontSize(getCookieInt("table-font-size", DEFAULT_TABLE_FONT_SIZE));
}

/////////////////////////////////////////////////////////////////////////////////////////

function suffix_entry_delete()
{
	var entry = $('#public_suffix_entry').val().trim();
	if(entry != "") {
		$('#confirm-message').html("<h4>Delete a suffix entry!</h4><p>Are you sure you want to delete the suffix entry<br>\"" + entry + "\"?</p>");
		$('#confirm-caller').val("suffix_delete_confirmed");
		showPanel("panel-confirm");
	}
}

function delete_suffix_entry()
{
	suffix_entry_delete();
}

function suffix_delete_confirmed()
{
	var entry = $('#public_suffix_entry').val().trim();
	if(entry != "") {
		$('#suffixlist-error').html('Please wait');
		var datastr = get_ajax_datastr("admin", "suffixlist", "del");
		datastr += "&data=" + encodeURIComponent(entry);
		ajax_call(datastr, ajax_suffix_action, null);
	}
}

function add_suffix_entry()
{
	var entry = $('#public_suffix_entry').val().trim();
	if(entry != "") {
		$('#suffixlist-error').html('Please wait');
		var datastr = get_ajax_datastr("admin", "suffixlist", "add");
		datastr += "&data=" + encodeURIComponent(entry);
		ajax_call(datastr, ajax_suffix_action, null);
	}
}

function ajax_suffix_action(x, jqXHR, textStatus, params)
{
	if(x != null) {
		if(x.status == 'ok') {
			$('#suffixlist-error').html('ok');
			$("#suffixtable").trigger("reloadGrid");
		}
		else
			$('#suffixlist-error').html(x.error);
	}
}

function domain_parser_submit()
{
	$('#domain-parser-input').html('');
	$('#domain-parser-domain').html('');
	$('#domain-parser-subdomain').html('');
	$('#domain-parser-tld').html('');
	var entry = $('#domain_parser_input').val().trim();
	if(entry != "") {
		$('#suffixlist-error').html('Please wait');
		var datastr = get_ajax_datastr("get", "domain", "parse");
		datastr += "&data=" + encodeURIComponent(entry);
		ajax_call(datastr, ajax_suffix_parse, null);
	}
}

function ajax_suffix_parse(x, jqXHR, textStatus, params)
{
	if(x != null) {
		if(x.status == 'ok') {
			$('#suffixlist-error').html('');
			$('#domain-parser-entry').html(x.data[0].input);
			$('#domain-parser-domain').html(x.data[0].domain);
			$('#domain-parser-subdomain').html(x.data[0].subdomain);
			$('#domain-parser-tld').html(x.data[0].tld);
		}
		else
			$('#suffixlist-error').html(x.error);
	}
}
