var luscheduler_list = [];
var autoquery_data = [];

/////////////////////////////////////////////////////////////////////////////////////////

function init_scheduler()
{
	// Get List of Autoqueries 
	// the current user is an admin, so will get all available categories.
	var datastr = get_ajax_datastr("admin", "query", "get");
	datastr += "&id=0";
	ajax_call(datastr, ajax_scheduler_query_list, null);
	
	// Get Schedulers
	datastr = get_ajax_datastr("admin", "schedule", "get");
	ajax_call(datastr, ajax_scheduler_list, null);
	
	$('#lusch-name').off('input');
	$('#lusch-name').on('input',function(e) {
		scheduler_name_changed();
	});
	$('#lusch-name').off('change');
	$('#lusch-name').change(function(event) {
		scheduler_name_changed();
	});
	scheduler_name_changed();
	
	$('#lusch-add').off('click');
	$('#lusch-add').click(function(event){
		event.preventDefault();
		add_new_scheduler();
	});
	
	$('#lusch-update').off('click');
	$('#lusch-update').click(function(event){
		event.preventDefault();
		update_scheduler();
	});
	
	$('#lusch-delete').off('click');
	$('#lusch-delete').click(function(event){
		event.preventDefault();
		delete_scheduler();
	});
	
	$('#lusch-resetall').off('click');
	$('#lusch-resetall').click(function(event){
		event.preventDefault();
		reset_scheduler();
	});
	
	/*
	$('#lusch-copy-autoquery').off('click');
	$('#lusch-copy-autoquery').click(function(event){
		event.preventDefault();
		lusch_copy_autoquery();
	});
	*/
}

/////////////////////////////////////////////////////////////////////////////////////////

function ajax_scheduler_query_list(x, jqXHR, textStatus, params)
{
	if(x != null) {
		if(x.status == 'ok') {
			var options = '';
			autoquery_data = x.ids;
			var count = x.ids.length;
			for(var i = 0; i < count; i++) {
				var id = x.ids[i].id;
				if(id > 1) {
					var name = x.ids[i].name;
					options += "<option value=\"" + id + "\">" + name + "</options>\n";
				}
			}
			$('#lusch-autoqueries').html(options);
		}
	}
}

/////////////////////////////////////////////////////////////////////////////////////////

function ajax_scheduler_list(x, jqXHR, textStatus, params)
{
	if(x != null) {
		luscheduler_list = [];
		var lidata = "";
		if(x.status == 'ok') {
			var schlist = x.schedules;
			for(var i = 0; i < schlist.length; i++) {
				var id = schlist[i].id;
				var name = schlist[i].name;
				luscheduler_list.push(name.toLowerCase());
				lidata += "<li class=\"list-group-item ui-selectee\" id=\"li-schnames-" + id + "\">" + name + "</li>\n";
			}
		}
		$('#scheduler-list').html(lidata);
		make_list_selectable('scheduler-list', "luschedule_selected");
		
		$('#scheduler-list').css('max-height', 280);
		//var ht = $('#lusch-listbox').height();
		$('#lutype-list').css('max-height', 120);
		//$('#scheduler-category').css('min-height', ht);
		
		if(params == "refresh")
			scheduler_name_changed();
	}
}

/////////////////////////////////////////////////////////////////////////////////////////

function scheduler_name_changed()
{
	if(luscheduler_list.length == 0) {
		$('#lusch-add').show();
		$('#lusch-delete').hide();
		$('#lusch-update').hide();
	}
	else {
		var name = $('#lusch-name').val();
		var lidx = luscheduler_list.indexOf(name.toLowerCase());
		if(lidx >= 0) {
			// The typed in name matches an entry in the list, select it the list.
			$('#lusch-add').hide();
			$('#scheduler-list li').each(function() {
				$(this).removeClass('ui-state-highlight');
				$(this).removeClass('ui-selected');
			});
			$("#scheduler-list li:nth-child(" + (lidx+1) + ")").addClass('ui-selected ui-state-highlight');
			var liid = $("#scheduler-list li:nth-child(" + (lidx+1) + ")").attr('id');
			luschedule_selected(liid);
		}
		else {
			if(name != "")
				$('#lusch-add').show();
			else
				$('#lusch-add').hide();
			$('#lusch-delete').hide();
			$('#lusch-update').hide();
		}
	}
}

/////////////////////////////////////////////////////////////////////////////////////////

function luschedule_selected(liid)
{
	var luscheduler_selected_id = liid.replace("li-schnames-", "");
	var datastr = get_ajax_datastr("admin", "schedule", "get");
	datastr += "&id=" + luscheduler_selected_id;
	ajax_call(datastr, ajax_schedule_info, null);
}

/////////////////////////////////////////////////////////////////////////////////////////

function ajax_schedule_info(x, jqXHR, textStatus, params)
{
	if(x != null) {
		if(x.status == 'ok') {
			if(parseInt(x.lunits) < 0 || parseInt(x.lunits) > 5)
				x.lunits = 4;
			$('#lusch-lunits').val(x.lunits);
			$('#lusch-frequency').val(parseInt(x.frequency));
			$('#lusch-name').val(x.name);
			$('#lusch-query').val(x.query);
			$('#lusch-params').val(x.params);
			
			// $('#lusch-enabled').prop('checked', x.enabled == "1");
			$('#lusch-enabled').val(x.enabled);
			
			$('.cb-lusch-lutype').prop('checked', false); 
			var lutype = x.lutype;
			if(lutype&DOMAIN_RECORDS)
				$('#cb-scheduler-dw').prop('checked', true);
			if(lutype&ROOT_DNS)
				$('#cb-scheduler-ip').prop('checked', true);
			if(lutype&HTTP_WEBSITE)
				$('#cb-scheduler-http').prop('checked', true);
			if(lutype&ALEXA_DATA)
				$('#cb-scheduler-alexa').prop('checked', true);
			if(lutype&PING_RESPONSE)
				$('#cb-scheduler-ping').prop('checked', true);
			if(lutype&SSL_CERTS)
				$('#cb-scheduler-ssl').prop('checked', true);
			if(lutype&IP_WHOIS)
				$('#cb-scheduler-ipw').prop('checked', true);
			if(lutype&SUB_DOMAINS)
				$('#cb-scheduler-dns').prop('checked', true);
			if(lutype&GOOGLE_INDEX)
				$('#cb-scheduler-gi').prop('checked', true);

			//$('#lusch-lutype').val(x.lutype);
			
			$('#lusch-add').hide();
			$('#lusch-delete').show();
			$('#lusch-update').show();
		}
	}
}

/////////////////////////////////////////////////////////////////////////////////////////

function get_lookup_types()
{
	var lutype = 0;
	if($('#cb-scheduler-dw').is(":checked")) 
		lutype |= DOMAIN_RECORDS;
	if($('#cb-scheduler-ip').is(":checked")) 
		lutype |= ROOT_DNS;
	if($('#cb-scheduler-http').is(":checked")) 
		lutype |= HTTP_WEBSITE;
	if($('#cb-scheduler-alexa').is(":checked")) 
		lutype |= ALEXA_DATA;
	if($('#cb-scheduler-ping').is(":checked")) 
		lutype |= PING_RESPONSE;
	if($('#cb-scheduler-ssl').is(":checked")) 
		lutype |= SSL_CERTS;
	if($('#cb-scheduler-ipw').is(":checked")) 
		lutype |= IP_WHOIS;
	if($('#cb-scheduler-dns').is(":checked")) 
		lutype |= SUB_DOMAINS;
	if($('#cb-scheduler-gi').is(":checked")) 
		lutype |= GOOGLE_INDEX;
	return lutype;
}

/////////////////////////////////////////////////////////////////////////////////////////

function get_scheduler_data(oper)
{
	var name = $('#lusch-name').val();
	var frequency = $('#lusch-frequency').val();
	var lunits = parseInt($('#lusch-lunits').val());
	var lutype = get_lookup_types();
	var query = $('#lusch-query').val();
	var params = $('#lusch-params').val();
	var enabled = $('#lusch-enabled').val(); //$('#lusch-enabled').is(":checked") ? "1" : "0";
	var datastr = "";
	var foundInList = luscheduler_list.indexOf(name.toLowerCase()) >= 0;
	var doIt = (oper == "add") ? !foundInList : foundInList;
	if(name != "" && doIt) {
		datastr = get_ajax_datastr("admin", "schedule", oper);
		datastr += "&name=" + encodeURIComponent(name);
		datastr += "&frequency=" + encodeURIComponent(frequency);
		datastr += "&lunits=" + encodeURIComponent(lunits);
		datastr += "&lutype=" + encodeURIComponent(lutype);
		datastr += "&query=" + encodeURIComponent(query);
		datastr += "&params=" + encodeURIComponent(params);
		datastr += "&enabled=" + encodeURIComponent(enabled);
	}
	return datastr;
}

/////////////////////////////////////////////////////////////////////////////////////////

function delete_scheduler()
{
	var datastr = get_scheduler_data("del");
	ajax_call(datastr, ajax_update_scheduler, "new");
}

/////////////////////////////////////////////////////////////////////////////////////////

function update_scheduler()
{
	var datastr = get_scheduler_data("set");
	ajax_call(datastr, ajax_update_scheduler, null);
}

/////////////////////////////////////////////////////////////////////////////////////////

function add_new_scheduler()
{
	var datastr = get_scheduler_data("add");
	ajax_call(datastr, ajax_update_scheduler, "new");
}

/////////////////////////////////////////////////////////////////////////////////////////

function ajax_update_scheduler(x, jqXHR, textStatus, params)
{
	if(x != null) {
		if(x.status == 'ok') {
			if(params == "new") {
				datastr = get_ajax_datastr("admin", "schedule", "get");
				ajax_call(datastr, ajax_scheduler_list, "refresh");
			}
		}
	}
}

/////////////////////////////////////////////////////////////////////////////////////////

function reset_scheduler()
{
	$('#confirm-message').html("<h4>Are you sure you want to reset the scheduler settings?</h4><p>You will lose any custom changes you have made.</p>");
	$('#confirm-caller').val("confirm_reset_scheduler");
	showPanel("panel-confirm");
}

/////////////////////////////////////////////////////////////////////////////////////////

function confirm_reset_scheduler()
{
	var datastr = get_ajax_datastr("admin", "schedule", "reset");
	ajax_call(datastr, ajax_reset_scheduler, "new");
}

/////////////////////////////////////////////////////////////////////////////////////////

function ajax_reset_scheduler(x, jqXHR, textStatus, params)
{
	if(x != null) {
		if(x.status == 'ok') {
			datastr = get_ajax_datastr("admin", "schedule", "get");
			ajax_call(datastr, ajax_scheduler_list, "refresh");
		}
	}
}

/////////////////////////////////////////////////////////////////////////////////////////
/*
function lusch_copy_autoquery()
{
	var query = $('#lusch-query').val();
	var params = $('#lusch-params').val();
	if(query != "" || params != "") {
		$('#confirm-message').html("<h4>Are you sure you want to copy the query and parameters?</h4><p>Your existing setting will change.</p>");
		$('#confirm-caller').val("confirm_copy_query");
		showPanel("panel-confirm");
	}
	else
		confirm_copy_query();
}

/////////////////////////////////////////////////////////////////////////////////////////

function confirm_copy_query()
{
	var aqid = $('#lusch-autoqueries').val();
	var count = autoquery_data.length;
	for(var i = 0; i < count; i++) {
		if(aqid == autoquery_data[i].id) {
			$('#lusch-query').val(autoquery_data[i].query);
			$('#lusch-params').val(autoquery_data[i].params);
			break;
		}
	}
}
*/
/////////////////////////////////////////////////////////////////////////////////////////

