
function init_samlsetup()
{
	$('#samlsetup_error').html('');
	var datastr = get_ajax_datastr("admin", "auth", "getsaml");
	ajax_call(datastr, ajax_getsaml_done, null);
		
	// On IDP  Change
	$('#saml_idp').off('change');
	$('#saml_idp').change(function(event) {
		saml_idp_changed();
	});
	saml_idp_changed();
}

/////////////////////////////////////////////////////////////////////////////////////////

function saml_idp_changed()
{
	$('#samlsetup_error').html('');
	var samlidp = $('#saml_idp').val();
	if(samlidp == "default") {
		$('#saml_idp_setup').html('');
	}
	else {
		var datastr = get_ajax_datastr("admin", "auth", "getsaml");
		datastr += "&idp=" + encodeURIComponent(samlidp);
		ajax_call(datastr, ajax_getsaml_done, "idp");
	}
}

/////////////////////////////////////////////////////////////////////////////////////////

function ajax_getsaml_done(x, jqXHR, textStatus, params)
{
	if(x != null) {
		if(x.status == 'ok') {
			if(params == null && typeof x.idp != "undefined") {
				$('#saml_idp').val(x.idp);
				saml_idp_changed();
			}
			if(params == "idp") {
				initSAMlIDP(x.idp, x.keys, x.keyvals, x.enabled);
			}
			$('#saml_force').prop('checked', x.saml_force);
			$('#saml_match').val(x.saml_match);
			$('#saml_allow_logout').prop('checked', x.saml_allow_logout);
		}
	}
}

/////////////////////////////////////////////////////////////////////////////////////////

function ajax_setsaml_done(x, jqXHR, textStatus, params)
{
	if(x != null) {
		if(x.status == 'ok') {
			$('#samlsetup_error').html('OK');
		}
		else
			$('#samlsetup_error').html(x.error);
	}
}

/////////////////////////////////////////////////////////////////////////////////////////

function initSAMlIDP(idp, keyinfo, keyvals, enabled)
{
	var form = '<form autocomplete="off" method="post" action="">';
	var keys = $.map(keyinfo, function(element,index) {return index});
	var l = keys.length;
	for(var i = 0; i < l; i++) {
		if(keys[i] != "") {
			var kid = idp.toLowerCase() + "_" + replaceAll(keys[i].trim().toLowerCase(), " ", "_");
			kid = replaceAll(kid, "-", "_");
			form += "<p class=\"small mb-1\"><b>" + keyinfo[keys[i]][2] + "</b></p>";
			if(keyinfo[keys[i]][0] == "text")
				form += "<textarea class=\"form-control mb-3 idp-mode-key\" rows=\"4\" id=\"" + kid + "\" name=\"" + kid + "\">" + keyvals[keys[i]] + "</textarea>";
			else if(keyinfo[keys[i]][0] == "boolean") {
				var selyes = "";
				var selno = "";
				if(keyvals[keys[i]] == "yes")
					selyes = " selected";
				else
					selno = " selected";
				form += "<select class=\"form-control mb-3 idp-mode-key\" id=\"" + kid + "\" name=\"" + kid + "\"><option value=\"yes\"" + selyes + ">Yes</option><option value=\"no\"" + selno + ">No</option></select>";
			}
			else
				form += "<input type=\"text\" class=\"form-control mb-3 idp-mode-key\" id=\"" + kid + "\" name=\"" + kid + "\" value=\"" + keyvals[keys[i]] + "\" placeholder=\"" + keys[i] + "\">";
		}
	}
	if(enabled == false && mode != "default") {
		form += "<p class=\"small\"><code>" + mode + " is currently not available for actual use (probably in beta / test mode)</code></p>";
	}
	form += '</form>';
	$('#saml_idp_setup').html(form);
}

/////////////////////////////////////////////////////////////////////////////////////////

function samlsetup_save()
{
	$('#samlsetup_error').html('');
	var idpmode = $('#saml_idp').val();
	var saml_force = $('#saml_force').is(':checked') ? "1" : "0";
	var saml_match = $('#saml_match').val();
	var saml_allow_logout = $('#saml_allow_logout').is(':checked') ? "1" : "0";
	var datastr = get_ajax_datastr("admin", "auth", "setsaml");
	datastr += "&idp=" + encodeURIComponent(idpmode);
	datastr += "&saml_force=" + encodeURIComponent(saml_force);
	datastr += "&saml_match=" + encodeURIComponent(saml_match);
	datastr += "&saml_allow_logout=" + encodeURIComponent(saml_allow_logout);
	
	var ids = $('.idp-mode-key').map(function() {
		var id = $(this).attr('id');
		var val = $(this).val();
		return "&" + id.replace("idp-", "") + "=" + encodeURIComponent(val);
	});
	datastr += ids.toArray().join("");
	ajax_call(datastr, ajax_setsaml_done, null);
}

/////////////////////////////////////////////////////////////////////////////////////////
