/////////////////////////////////////////////////////////////////////////////////////////

var reg_api_data = [];
var reg_api_selected = "";

/////////////////////////////////////////////////////////////////////////////////////////

function init_regapisetup()
{
	$('#apisetupform').html('<p>Please select an API profile from the list.</p>');
	//var datastr = "c=admin&t=regapi&oper=list";
	var datastr = get_ajax_datastr("admin", "regapi", "list");
	ajax_call(datastr, ajax_regapisetup_list, null);
	make_list_selectable('regapisetuplist', "regapi_selected");
	
	$('#apisetup-save').off('click');
	$('#apisetup-save').click(function(event){
		event.preventDefault();
		apisetup_save();
	});
	
	$('#apisetup-new').off('click');
	$('#apisetup-new').click(function(event){
		event.preventDefault();
		apisetup_new();
	});
	
	$('#apisetup-delete').off('click');
	$('#apisetup-delete').click(function(event){
		event.preventDefault();
		apisetup_delete();
	});

	$('#apisetup-test').off('click');
	$('#apisetup-test').click(function(event){
		event.preventDefault();
		apisetup_test();
	});
}

/////////////////////////////////////////////////////////////////////////////////////////

function ajax_regapisetup_list(x, jqXHR, textStatus, params)
{
	if(x != null) {
		if(x.status == 'ok') {
			reg_api_data = x.data;
			var count = x.profiles.length;
			var lidata = "";
			for(var i = 0; i < count; i++) {
				var name = x.profiles[i];
				var params = x.data[name];
				lidata += "<li class=\"list-group-item ui-selectee\" id=\"li-regapisetup-" + name  + "\">";
				lidata += name + "</li>\n";
			}
			$('#regapisetuplist').html(lidata);
			regapi_selected("");
		}
	}
}

/////////////////////////////////////////////////////////////////////////////////////////

function regapi_selected(apiid)
{
	var apiname = apiid.replace("li-regapisetup-", "");
	reg_api_selected = apiname;
	var form = '<form autocomplete="off" method="post" action="">';
	form += '<input autocomplete="false" name="hidden" type="password" style="display:none;">';
	if(apiname != "") {
		var keys = reg_api_data[apiname].keys
		var count = keys.length;
		for(var i = 0; i < count; i++) {
			var kid = "apisetup-key-" + replaceAll(apiname.trim().toLowerCase(), " ", "-") + "-" + i;
			form += "<div class=\"input-group input-group-sm\">";
			form += "<input type=\"password\" autocomplete=\"off\" class=\"form-control mb-3\" id=\"" + kid + "\" name=\"" + kid + "\" placeholder=\"" + keys[i] + "\">";
			form += "<div class=\"input-group-append\"><span class=\"input-group-text\"><a class=\"btn-pwpview\" id=\"pwpview-" + kid + "\"><img src=\"lib/layouts/images/icons/16/pwshow.png\"></a></span></div>";
			form += "</div>";
		}
	}
	form += '</form>';
	if(apiname != "") {
		var registrar = reg_api_data[apiname].registrar;
		form = "<h5>" + registrar + "</h5>" + form;
	}
	$('#apisetup-profile').html(apiname);
	$('#apisetupform').html(form);
	$('#apisetup-error').html("");

	$('.btn-pwpview').off('click');
	$('.btn-pwpview').click(function(event){
		event.preventDefault();
		var cpid = $(this).attr('id');
		cpid = cpid.replace("pwpview-", "");
		if($('#'+cpid).attr("type") == "text") {
			$('#'+cpid).attr("type", "password");
			$('#pwpview-'+cpid + ' img').attr('src', 'lib/layouts/images/icons/16/pwshow.png');
		}
		else if($('#'+cpid).attr("type") == "password") {
			$('#'+cpid).attr("type", "text");
			$('#pwpview-'+cpid + ' img').attr('src', 'lib/layouts/images/icons/16/pwhide.png');
		}
	});
}

/////////////////////////////////////////////////////////////////////////////////////////

function apisetup_save()
{
	$('#apisetup-error').html("");
	if(reg_api_selected != "") {
		var allkeys = [];
		var allvalues = [];
		var keys = reg_api_data[reg_api_selected].keys;
		var count = keys.length;
		for(var i = 0; i < count; i++) {
			var kid = "apisetup-key-" + replaceAll(reg_api_selected.trim().toLowerCase(), " ", "-") + "-" + i;
			var keyname = keys[i];
			var keyvalue = $('#' + kid).val();
			allkeys.push(keyname);
			allvalues.push(keyvalue);
		}
		var datastr = get_ajax_datastr("admin", "regapi", "set");
		datastr += "&name=" + encodeURIComponent(reg_api_selected);
		datastr += "&keys=" + encodeURIComponent(allkeys.join("\n"));
		datastr += "&data=" + encodeURIComponent(allvalues.join("\n"));
		ajax_call(datastr, ajax_regapisetup_save, null);
	}
}

/////////////////////////////////////////////////////////////////////////////////////////

function ajax_regapisetup_save(x, jqXHR, textStatus, params)
{
	if(x != null) {
		if(x.status == 'ok') {
			$('#apisetup-error').html("OK");
		}
		else {
			$('#apisetup-error').html(x.error);
		}
	}
}

/////////////////////////////////////////////////////////////////////////////////////////

function apisetup_new()
{
	var name = $('#profilename').val();
	var registrar = $('#registrarlist').val();
	if(name != "" && registrar != "") {
		var datastr = get_ajax_datastr("admin", "regapi", "add");
		datastr += "&name=" + encodeURIComponent(name);
		datastr += "&registrar=" + encodeURIComponent(registrar);
		ajax_call(datastr, ajax_regapisetup_new, null);
	}
}

/////////////////////////////////////////////////////////////////////////////////////////

function apisetup_test()
{
	$('#apisetup-error').html('<img src="lib/layouts/images/loaders/ajax-loader.gif">');
	var name = reg_api_selected;
	if(name != "") {
		var datastr = get_ajax_datastr("admin", "regapi", "test");
		datastr += "&name=" + encodeURIComponent(name);
		ajax_call(datastr, ajax_regapisetup_test, null);
	}
}

/////////////////////////////////////////////////////////////////////////////////////////

function ajax_regapisetup_test(x, jqXHR, textStatus, params)
{
	if(x != null) {
		if(x.status == 'ok') {
			$('#apisetup-error').html("It works");
		}
		else {
			$('#apisetup-error').html(x.error);
		}
	}
}

/////////////////////////////////////////////////////////////////////////////////////////

function apisetup_delete()
{
	$('#confirm-message').html("<h4>Delete profile!</h4><p>Are you sure you want to delete the registrar / data source profile<br>\"" + reg_api_selected + "\"?</p>");
	$('#confirm-caller').val("apisetup_delete_confirmed");
	showPanel("panel-confirm");
}

/////////////////////////////////////////////////////////////////////////////////////////

function apisetup_delete_confirmed()
{
	var name = reg_api_selected;
	if(name != "") {
		var datastr = get_ajax_datastr("admin", "regapi", "del");
		datastr += "&name=" + encodeURIComponent(name);
		ajax_call(datastr, ajax_regapisetup_new, null);
	}
}

/////////////////////////////////////////////////////////////////////////////////////////

function ajax_regapisetup_new(x, jqXHR, textStatus, params)
{
	if(x != null) {
		if(x.status == 'ok') {
			var datastr = get_ajax_datastr("admin", "regapi", "list");
			ajax_call(datastr, ajax_regapisetup_list, null);
		}
	}
}


/////////////////////////////////////////////////////////////////////////////////////////
