var tld_table_jqgrid = null;
var selected_tld_row = '';

/////////////////////////////////////////////////////////////////////////////////////////

var tldgrid_columns_array = [
	{"label": "TLD", "width": "50", "name": "tld", "classes": "dtcell", "sortable": true, "search": true}, 
	{"label": "RDAP", "width": "160", "name": "rdap_server", "classes": "dtcell", "sortable": true, "search": true},
	{"label": "LUS", "width": "48", "name": "lu_sequence", "classes": "dtcell", "sortable": true, "sorttype": "int", "search": true, "fixed": true, "align":'left'}
	];
	
/////////////////////////////////////////////////////////////////////////////////////////

function init_rdapsetup()
{
	$('#tlddata').css('min-height', 300);
	LoadTLDGrid();
	setTableFontSize(getCookieInt("table-font-size", DEFAULT_TABLE_FONT_SIZE));
	$(window).bind('resize', function() {setTLDGridWidth(); setTimeout(function(){setTLDGridWidth();}, 50);}).trigger('resize');
}

/////////////////////////////////////////////////////////////////////////////////////////

function setTLDGridWidth()
{
	var wd = $("#tlddata").width();
	var ht = $("#tlddata").height()-24;
	jQuery("#tldtable").setGridWidth(wd, true); 
	jQuery("#tldtable").setGridHeight(ht < 200 ? ht : 200, true); 
}

/////////////////////////////////////////////////////////////////////////////////////////

function rdapsetup_save_server()
{
	$('#rdapsetup-error').html('Please wait');
	var tld = $('#rdapsetup-tld').val();
	var server = $('#rdapsetup-server').val();
	var lus = $('#rdapsetup-sequence').val();
	var datastr = get_ajax_datastr("set", "rdap", "server");
	datastr += "&tld=" + encodeURIComponent(tld);
	datastr += "&server=" + encodeURIComponent(server);
	datastr += "&lus=" + encodeURIComponent(lus);
	if(server == "" && lus > 0)
		$('#rdapsetup-error').html("No RDAP Server! the Lookup Sequence has to be 'Only Whois'");
	else
		ajax_call(datastr, ajax_rdap_set, null);
}

/////////////////////////////////////////////////////////////////////////////////////////

function rdapsetup_get_server()
{
	var tld = $('#rdapsetup-tld').val();
	$('#rdapsetup-error').html('Please wait');
	$('#rdapsetup-server').val('');
	$('#rdapsetup-sequence').val(0);
	var datastr = get_ajax_datastr("get", "rdap", "server");
	datastr += "&tld=" + encodeURIComponent(tld);
	ajax_call(datastr, ajax_rdap_get, null);
}

/////////////////////////////////////////////////////////////////////////////////////////

function ajax_rdap_get(x, jqXHR, textStatus, params)
{
	if(x != null) {
		$('#rdapsetup-error').html('');
		if(x.status == 'ok') {
			$('#rdapsetup-server').val(x.rdap_server);
			if(x.lu_sequence == "")
				x.lu_sequence = 0;
			$('#rdapsetup-sequence').val(x.lu_sequence);
			//$("#tldtable").trigger("reloadGrid");
		}
		$('#rdapsetup-error').html(x.error);
	}
}

/////////////////////////////////////////////////////////////////////////////////////////

function ajax_rdap_set(x, jqXHR, textStatus, params)
{
	if(x != null) {
		$('#rdapsetup-error').html('');
		if(x.status == 'ok') {
			$('#rdapsetup-server').val(x.rdap_server);
			$('#rdapsetup-sequence').val(x.lu_sequence);
			$('#rdapsetup-error').html('OK');
			$("#tldtable").trigger("reloadGrid"); 
		}
		else
			$('#rdapsetup-error').html(x.error);
	}
}

/////////////////////////////////////////////////////////////////////////////////////////

function LoadTLDGrid()
{
	var unloaded = false;
	if(tld_table_jqgrid != null) {
		tld_table_jqgrid.GridUnload();
		unloaded = true;
	}
	var datastr = get_ajax_datastr("grid", "tlds", "");
	var durl = base_grid_ajax_url + "?" + datastr + "&columns=tld,rdap_server,lu_sequence";
	//console.log(durl);
	var rownumbers = $(window).width() > 768 ? true : false;
	tld_table_jqgrid = jQuery("#tldtable").jqGrid({
		hidegrid: false,
		height: $("#tlddata").height()-120,
		width: $("#tlddata").width()-24,
		altRows:true,
		altclass: "tld_grid_alt_row",
		url: durl,
		datatype: "json",
		colModel: tldgrid_columns_array,
		rowNum:200,
		rowList:[100,200,500,1000,2000],
		rownumWidth: 50,
		rownumbers: rownumbers,
		viewrecords: true,
		pginput: false,
		//caption:"Public tld List",
		pager: "#tldtablepager",
		gridView: true,
		scrollOffset:18,
		sortname: 'tld',
		sortorder: 'desc',
		shrinkToFit: true,
		recordtext: "{2}",
		loadError: function (jqXHR, textStatus, errorThrown) {
			gridSessionTimedoutError(jqXHR);
		},
		loadComplete : function () {$("#tldtable").setSelection(selected_tld_row, true); scrollToRow($("#tldtable"), selected_tld_row);setGridWidth();},
		onCellSelect: function (rowid, iCol, cellcontent) {
			$('#rdapsetup-error').html('');
			var rowData = jQuery("#tldtable").jqGrid ('getRowData', rowid);
			$('#rdapsetup-tld').val(rowData['tld']);
			$('#rdapsetup-server').val(rowData['rdap_server']);
			if(rowData['lu_sequence'] == "")
				rowData['lu_sequence'] = 0;
			$('#rdapsetup-sequence').val(rowData['lu_sequence']);
			selected_tld_row = rowid;
		}
	});
	jQuery("#tldtable").navGrid('#tldtablepager', {add:false,edit:false,del:false,search:false},{},{},{});
	jQuery("#tldtable").jqGrid('filterToolbar',{stringResult: true,searchOnEnter : false});
	if(unloaded) 
		setTableFontSize(getCookieInt("table-font-size", DEFAULT_TABLE_FONT_SIZE));
}

function rdapsetup_refresh_rdap()
{
	$('#rdapsetup-error').html('Please wait');
	var datastr = get_ajax_datastr("set", "task", "add");
	datastr += "&name=" + encodeURIComponent("set_RDAP_Servers");
	ajax_call(datastr, ajax_refresh_rdap, null);
}

/////////////////////////////////////////////////////////////////////////////////////////

function ajax_refresh_rdap(x, jqXHR, textStatus, params)
{
	if(x != null) {
		if(x.status == 'ok') {
			$('#rdapsetup-error').html('A background task was created to refresh RDAP server list.');
		}
		else
			$('#rdapsetup-error').html(x.error);
	}
}

/////////////////////////////////////////////////////////////////////////////////////////

function rdapsetup_rdap_all()
{
	set_lus_setting(1);
}

function rdapsetup_whois_all()
{
	set_lus_setting(0);
}

function set_lus_setting(lus)
{
	if(lus == 0)
		$('#confirm-message').html("<h4>Are you sure?</h4><p>This will set all lookups to use Whois.</p>");
	else if(lus == 1)
		$('#confirm-message').html("<h4>Are you sure?</h4><p>This will set all lookups to try RDAP first.</p>");
	$('#confirm-caller').val("confirm_set_lus");
	$('#confirm-param').val(lus);
	showPanel("panel-confirm");
}

function confirm_set_lus()
{
	$('#rdapsetup-error').html('Please wait');
	var datastr = get_ajax_datastr("set", "rdap", "lus");
	var lus = $('#confirm-param').val()
	datastr += "&lus=" + encodeURIComponent(lus);
	ajax_call(datastr, ajax_set_lus, null);
}

/////////////////////////////////////////////////////////////////////////////////////////

function ajax_set_lus(x, jqXHR, textStatus, params)
{
	$('#rdapsetup-tld').val('');
	$('#rdapsetup-server').val('');
	$('#rdapsetup-sequence').val(0);
	if(x != null) {
		$('#rdapsetup-error').html('');
		if(x.status == 'ok') {
			$("#tldtable").trigger("reloadGrid"); 
		}
		else
			$('#rdapsetup-error').html(x.error);
	}
}

