var current_error_log_file = '';

function init_errorlogs()
{
	var datastr = get_ajax_datastr("admin", "log", "list");
	datastr += "&name=" + encodeURIComponent(name);
	ajax_call(datastr, ajax_init_errorlogs, null);
	make_list_selectable("errorlog-files", 'logfile_selected');
}

function ajax_init_errorlogs(x, jqXHR, textStatus, params)
{
	$('#errorlog-data').html('');
	
	var list = "";
	var firstfile = "";
	if(x != null) {
		if(x.status == 'ok') {
			var files = x.data;
			for(var i = (x.data.length-1); i >= 0; i--) {
				var file = x.data[i];
				var id = file;
				list += "<li id=\"li-el-" + id + "\" class=\"list-group-item list-group-flush ui-selectee\">" + file + "</li>";
				if(firstfile == "")
					firstfile = file;
			}
		}
	}
	if(firstfile != "")
		logfile_selected(firstfile);
	$('#errorlog-files').html(list);
	
	$('#errorlog-delete').off('click');
	$('#errorlog-delete').click(function(event){
		event.preventDefault();
		delete_errorlog_file(current_error_log_file);
	});
	
	$('#errorlog-deleteall').off('click');
	$('#errorlog-deleteall').click(function(event){
		event.preventDefault();
		delete_errorlog_file("all");
	});
	
	$('#errorlog-files').css('min-height', 200);
	var ht = $('#errorlog-files').height() + ($('#errorlog-delete').height()*2)+60;
	if(ht >= 400)
		ht = 400;
	$('#errorlog-data').css('max-height', ht);
	$('#errorlog-data').css('height', ht);
}

function delete_errorlog_file(filename)
{
	if(filename != "") {
		if(filename == "all")
			$('#confirm-message').html("<h4>Are you sure you want to delete all the error log files?</h4><p>All files will be permanently deleted</p>");
		else
			$('#confirm-message').html("<h4>Are you sure you want to delete the error log file?</h4><p>The file " + filename + " will be permanently deleted</p>");
		$('#confirm-caller').val("confirm_delete_errorlog");
		$('#confirm-param').val(filename);
		showPanel("panel-confirm");
	}
}

function confirm_delete_errorlog()
{
	$('#errorlog-data').html('');
	var datastr = get_ajax_datastr("admin", "log", "del");
	var filename = $('#confirm-param').val()
	datastr += "&name=" + encodeURIComponent(filename);
	ajax_call(datastr, ajax_delete_errorlog, null);
}

function ajax_delete_errorlog(x, jqXHR, textStatus, params)
{
	var list = "";
	var firstfile = "";
	if(x != null) {
		if(x.status == 'ok') {
			var files = x.data;
			for(var i = (x.data.length-1); i >= 0; i--) {
				var file = x.data[i];
				var id = file;
				list += "<li id=\"li-el-" + id + "\" class=\"list-group-item list-group-flush ui-selectee\">" + file + "</li>";
				if(firstfile == "")
					firstfile = file;
			}
		}
	}
	if(firstfile != "")
		logfile_selected(firstfile);
	$('#errorlog-files').html(list);
}

function logfile_selected(liid)
{
	var filename = liid.replace("li-el-", "");
	current_error_log_file = filename;
	$('#el_filename').html(filename);
	var datastr = get_ajax_datastr("admin", "log", "get");
	datastr += "&name=" + encodeURIComponent(filename);
	ajax_call(datastr, ajax_get_errorlog, false);
}


function ajax_get_errorlog(x, jqXHR, textStatus, params)
{
	var list = "";
	if(x != null) {
		if(x.status == 'ok') {
			var rows = 0;
			var errorlog = x.data;
			var errors = errorlog.split("\n");
			for(var i = (errors.length-1); i >=0; i--) {
				var msg = errors[i];
				list += "<li class=\"list-group-item list-group-flush\">" + msg + "</li>";
				rows++;
				if(rows > 500)
					break;
			}
		}
	}
	$('#errorlog-data').html(list);
	// Fix for IE 11
	$('#errorlog-data').css('font-size', getCookieInt("table-font-size", DEFAULT_TABLE_FONT_SIZE)+1);
	$('#errorlog-data').css('display', 'inline-block');
}