function init_emailsetup()
{
	$('#emailsetup-save').off('click');
	$('#emailsetup-save').click(function(event){
		event.preventDefault();
		emailsetup_save();
	});
	
	$('#emailsetup-test').off('click');
	$('#emailsetup-test').click(function(event){
		event.preventDefault();
		emailsetup_test();
	});
	
	$('#email_send_method').off('change');
	$('#email_send_method').change(function(event){
		event.preventDefault();
		emailsetup_change();
	});
	
	$('#dnsalerts-update').off('click');
	$('#dnsalerts-update').click(function(event){
		event.preventDefault();
		dnsalerts_update();
	});
	
	get_email_settings();
}

/////////////////////////////////////////////////////////////////////////////////////////

function init_dnsalerts()
{
	var datastr = get_ajax_datastr("admin", "dnsalert", "get");
	ajax_call(datastr, ajax_dnsalert_get, null);
}

/////////////////////////////////////////////////////////////////////////////////////////

function ajax_dnsalert_get(x, jqXHR, textStatus, params)
{
	if(x != null) {
		if(x.status == 'ok') {

			var records = ['cname', 'a', 'mx', 'ns', 'txt'];
			if(x.dns_monitor_records != "")
				records = x.dns_monitor_records.split(",");
			$('#dns_monitor_records').multipleSelect('setSelects', records);

			$('#dns_monitor_enabled').val(x.dns_monitor_enabled ? "1" : "0");
			$('#email_dns_alerts').val(x.email_dns_alerts ? "1" : "0");
			$('#dnsbl_checks_enabled').val(x.dnsbl_checks_enabled ? "1" : "0");
			$('#dns_alert_recipients').val(x.dns_alert_recipients);
			$('#global_nameserver_ip').val(x.global_nameserver_ip);
			if(x.php_net_dns2 == "1") 
				$('#php_net_dns2').hide();
			else
				$('#php_net_dns2').show();

			$("#alert-frequency-value").html(x.email_alerts_delay);
			$("#alert-frequency-slider").slider('option', 'value', x.email_alerts_delay);
			$('#email_ping_alerts').val(x.email_ping_alerts);
			$('#email_http_alerts').val(x.email_http_alerts);
			//$('#alert_new_dns_entries').val(x.alert_new_dns_entries ? "1" : "0");
		}
	}
}

/////////////////////////////////////////////////////////////////////////////////////////

function get_selected_dns_alerts()
{
	var selected = $('#dns_monitor_records').multipleSelect('getSelects');
	var rights = []
	for(var i = 0; i < selected.length; i++) {
		var s = selected[i];
		rights.push(s);
	}
	return rights.join(",");
}

/////////////////////////////////////////////////////////////////////////////////////////

function dnsalerts_update()
{
	var datastr = get_ajax_datastr("admin", "dnsalert", "set");
	datastr += "&dns_monitor_enabled=" + encodeURIComponent($('#dns_monitor_enabled').val());
	datastr += "&email_dns_alerts=" + encodeURIComponent($('#email_dns_alerts').val());
	datastr += "&dnsbl_checks_enabled=" + encodeURIComponent($('#dnsbl_checks_enabled').val());
	datastr += "&dns_alert_recipients=" + encodeURIComponent($('#dns_alert_recipients').val());
	datastr += "&global_nameserver_ip=" + encodeURIComponent($('#global_nameserver_ip').val());
	datastr += "&dns_monitor_records=" + encodeURIComponent(get_selected_dns_alerts());
	datastr += "&email_alerts_delay=" + encodeURIComponent($("#alert-frequency-slider").slider('option', 'value'));
	datastr += "&email_ping_alerts=" + encodeURIComponent($('#email_ping_alerts').val());
	datastr += "&email_http_alerts=" + encodeURIComponent($('#email_http_alerts').val());
	//datastr += "&alert_new_dns_entries=" + encodeURIComponent($('#alert_new_dns_entries').val());
	$('#dnsmon-error').html("<img src=\"\lib/layouts/images/loaders/ajax-loader.gif\" class=\"mx-auto\">&nbsp;");
	ajax_call(datastr, ajax_dnsalert_set, null);
}

/////////////////////////////////////////////////////////////////////////////////////////

function ajax_dnsalert_set(x, jqXHR, textStatus, params)
{
	if(x != null) {
		if(x.status == 'ok') {
		}
		$('#dnsmon-error').html('');
	}
}

/////////////////////////////////////////////////////////////////////////////////////////

function ajax_emailsetup_get(x, jqXHR, textStatus, params)
{
	if(x != null) {
		if(x.status == 'ok') {
			for (var key in x.data) {
				if (key === 'length' || !x.data.hasOwnProperty(key)) continue;
				var value = x.data[key];
				if(value == "" && key == "email_send_method")
					value = "default";
				$('#' + key).val(value);
			}
		}
	}
	emailsetup_change();
}

/////////////////////////////////////////////////////////////////////////////////////////

function get_email_settings()
{
	$('#emailsetup-error').html('');
	var datastr = get_ajax_datastr("admin", "email", "get");
	ajax_call(datastr, ajax_emailsetup_get, null);
}

/////////////////////////////////////////////////////////////////////////////////////////

function emailsetup_change()
{
	var method = $('#email_send_method').val();
	if(method == "smtp")
		$('#smtpsetup').show();
	else
		$('#smtpsetup').hide();
}

/////////////////////////////////////////////////////////////////////////////////////////

function emailsetup_save()
{
	$('#emailsetup-error').html('');
	var emdata = $('#emailsetup-form').serialize();
	//var datastr = "c=admin&t=email&oper=set";
	var datastr = get_ajax_datastr("admin", "email", "set");
	datastr += "&" + emdata;
	ajax_call(datastr, ajax_emailsetup_save, null);
}

/////////////////////////////////////////////////////////////////////////////////////////

function ajax_emailsetup_save(x, jqXHR, textStatus, params)
{
	if(x != null) {
		if(x.status == 'ok') {
			$('#emailsetup-error').html('done');
		}
		else
			$('#emailsetup-error').html(x.error);
	}
}

/////////////////////////////////////////////////////////////////////////////////////////

function emailsetup_test()
{
	$('#emailsetup-error').html('please wait!');
	var testemail = $('#test_email_address').val();
	if(testemail == "")
		$('#emailsetup-error').html("Please provide an email address");
	else {
		var datastr = get_ajax_datastr("admin", "email", "test");
		datastr += "&email=" + encodeURIComponent(testemail);
		ajax_call(datastr, ajax_emailsetup_save, null);
	}
}

/////////////////////////////////////////////////////////////////////////////////////////
