/////////////////////////////////////////////////////////////////////////////////////////

function initDomainFields()
{
	$('#df-error').html('');
	$('#df-field').val('');
	$('#df-selected-field').html("None Selected");
	$('#df-label').val('');
	$('#df-width').val('');
	$('#df-level').val(0);

	var datastr = get_ajax_datastr("list", "domain", "columns");
	ajax_call(datastr, ajax_get_comain_colunns, null);
	make_list_selectable('domainfields', "domain_field_selected");
	
	$('#df-update').off('click');
	$('#df-update').click(function(event){
		event.preventDefault();
		domainfield_update();
	});
}

/////////////////////////////////////////////////////////////////////////////////////////

function domainfield_update()
{
	var name = $('#df-field').val();
	var label = $('#df-label').val();
	var width = $('#df-width').val();
	var acslevel = parseInt($('#df-level').val());
	if((name == "sid" || name == 'r_h_disp') && acslevel > 0) {
		$('#df-level').val('0')
		$('#df-error').html('Error: All users should have access to the "' + name + '" column (access level should be 0)');
	}
	else {
		if(name != "") {
			$('#df-error').html('please wait');
			var datastr = get_ajax_datastr("admin", "domain", "set");
			datastr += "&name=" + encodeURIComponent(name);
			datastr += "&label=" + encodeURIComponent(label) + "&width=" + encodeURIComponent(width);
			datastr += "&acslevel=" + encodeURIComponent(acslevel);
			ajax_call(datastr, ajax_domainfield_update, null);
		}
	}
}

/////////////////////////////////////////////////////////////////////////////////////////

function ajax_domainfield_update(x, jqXHR, textStatus, params)
{
	if(x != null) {
		if(x.status == 'ok') {
			$('#df-error').html('ok');
		}
		else
			$('#df-error').html(x.error);
	}
}

/////////////////////////////////////////////////////////////////////////////////////////

function domain_field_selected(liid)
{
	var key = liid.replace("li-df-", "");
	$('#df-selected-field').html(key);
	$('#df-field').val(key);
	
	var datastr = get_ajax_datastr("admin", "domain", "get");
	datastr += "&name=" + encodeURIComponent(key);
	ajax_call(datastr, ajax_domainfield_selected, key);
}

/////////////////////////////////////////////////////////////////////////////////////////

function ajax_domainfield_selected(x, jqXHR, textStatus, params)
{
	if(x != null) {
		$('#df-error').html('');
		if(x.status == 'ok') {
			var label = decodeURIComponent(x.data['label']);
			var width = decodeURIComponent(x.data['width']);
			var acslevel = decodeURIComponent(x.data['acslevel']);
			$('#df-label').val(label);
			$('#df-width').val(width);
			$('#df-level').val(acslevel);
		}
	}
}

/////////////////////////////////////////////////////////////////////////////////////////

function get_domain_column_list(columns)
{
	var customlist = "";
	var defaultlist = "";
	for (var key in columns) {
		if (key === 'length' || !columns.hasOwnProperty(key)) continue;
		var label = columns[key]['label'];
		var ftype = columns[key]['fieldtype'];
		var gridview = parseInt(columns[key]['gridview']);
		var editable = parseInt(columns[key]['editable']);
		var custom = parseInt(columns[key]['custom']);
		if(!custom) {
			defaultlist += '<li id="li-df-' + key + '" class="list-group-item ui-selectee defaultcolumn df-' + ftype + '">' + key + '</li>'; 
		}
		else {
			customlist += '<li id="li-df-' + key + '" class="list-group-item ui-selectee df-' + ftype + '">' + key + '</li>'; 
		}
	}
	return customlist + defaultlist;
}

/////////////////////////////////////////////////////////////////////////////////////////

function ajax_get_comain_colunns(x, jqXHR, textStatus, params)
{
	if(x != null) {
		if(x.status == 'ok') {
			var list = get_domain_column_list(x.columns);
			$('#domainfields').html(list);
		}
	}
}
