function cli_reset()
{
	$('#confirm-message').html("<h4>Are you sure you want to reset the CLI Key?</h4><p>Your will have to make changes to your web based cron setup.</p>");
	$('#confirm-caller').val("confirm_resetcli");
	showPanel("panel-confirm");
}

function confirm_resetcli()
{
	var datastr = get_ajax_datastr("admin", "auth", "resetcli");
	ajax_call(datastr, ajax_resetcli_done, null);
}

function ajax_resetcli_done(x, jqXHR, textStatus, params)
{
	if(x != null) {
		if(x.status == 'ok') {
			$('#cli-key').html(x.data);
		}
		else
			$('#cli-key').html(x.error);
	}
}

function authentication_save()
{
	var authmode = $('#auth_mode').val();
	var cookiedays = $('#twofa_cookie_set_days').val();
	var datastr = get_ajax_datastr("admin", "auth", "set2fa");
	datastr += "&mode=" + encodeURIComponent(authmode);
	datastr += "&cookie=" + encodeURIComponent(cookiedays);
	
	var ids = $('.sa-mode-key').map(function() {
		var id = $(this).attr('id');
		var val = $(this).val();
		return "&" + id.replace("sa-", "") + "=" + encodeURIComponent(val);
	});
	datastr += ids.toArray().join("");
	ajax_call(datastr, ajax_setauth_done, null);
}

function ajax_setauth_done(x, jqXHR, textStatus, params)
{
	if(x != null) {
		if(x.status == 'ok') {
			$('#authentication-status').html('ok');
		}
		else
			$('#authentication-status').html(x.error);
	}
}

function auth_mode_changed()
{
	var authmode = $('#auth_mode').val();
	var datastr = get_ajax_datastr("admin", "auth", "get2fa");
	datastr += "&mode=" + encodeURIComponent(authmode);
	ajax_call(datastr, ajax_getauthkeys_done, null);
}

function initAuthModeKeys(mode, authinfo, keyvalues, enabled, devicecookie)
{
	var form = '<form autocomplete="off" method="post" action="">';
	form += '<input autocomplete="false" name="hidden" type="password" style="display:none;">';
	var keys = $.map(authinfo, function(element,index) {return index});
	var l = keys.length;
	for(var i = 0; i < l; i++) {
		if(keys[i] != "") {
			var kid = "sa-" + mode.toLowerCase() + "_key_" + replaceAll(keys[i].trim().toLowerCase(), " ", "_");
			form += "<p class=\"small mb-1\"><b>" + keys[i] + "</b>: " + authinfo[keys[i]] + "</p>";
			form += "<input type=\"password\" autocomplete=\"new-password\" class=\"form-control mb-3 sa-mode-key\" id=\"" + kid + "\" name=\"" + kid + "\" value=\"" + keyvalues[i] + "\" placeholder=\"" + keys[i] + "\">";
		}
	}
	if(enabled == false && mode != "default") {
		form += "<p class=\"small\"><code>" + mode + " is currently not available for actual use (probably in beta / test mode)</code></p>";
	}
	form += '</form>';
	$('#auth_setup').html(form);
	if(devicecookie)
		$('#twofa_device_cookie').show();
	else
		$('#twofa_device_cookie').hide();
}

function init_authentication()
{
	var datastr = get_ajax_datastr("admin", "auth", "get2fa");
	ajax_call(datastr, ajax_getauth_done, null);
	
	// On Auth Mode Change
	
	$('#auth_mode').off('change');
	$('#auth_mode').change(function(event) {
		auth_mode_changed();
	});
}

function ajax_getauthkeys_done(x, jqXHR, textStatus, params)
{
	if(x != null) {
		if(x.status == 'ok') {
			initAuthModeKeys(x.mode, x.keys, x.keyvals, x.enabled, x.devcookie);
			$('#twofa_cookie_set_days').val(x.cookie);
		}
	}
}

function ajax_getauth_done(x, jqXHR, textStatus, params)
{
	if(x != null) {
		if(x.status == 'ok') {
			$('#auth_mode').val(x.mode);
			initAuthModeKeys(x.mode, x.keys, x.keyvals, x.enabled, x.devcookie);
			$('#twofa_cookie_set_days').val(x.cookie);
		}
	}
}
