/////////////////////////////////////////////////////////////////////////////////////////

var sch_report_list = [];

/////////////////////////////////////////////////////////////////////////////////////////

function init_adminreports()
{
	var datastr = get_ajax_datastr("admin", "report", "list");
	ajax_call(datastr, ajax_adminreports_list, null);
	
	datastr = get_ajax_datastr("list", "report", "columns");
	datastr += "&details=0";
	ajax_call(datastr, ajax_adminreports_columnlist, null);
	
	$('#adminreport-runits').off('change');
	$('#adminreport-runits').change(function(event){
		event.preventDefault();
		reports_unit_change();
	});
	
	$('#adminreport-name').off('input');
	$('#adminreport-name').on('input',function(e) {
		report_name_changed();
	});
	$('#adminreport-name').off('change');
	$('#adminreport-name').change(function(event) {
		report_name_changed();
	});
	report_name_changed();
	
	$('#adminreport-add').off('click');
	$('#adminreport-add').click(function(event){
		event.preventDefault();
		add_new_adminreport();
	});
	
	$('#adminreport-update').off('click');
	$('#adminreport-update').click(function(event){
		event.preventDefault();
		update_adminreport();
	});
	
	$('#adminreport-delete').off('click');
	$('#adminreport-delete').click(function(event){
		event.preventDefault();
		delete_adminreport();
	});
	
	$('#adminreport-reset').off('click');
	$('#adminreport-reset').click(function(event){
		event.preventDefault();
		reset_adminreport();
	});
}

/////////////////////////////////////////////////////////////////////////////////////////

function report_name_changed()
{
	if(sch_report_list.length == 0) {
		$('#adminreport-add').show();
		$('#adminreport-delete').hide();
		$('#adminreport-update').hide();
	}
	else {
		var name = $('#adminreport-name').val();
		var lidx = sch_report_list.indexOf(name.toLowerCase());
		if(lidx >= 0) {
			// The typed in name matches an entry in the list, select it the list.
			$('#adminreport-add').hide();
			$('#adminreport-list li').each(function() {
				$(this).removeClass('ui-state-highlight');
				$(this).removeClass('ui-selected');
			});
			$("#adminreport-list li:nth-child(" + (lidx+1) + ")").addClass('ui-selected ui-state-highlight');
			var liid = $("#adminreport-list li:nth-child(" + (lidx+1) + ")").attr('id');
			adminreport_selected(liid);
		}
		else {
			if(name != "")
				$('#adminreport-add').show();
			else
				$('#adminreport-add').hide();
			$('#adminreport-delete').hide();
			$('#adminreport-update').hide();
			$('#adminreport-email').val('0');
		}
	}
}

/////////////////////////////////////////////////////////////////////////////////////////

function reports_unit_change()
{
	var runits = $('#adminreport-runits').val();
	if(runits == "2") {
		$('#adminreport-date').prop('disabled', true);
		$('#adminreport-week').prop('disabled', true);
	}
	else if(runits == "3") {
		$('#adminreport-week').prop('disabled', false);
		$('#adminreport-date').prop('disabled', true);
	}
	else if(runits == "4") {
		$('#adminreport-week').prop('disabled', true);
		$('#adminreport-date').prop('disabled', false);
	}
}

/////////////////////////////////////////////////////////////////////////////////////////

function ajax_adminreports_columnlist(x, jqXHR, textStatus, params)
{
	if(x != null) {
		if(x.status == 'ok') {
			var count = x.columns.length;
			var select = "";
			for(var i = 0; i < count; i++) {
				if(x.columns[i] != "d.days_to_expiry")
					select += "<option value=\"" + x.columns[i] + "\">" + x.columns[i] + "</option>";
			}
			$('#adminreport-sortcolumn').html(select);
		}
	}
}

/////////////////////////////////////////////////////////////////////////////////////////

function ajax_adminreports_list(x, jqXHR, textStatus, params)
{
	if(x != null) {
		sch_report_list = [];
		var lidata = "";
		if(x.status == 'ok') {
			var schlist = x.schedules;
			for(var i = 0; i < schlist.length; i++) {
				var id = schlist[i].id;
				var name = schlist[i].name;
				sch_report_list.push(name.toLowerCase());
				lidata += "<li class=\"list-group-item ui-selectee\" id=\"li-repnames-" + id + "\">" + name + "</li>\n";
			}
		}
		$('#adminreport-list').html(lidata);
		make_list_selectable('adminreport-list', "adminreport_selected");
		
		if($(window).width() > 412) {
			$('#adminreport-list').css('max-height', 450);
			$('#adminreport-list').css('min-height', 320);
		}
		
		if(params == "refresh")
			report_name_changed();
	}
}


function adminreport_selected(liid)
{
	var selected_id = liid.replace("li-repnames-", "");
	var datastr = get_ajax_datastr("admin", "report", "get");
	datastr += "&id=" + selected_id;
	ajax_call(datastr, ajax_adminreport_info, null);
	
	//datastr = get_ajax_datastr("get", "report", "preview");
	//datastr += "&id=" + selected_id;
	//ajax_call(datastr, ajax_adminreport_preview, null);
}


function ajax_adminreport_preview(x, jqXHR, textStatus, params)
{
	if(x != null) {
		if(x.status == 'ok') {
			var report = x.report;
			var iframe = document.getElementById('adminreport-preview');
			iframe = iframe.contentWindow || ( iframe.contentDocument.document || iframe.contentDocument);

			iframe.document.open();
			iframe.document.write(report);
			iframe.document.close();
		}
	}
}


function ajax_adminreport_info(x, jqXHR, textStatus, params)
{
	if(x != null) {
		if(x.status == 'ok') {
			x.runits = parseInt(x.runits)
			var runits = x.runits & 0xF;
			var hour = (x.runits >> 4) & 0xFF;
			var date = (x.runits >> 12) & 0xFF;
			var week = (x.runits >> 20) & 0xF;
			if(runits < 2 || runits > 4)
				runits = 3;
			if(hour < 1 || hour > 24)
				hour = 1;
			if(date < 1 || date > 28)
				date = 1;
			if(week < 1 || week > 7)
				week = 1;
			
			if(x.frequency <= 0)
				x.frequency = 1;
			$('#adminreport-runits').val(runits);
			$('#adminreport-frequency').val(parseInt(x.frequency));
			$('#adminreport-name').val(x.name);
			$('#adminreport-email').val(x.autorun);
			$('#adminreport-emailto').val(x.emails);
			$('#adminreport-week').val(week);
			$('#adminreport-date').val(date);
			$('#adminreport-hour').val(hour);
			$('#adminreport-params').val(x.params);
			$('#adminreport-query').val(x.query);
			$('#adminreport-sortcolumn').val(x.sortcolumn);
			
			if(x.descending == true)
				$('#adminreport-sortorder').val('desc');
			else
				$('#adminreport-sortorder').val('asc');
			
			$('#adminreport-add').hide();
			$('#adminreport-delete').show();
			$('#adminreport-update').show();
		}
		
		reports_unit_change();
	}
}

/////////////////////////////////////////////////////////////////////////////////////////

function get_runits()
{
	var runits = $('#adminreport-runits').val();
	var week = $('#adminreport-week').val();
	var date = $('#adminreport-date').val();
	var hour = $('#adminreport-hour').val();
	
	var combined = (parseInt(week) << 20) | (parseInt(date) << 12) | (parseInt(hour) << 4) | (parseInt(runits) & 0xF);
	return combined;
}

/////////////////////////////////////////////////////////////////////////////////////////

function get_adminreport_data(oper)
{
	var name = $('#adminreport-name').val();
	var frequency = $('#adminreport-frequency').val();
	if(frequency == "")
		frequency = "30";
	var combined = get_runits();
	var enabled = $('#adminreport-email').val();
	var emails = $('#adminreport-emailto').val();
	var sortcolumn = $('#adminreport-sortcolumn').val();
	var sord = $('#adminreport-sortorder').val();
	var query = $('#adminreport-query').val();
	query = replaceAll(query, "<", " LT ");
	query = replaceAll(query, "<=", " LE ");
	query = replaceAll(query, ">", " GT ");
	query = replaceAll(query, ">=", " GE ");
	var params = $('#adminreport-params').val();
	var datastr = "";
	var foundInList = sch_report_list.indexOf(name.toLowerCase()) >= 0;
	var doIt = (oper == "add") ? !foundInList : foundInList;
	if(name != "" && doIt) {
		datastr = get_ajax_datastr("admin", "report", oper);
		datastr += "&name=" + encodeURIComponent(name);
		datastr += "&frequency=" + encodeURIComponent(frequency);
		datastr += "&runits=" + encodeURIComponent(combined);
		datastr += "&autorun=" + encodeURIComponent(enabled);
		datastr += "&emails=" + encodeURIComponent(emails);
		datastr += "&query=" + encodeURIComponent(query);
		datastr += "&params=" + encodeURIComponent(params);
		datastr += "&sortcolumn=" + encodeURIComponent(sortcolumn);
		if(sord == "desc")
			datastr += "&descending=1";
		else
			datastr += "&descending=0";
	}
	return datastr;
}

/////////////////////////////////////////////////////////////////////////////////////////

function reset_adminreport()
{
	var datastr = get_ajax_datastr("admin", "report", "reset");
	ajax_call(datastr, ajax_update_adminreport, "new");
}

/////////////////////////////////////////////////////////////////////////////////////////

function delete_adminreport()
{
	var datastr = get_adminreport_data("del");
	ajax_call(datastr, ajax_update_adminreport, "new");
}

/////////////////////////////////////////////////////////////////////////////////////////

function update_adminreport()
{
	var datastr = get_adminreport_data("set");
	ajax_call(datastr, ajax_update_adminreport, null);
}

/////////////////////////////////////////////////////////////////////////////////////////

function add_new_adminreport()
{
	var datastr = get_adminreport_data("add");
	ajax_call(datastr, ajax_update_adminreport, "new");
}

/////////////////////////////////////////////////////////////////////////////////////////

function ajax_update_adminreport(x, jqXHR, textStatus, params)
{
	if(x != null) {
		if(x.status == 'ok') {
			if(params == "new") {
				datastr = get_ajax_datastr("admin", "report", "list");
				ajax_call(datastr, ajax_adminreports_list, "refresh");
			}
		}
	}
}