# How To Contribute

## About Rights

The Datejs project is [licensed](https://github.com/datejs/Datejs/blob/master/LICENSE) as [Apache v2.0 License](http://www.apache.org/licenses/LICENSE-2.0). If you provide any code to us and your code is added to Datejs, the code you provide will automatically inherit the same Apache License, Version 2.0.

Your contribution will be subject to license’s Clause #5.

> **5. Submission of Contributions.** Unless You explicitly state otherwise, any Contribution intentionally submitted for inclusion in the Work by You to the Licensor shall be under the terms and conditions of this License, without any additional terms or conditions. Notwithstanding the above, nothing herein shall supersede or modify the terms of any separate license agreement you may have executed with Licensor regarding such Contributions.

## Getting Started

1. Make sure you have a GitHub account
2. **IMPORTANT:** Start an [Issue](https://github.com/datejs/Datejs/issues):
 - Start the conversation regarding this defect or feature
 - Please provide a simplified code sample demonstrating how to reproduce the feature or issue
 - Clearly describe the issue, including steps to reproduce when it is a bug
3. Fork the repository on GitHub

## Forking

You can fork our project from GitHub, develop/merge your feature or bugfix, then submit a Pull Request. Please keep in mind that:

1. Pull requests are actual commits with your modified code
2. One pull request must contain all commits related to that feature or bug fix (full changeset)

## Submitting Changes

1. **IMPORTANT:** Please read the [Contributor License Agreement](https://github.com/datejs/Datejs/blob/master/CLA.md)
2. **IMPORTANT:** Complete the [Contributor License Agreement Form](http://goo.gl/forms/2NxnVYI3tK)
3. Push your changes to a branch in your fork of the repository
4. Submit a Pull Request
5. Reference your Issue number in your Pull Request comments

Your Pull Request will be reviewed. We will analyze your change and if it fits the coding standards and feature demand, we’ll add it to the main project.

## My Feature Is Awesome! Why don't you add it now?

Some features or fixes might be brilliant additions, but break backwards compatibility. We may consider a change ineligible for immediate merging if it turns the project too far away from our current release plan.

Not to worry, we will try our best to add your contribution into our next release!

## Bug Or Feature?

If we still have a bug lurking around we will do our best to fix it promptly.

Bug fixes are much more likely to be accepted in a short term than entirely new features that might compromise other parts of Datejs or developer experience.

## Will I Get Paid For Bugs Or Features?

Your reward is sweet karma and that warm fuzzy feeling knowing you’ve helped the open source Datejs community.

## Additional Resources

1. [Contributor License Agreement](https://github.com/datejs/Datejs/blob/master/CLA.md)
2. [Issue tracker](https://github.com/datejs/Datejs/issues)
3. [Datejs Blog](https://datejs.comblog/)
5. [StackOverflow](https://stackoverflow.com/questions/tagged/datejs)
