<?php 
###############################################################################
# verify.php
# Watch My Domains SED v3
# (c) Softnik Technologies. All rights reserved.
###############################################################################
# Should work even if config.php is missing
###############################################################################

require_once("lib/php/install.php");					# Install Stuff
require_once("lib/php/basic.php");						# Base Functions.
require_once("lib/php/ui/ui.php");						# Basic UI stuff.
require_once("lib/php/tests.php");						# Installation Checks.	

#########################################################################################################
# Parse command line if running in CLI

if(is_cli())
	parse_str(implode('&', array_slice($argv, 1)), $_REQUEST);			

###############################################################################

$results = array();
get_folder_status($results);
if(file_exists(realpath(dirname(__FILE__) . DIRECTORY_SEPARATOR . "config.php")))
{
	require_once(get_php_folder_path() . "lang/".get_lang_code().".php");
	require_once(get_php_folder_path() . "pdo/dbinit.php");
	require_once("config.php");
	# Authenticate if in browser and able to load configuration.
	if((isIonCubeAvailable() || isProConfigFile()) && !is_cli())
		doAuthentication("verify.php");
	do_db_checks($results);
}
else
	require_once("lib/php/config.check.php");

###############################################################################

do_wmdsed_tests($results);
show_message(formatTestResults($results));

###############################################################################
?>
