<?php
###############################################################################
# TPPWholesale API.
#
# Please open config-tppw.php in any text editor and add your authentication 
# details.
#
###############################################################################

function getTPPWErrorMessage($tppwdata)
{
	$pos = stripos($tppwdata, "ERR:");
	if($pos !== false)
	{
		$errcode = trim(substr($tppwdata, $pos+4));
		$error = "-";
		if($errcode == "102")
			$error = "Cannot authenticate user. AccountNO/UserID/Password does not match.";
		else if($errcode == "105")
			$error = "IP lockdown. API request is coming from an IP other than the IPs specified in API settings.";
		else if($errcode == "100")
			$error = "Missing parameters";
		else if($errcode == "302")
			$error = "Domain not supplied";
		else if($errcode == "307")
			$error = "Incorrect Domain Password";
		else if($errcode == "308")
			$error = "Domain UserID or Password not supplied";
		else if($errcode == "309")
			$error = "Invalid Domain Extension";
		else if($errcode == "310")
			$error = "Domain does not exist, has been deleted or transferred away";
		else if($errcode == "311")
			$error = "Domain does not exist in your reseller profile";
		else if($errcode == "312")
			$error = "Supplied UserID and Password do not match the domain";
		else if($errcode == "401")
			$error = "Connection to Registry failed - retry";
		return $error;
	}
}

###############################################################################

function initTPPWSession(&$error)
{
	$error = "";
	global $tppw_account_no, $tppw_userid, $tppw_password;
	$authurl = "https://theconsole.tppwholesale.com.au/api/auth.pl?AccountNo={$tppw_account_no}&UserId={$tppw_userid}&Password={$tppw_password}";
	$tppwdata = file_get_contents($authurl);
	$pos = stripos($tppwdata, "OK:");
	if($pos !== false)
		return trim(substr($tppwdata, $pos+3));
	$error = getTPPWErrorMessage($tppwdata);
	return false;
}

###############################################################################

function getTPPWDomainList($sessionid, $tld, &$error)
{
	$error = "";
	$url = "https://theconsole.tppwholesale.com.au/api/query.pl?SessionID={$sessionid}&Type=Domains&Object=Domain&Action=List&Tld=" . urlencode($tld);
	$tppwdata = file_get_contents($url);
	$pos = stripos($tppwdata, "OK:");
	if($pos !== false)
		return trim(substr($tppwdata, $pos+3));
	$error = getTPPWErrorMessage($tppwdata);
	return false;
}

###############################################################################

function getTPPWDomainInfo($sessionid, $domainname, &$error)
{
	$error = "";
	$url = "https://theconsole.tppwholesale.com.au/api/query.pl?SessionID={$sessionid}&Type=Domains&Object=Domain&Action=Details&Domain=" . urlencode($domainname);
	$tppwdata = file_get_contents($url);
	$pos = stripos($tppwdata, "OK:");
	if($pos !== false)
		return trim(substr($tppwdata, $pos+3));
	$error = getTPPWErrorMessage($tppwdata);
	return false;
}

###############################################################################

function getTPPWDataForDomains($domains, &$error)
{
	$domaininfo = array();
	$sessionid = initTPPWSession($error);
	if($sessionid === false)
		return false;
	else
	{
		foreach($domains as $domain)
		{
			$status = getTPPWDomainInfo($sessionid, $domain, $error);
			if($status !== false)
				$domaininfo[$domain] = $status;
			else
				$domaininfo[$domain] = "Error: $error";
		}
	}
	return $domaininfo;
}

###############################################################################

?>
