<?php
###############################################################################
# Proxy whois script for TPPW
#
# Please specify the TPPW account details in thirdparty/config.php
#
###############################################################################

header('Content-Type: text/plain');

###############################################################################

require_once(dirname(__FILE__) . "/../include.php");
require_once(dirname(__FILE__) . "/config.check.php");
require_once(dirname(__FILE__) . "/tppwapi.php");

###############################################################################
# Parse command line if running in CLI

if(is_cli())
	parse_str(implode('&', array_slice($argv, 1)), $_REQUEST);

###############################################################################

loginIfRequired();

###############################################################################

if(isset($_REQUEST['domain']))
{
	$domain = filter_var($_REQUEST['domain'], FILTER_SANITIZE_STRING);
	$ddata = getTPPWDataForDomains(array($domain), $error);
	if($ddata === false)
		echo $error;
	else
	{
		$ddata[$domain] = str_replace("=", ":", $ddata[$domain]);
		echo $ddata[$domain];
	}
}

###############################################################################

?>
