<?php

###############################################################################
# whoapi.php
#
# @author Anil Kumar <akumar@codepunch.com>
# @link   https://codepunch.com
#
# A Simple Whois Client that uses Registrar APIs where available.
#
############################################################################### 

use CodePunch\Base\Util as UTIL;

###############################################################################

require_once('dynadot.php');
require_once('godaddy.php');
require_once('resellerclub.php');
require_once('domainersde.php');
require_once('namecheap.php');
require_once('internetbs.php');
require_once('whois.php');

###############################################################################

function api_whois_authenticate()
{
	global $api_whois_access_key;
	if($api_whois_access_key != "") {
		$key = UTIL::get_request_string("k");
		if($key != $api_whois_access_key) {
			header('HTTP/1.0 403 Forbidden');
			echo 'Access denied!';
			exit;
		}
	}
}

###############################################################################

function get_registrar_instance($server)
{
	global $gd_api_access_key, $gd_api_secret_key;
	global $dn_api_access_key;
	global $rsclub_api_access_key, $rsclub_customer_id;
	global $domainersde_user, $domainersde_password;
	global $internetbs_api_key, $internetbs_password;
	global $namecheap_api_user, $namecheap_api_key, $namecheap_user_name;
	
	$whoapi = null;
	if($server != "") {
		if(strcasecmp(CodePunch\Whois\Dynadot::$whois_server, $server) == 0 || stristr($server, "dynadot") !== false)
		{
			if($dn_api_access_key != "DynadotAPIAccessKey" && $dn_api_access_key != "")
				$whoapi = new CodePunch\Whois\Dynadot($dn_api_access_key);
		}
		else if(strcasecmp(CodePunch\Whois\GoDaddy::$whois_server, $server) == 0 || stristr($server, "godaddy") !== false)
		{
			if($gd_api_access_key != "GoDaddyAPIAccessKey" && $gd_api_access_key != "" && $gd_api_secret_key != "GoDaddyAPISecretKey" && $gd_api_secret_key != "")
				$whoapi = new CodePunch\Whois\GoDaddy($gd_api_access_key, $gd_api_secret_key);
		}
		else if(strcasecmp(CodePunch\Whois\ResellerClub::$whois_server, $server) == 0 || stristr($server, "resellerclub") !== false)
		{
			if( $rsclub_api_access_key != "ResellerClubAPIAccessKey" &&  $rsclub_api_access_key != "" &&  $rsclub_customer_id != "ResellerClubCustomerID" &&  $rsclub_customer_id != "")
				$whoapi = new CodePunch\Whois\ResellerClub($rsclub_api_access_key, $rsclub_customer_id);
		}
		else if(stristr($server, "DomainersDE") !== false)
		{
			if( $domainersde_password != "DomainersDePassword" &&  $domainersde_password != "" &&  $domainersde_user != "DomainersDeLogin" &&  $domainersde_user != "")
				$whoapi = new CodePunch\Whois\DomainersDE($domainersde_user, $domainersde_password);
		}
		else if(stristr($server, "NameCheap") !== false)
		{
			if( $namecheap_api_user != "NameCheapAPIUser" &&  $namecheap_api_user != "" &&  $namecheap_api_key != "NameCheapAPIKey" &&  $namecheap_api_key != "")
				$whoapi = new CodePunch\Whois\NameCheap($namecheap_api_user, $namecheap_api_key, $namecheap_user_name);
		}
		else if(stristr($server, "InternetBS") !== false)
		{
			if( $internetbs_api_key != "InternetBSAPIKey" &&  $internetbs_api_key != "" &&  $internetbs_password != "InternetBSPassword" &&  $internetbs_password != "")
				$whoapi = new CodePunch\Whois\InternetBS($internetbs_api_key, $internetbs_password);
		}
	}
	return $whoapi;
}

###############################################################################

function api_whois($domain, $server, $sndbox=false)
{
	if($server == "" && $domain != "")
		$server = CodePunch\Whois\Whois::find_whois_server($domain);

	$whoapi = get_registrar_instance($server);
	$ascii = CodePunch\Whois\Whois::idn_convert($domain);
	
	if($whoapi) {
		$sbstat = $whoapi->use_sandbox($sndbox);
		if($sbstat === false && $sndbox === true)
			throw new Exception("Sandbox not supported ({$server})");
		$whois = $whoapi->whois($ascii, true);
	}
	else 
		$whois = UTIL::whois($ascii, $server, 43, 5);
	$whois = trim($whois);
	return $whois . "\n\n---\nWhois API Client (c) CodePunch Solutions: https://codepunch.com\n";
}

###############################################################################

function get_supported_servers()
{
	return array(
	CodePunch\Whois\Dynadot::$whois_server,
	CodePunch\Whois\GoDaddy::$whois_server,
	CodePunch\Whois\ResellerClub::$whois_server
	);
}

###############################################################################

function get_domain_list($server, $sndbox=false)
{
	$whoapi = $whoapi = get_registrar_instance($server);
	if($whoapi) {
		$sbstat = $whoapi->use_sandbox($sndbox);
		if($sbstat === false && $sndbox === true)
			throw new Exception("Sandbox not supported ({$server})");
		return $whoapi->domainlist();
	}
	else
		throw new Exception("Not supported ({$server})");
}

###############################################################################

?>