<?php

###############################################################################
# config-check.php
#
# @author Anil Kumar <akumar@codepunch.com>
# @link   https://codepunch.com
#
# Check if config.php is setup.
#
############################################################################### 

use CodePunch\Base\Util as UTIL;

###############################################################################

if(file_exists(realpath(dirname(__FILE__) . DIRECTORY_SEPARATOR . "config.php")))
	require_once('config.php');
else
{
	$heading = "Missing Configuration File.";
	$body = "";
	if(file_exists(realpath(dirname(__FILE__) . DIRECTORY_SEPARATOR . "config-sample.php"))) {
		$body .= "Installation is not complete. ";
		$body .= "Please rename whois/config-sample.php to whois/config.php and edit it.";
	}
	if(!UTIL::is_cli())
		$message = "<h3>$heading</h3><hr><p>$body</p>";
	else
		$message = "$heading\n$body\n";
	echo $message;
	exit;
}

###############################################################################
?>