<?php

###############################################################################
# whois-api-client.php
#
# @author Anil Kumar <akumar@codepunch.com>
# @link   https://codepunch.com
# @version 1.0.05 # 02-03-2018
#
# A Simple Whois Client that uses Registrar APIs where available.
#
############################################################################### 

require_once('utils/base.php');
require_once('whois/config-check.php');
require_once('whois/whoapi.php');

###############################################################################

use CodePunch\Base\Util as UTIL;

###############################################################################

UTIL::parse_command_line($_REQUEST);
$domain = UTIL::get_request_string("d");
$server = UTIL::get_request_string("s");
$sndbox = isset($_REQUEST['sb']) ? true : false;

###############################################################################

$MAJOR_VERSION  = '1';
$MINOR_VERSION  = '0.4';
$BUILD_DATE     = "06.24.2018";
$VERSION_STRING = "v{$MAJOR_VERSION}.{$MINOR_VERSION}.{$BUILD_DATE}";
$APP_INFO_STRING = "Whois API Client {$VERSION_STRING} (c) CodePunch Solutions: https://codepunch.com";

###############################################################################

api_whois_authenticate();

if(!UTIL::is_cli())
	header("Content-Type: text/plain");
	
try {
	if($domain != "")
		echo api_whois($domain, $server, $sndbox);
	else if(isset($_REQUEST['l']))
	{
		# List Servers: send back the list of API supported whois servers 
		echo implode("\n", get_supported_servers());
	}
	else if(isset($_REQUEST['dl']))
	{
		$dlist = get_domain_list($server, $sndbox);
		if(is_array($dlist))
			print_r(implode("\n",$dlist));
	}
	else if(isset($_REQUEST['av']))
		echo $VERSION_STRING . "\n";
	else if(isset($_REQUEST['ai']))
		echo $APP_INFO_STRING . "\n";
}
catch (Exception $e) {
	echo 'Error: ',  $e->getMessage(), "\n";
	if($e->getMessage() == "Wrong Whois Server or Domain Not Found") {
	}
}

###############################################################################

?>