<?php
#########################################################################################################
#  RunQ.php
#  Copyright (C) Softnik Technologies. All rights reserved.
#
#  Process the Lookup Queue and Do Automatic Domain Lookups
#  This script should be run as a cronjob.
#
#  Options
#
#  Adding to Queue
#  auto - set the refresh interval in days.
#  num  - Number of domains to add to queue
#
#  Processing Queue
#  s - start index for processing lookup queue
#  m - maximum queue entries to process.
#
#########################################################################################################

require_once("lib/php/basic.php");						# Base Functions.
require_once("lib/php/ui/ui.php");						# Basic UI stuff.
require_once("lib/php/pdo/dbinit.php");					# Database.
require_once("lib/php/config.check.php");				# Load the config.
require_once("lib/php/lookups/lookup.php");				# Lookups.
require_once("lib/php/version.php");					# Base Functions.

#########################################################################################################
# Parse command line if running in CLI

if(is_cli())
	parse_str(implode('&', array_slice($argv, 1)), $_REQUEST);

#########################################################################################################

# Check if authentication is required.
$auth = validateSession();
if($auth != 0 && getConfigData('auth_queue_processing', null) == true  && !is_cli())
{
	if(!apikey_authentication_check())
	{
		if(isset($_REQUEST['ajax']))
			echo json_encode(array('validate'=>$auth)); 
		else
			header("Location: " . get_install_url_path() . "login.php");
		exit;
	}
}

#########################################################################################################

# save the timestamp and get database.
$script_started_at = microtime(true);
$pdo = init_db(false);
if($pdo === false)
{
	if(isset($_REQUEST['ajax']))
		echo json_encode(array('validate'=>$auth, 'status'=>'database error')); 
	exit;
}

#########################################################################################################

$max_count = getSanitizedNumericRequestVariable('m', 8, 2, 16);
	
#########################################################################################################

$start_from = 0;
if(isset($_REQUEST['s']))
{
	if($_REQUEST['s'] == "")
		$start_from = $pdo->getQueueIndex() * $max_count * 2;
	else
		$start_from = intval($_REQUEST['s']);
}
if($start_from < 0)
	$start_from = 0;
	
#########################################################################################################

$prefer = trim(getConfigData("high_preference_lookups", "dw,ip"));
	
#########################################################################################################

$pdo->logQueueProcessingTimestamp();
$processinfo = processLookupQueue($max_count, $start_from, $prefer);
$qcount = $processinfo['count'];
$script_ended_at = microtime(true);
$exec_time = $script_ended_at-$script_started_at;

#########################################################################################################

if(isset($_REQUEST['ajax']))
{
	$response['validate']   = $auth;
	$response['processed']  = $processinfo['processed'];
	$response['queuesize']  = $qcount;
	$response['startfrom']  = $start_from;
	$response['maxcount']   = $processinfo['processed'] > 0 ? $max_count : 0;
	$response['exectime']   = round($exec_time);
	$response['remoteaddr'] = isset($_SERVER['REMOTE_ADDR']) ? $_SERVER['REMOTE_ADDR'] : "CLI";
	$response['status']     = "ok";
}

#########################################################################################################

if($qcount == 0 && isset($_REQUEST['auto']))
{
	$maxdays = getSanitizedNumericRequestVariable('auto', 180, 1, 180);
	$numadd = getSanitizedNumericRequestVariable('num', 8, 1, 2048);
		
	$alldomainscatid = 1;
	// First add domains that have never been checked.
	$added = addDomainsToLookupQueue($alldomainscatid, 365, "dw", $numadd);
	if($added > 0)
	{
		if(isset($_REQUEST['ajax']))
			$response['newly_added'] = $added;
	}
	else if($maxdays)
	{
		// Now check domains that haven't been checked in $maxdays
		$added = addDomainsToLookupQueue($alldomainscatid, $maxdays, "dw", $numadd);
		if(isset($_REQUEST['ajax']))
		{
			$response['refresh_added'] = $added;
			$response['refresh_days'] = $maxdays;
		}
	}
}

#########################################################################################################

if(isset($_REQUEST['ajax']))
	echo json_encode($response); 

#########################################################################################################
?>
