<?php

#########################################################################################################
#  MakeQ.php
#
#  Copyright (C) Softnik Technologies. All rights reserved.
#
#  Use MakeQ.php to selectively add domains to the lookup queue. Though you can use RunQ.php with the 
#  auto option to do simple domain whois refresh, MakeQ.php offers more options and supports lookups
#  other than domain whois.
#
#  Options
#
#  d    - lookup domains that haven't been looked up within the last 'd' days. Set d=0 for all domains.
#         default is 180 days. Avoid using this script for extremely frequent lookups (d=0). 
#         If you have to do it make sure that the domain list / category is small.
#  cat  - specify a category name to lookup domains that belong to that category alone.
#  l    - limit the number of domains that will be added to lookup queue to 'l'. The script may timeout
#         if you have a large domain list and this value is not set.
#  w    - specify what to lookup. Default is domain whois (dw). The other supported values are
#         dw,ipw,gpr,mx,ping,alexa,ip,http,gi
#  kill - remove all entries from the lookup queue. Can be combined with 'w' to remove only selected
#         lookup. Combine with w=all to kill all lookup queue entries.
#  ue   - Lookup all domains that have a 'past' expiry date or are nearing expiry (within the next 
#         'ue' days). If you specify 'ue' without a value, it will be set to 30. Maximum is 60. Other
#         options will be ignored if you specify a 'ue' value.
#
#  The 'ue' option allows you to quickly refresh the data for domains after you have renewed them. You
#  can also invoke this script from the crontab once every month.
#
#  Examples
#
#  http://example.com/wmdsed22/makeq.php?d=5&l=2000&cat=Important+Domains&w=dw
#  http://example.com/wmdsed22/makeq.php?ue=60
#
#  Example cron entry to automatically refresh (monthly) domains that are near expiry date.
#
#  0 0 1 * * wget -q -O /dev/null "http://www.example.com/wmdsed22/makeq.php?ue=30" >/dev/null 2>&1
#
#########################################################################################################

require_once("lib/php/basic.php");						# Base Functions.
require_once("lib/php/ui/ui.php");						# Basic UI stuff.
require_once("lib/php/pdo/dbinit.php");					# Database.
require_once("lib/php/config.check.php");				# Load the config.
require_once("lib/php/lookups/lookup.php");				# Lookups.

#########################################################################################################
# Parse command line if running in CLI

if(is_cli())
	parse_str(implode('&', array_slice($argv, 1)), $_REQUEST);

#########################################################################################################

# Check if authentication is required.
$auth = validateSession();
if($auth != 0 && getConfigData('auth_queue_processing', null) == true  && !is_cli())
{
	if(!apikey_authentication_check())
	{
		if(isset($_REQUEST['ajax']))
			echo json_encode(array('validate'=>$auth)); 
		else
			header("Location: " . get_install_url_path() . "login.php");
		exit;
	}
}

#########################################################################################################

$pdo = init_db(false);
if($pdo === false)
{
	if(isset($_REQUEST['ajax']))
		echo json_encode(array('validate'=>$auth, 'status'=>'database error')); 
	exit;
}

#########################################################################################################

$maxdomains = getSanitizedNumericRequestVariable('l', 180, 1, 5000);
$maxdays 	= getSanitizedNumericRequestVariable('d', 181, 0, 181)-1;
$luwhat 	= getRequestVariable('w', "");
$catid		= 1;

#########################################################################################################

if(isset($_REQUEST['cat']))
	$catid = $pdo->getCategoryIDFromName($_REQUEST['cat']);

#########################################################################################################

if(isset($_REQUEST['kill']))
{
	$deleted = killLookupQueue($catid, $luwhat);
	exit;
}

#########################################################################################################

if(isset($_REQUEST['ue']))
{
	$edays = getSanitizedNumericRequestVariable('ue', 30, -120, 60);
	$added = addRecentDomainsToWhoisLookupQueue($catid, $edays);
}
else
	$added = addDomainsToLookupQueue($catid, $maxdays, $luwhat, $maxdomains);

if(isset($_REQUEST['ajax']))
	echo json_encode(array('validate'=>$auth, 'status'=>'ok', 'added'=>$added)); 

#########################################################################################################

?>
