<?php 
###############################################################################
# login.php
# Watch My Domains SED v3
# (c) Softnik Technologies. All rights reserved.
###############################################################################

$cwd = dirname(__FILE__);
$customlogin = $cwd . DIRECTORY_SEPARATOR . "custom.login.php";
if(is_file($customlogin))
{
	$page = "custom.login.php";
	if(isset($_REQUEST['r']))
		$page .= "?r=" . $_REQUEST['r'];
	if(isset($_REQUEST['redir']))
	{
		$redir = filter_var($_REQUEST['redir'], FILTER_SANITIZE_STRING);
		if(strstr($page, "?r=") !== false)
			$page .= "&redir=" . $redir;
		else
			$page .= "?redir=" . $redir;
	}
	header('Location: ' . $page) ;
	exit;
}

###############################################################################

require_once("lib/php/basic.php");				# Base Functions.
require_once("lib/php/ui/ui.php");				# Basic UI stuff. 
require_once("lib/php/pdo/dbinit.php");			# Database
require_once("lib/php/config.check.php");		# Load the configuration.

###############################################################################


$auth = validateSession();
if($auth == 0)
	interfaceRedir();
else
	show_login();

###############################################################################
?>
