<?php

###############################################################################

function show_message($message, $regcodeform=false)
{
	if(is_cli())
	{
		$message = str_replace("</p>", "\n", $message);
		$message = str_replace("</pre>", "\n", $message);
		$message = str_replace("<hr>", "\n", $message);
		smartEcho(trim(strip_tags($message)));
		exit;
	}
	$phppath = get_php_folder_path();		
	require_once($phppath . "version.php");
	$layoutpath = get_layout_folder_path();
	require_once($layoutpath . "head.inc.php");
	echo "<body>\n";
?>
<div id="header"></div>
<div id="content">
	<div class="container-fluid">
		<div class="row">
			<div class="col-sm-3 menu-sidebar">
				<?php require_once('menusidebar.inc.php'); ?>
			</div>
			<div class="col-sm-9 main">
				<?php 
					echo $message; 
					if($regcodeform)
						require_once($phppath . "config/panels/regcodeform.inc.php");
				?>
				<div class="visible-xs bottombar">
					<?php require_once('menubottombar.inc.php'); ?>
				</div>
			</div>
		</div>
	</div>
</div>
<?php
	require_once($layoutpath . "bodytail.inc.php");
	echo "</body>\n</html>\n";
}

###############################################################################

function show_login()
{
	$phppath = get_php_folder_path();		
	require_once($phppath . "version.php");
	$layoutpath = get_layout_folder_path();
	require_once($layoutpath . "head.inc.php");
	echo "<body>\n";
?>
<div id="header"></div>
<div id="content">
	<div class="container-fluid">
		<div class="row">
			<div class="col-xs-12 main">
				<?php require_once('login.inc.php'); ?>
			</div>
		</div>
	</div>
</div>
<?php
	require_once($layoutpath . "bodytail.inc.php");
	echo "</body>\n</html>\n";
}

###############################################################################

function show_monitor()
{
	$phppath = get_php_folder_path();		
	require_once($phppath . "version.php");
	$layoutpath = get_layout_folder_path();
	require_once($layoutpath . "head.inc.php");
	echo "<body>\n";
?>
<div id="header"></div>
<div id="content">
	<div class="container-fluid">
		<div class="row">
			<div class="col-sm-3 menu-sidebar">
				<?php require_once('menusidebar.inc.php'); ?>
			</div>
			<div class="col-sm-9 main">
				<?php require_once('monitor.inc.php'); ?>
				<div class="visible-xs bottombar">
					<?php require_once('menubottombar.inc.php'); ?>
				</div>
			</div>
		</div>
	</div>
</div>
<?php
	require_once($layoutpath . "bodytail.inc.php");
	echo "</body>\n</html>\n";
}

###############################################################################

function show_audit_log()
{
	$pdo = init_db();
	if($pdo !== false)
	{		
		$auditlog = "<h3 class=\"heading\">Audit Log</h3>\n<hr>\n";
		if(isAdminUser())
			$auditlog .= $pdo->getLastAuditLogEntries(1000);
		show_message($auditlog);
	}
	else
		warn_and_quit_on_problems();
}

###############################################################################

function show_main_menu()
{
	$phppath = get_php_folder_path();
	require_once($phppath . "version.php");
	$layoutpath = get_layout_folder_path();
	require_once($layoutpath . "head.inc.php");
	echo "<body>\n";
	require_once($phppath . "ui/menu.inc.php");
	require_once($layoutpath . "bodytail.inc.php");
	echo "</body>\n</html>\n";
}

###############################################################################

function show_main_interface()
{
	$phppath = get_php_folder_path();
	$layoutpath = get_layout_folder_path();
	$uipanelpath = get_ui_config_panels_path();
	$uiblockspath = get_ui_blocks_path();
	check_basics();
	require_once($phppath . "config/displaygroups.php");
	require_once($phppath . "idn/idn.php");
	require_once($phppath . "version.php");
	initDisplayGroups();
	
	require_once($layoutpath . "head.full.inc.php");
	echo "<body>\n";
	require_once($uiblockspath . "header.full.inc.php");
	require_once($uiblockspath . "mainiface.inc.php");
	require_once($layoutpath . "footer.inc.php");
	
	require_once($uipanelpath . "popmenu.inc.php");
	require_once($uipanelpath . "uisetup.inc.php");
	require_once($uipanelpath . "columnsetup.inc.php");
	require_once($uipanelpath . "dnscolsetup.inc.php");
	require_once($uipanelpath . "sslcolsetup.inc.php");
	require_once($uipanelpath . "whois.setup.inc.php");
	require_once($uipanelpath . "adddomains.inc.php");
	require_once($uipanelpath . "addsubdomains.inc.php");
	require_once($uipanelpath . "csvupload.inc.php");
	require_once($uipanelpath . "customcolumns.inc.php");
	require_once($uipanelpath . "navbarmenu.inc.php");
	require_once($uipanelpath . "download.inc.php");
	require_once($uipanelpath . "lookupdomains.inc.php");
	require_once($uipanelpath . "parsewhois.inc.php");
	require_once($uipanelpath . "regalias.inc.php");
	require_once($uipanelpath . "processqueue.inc.php");
	require_once($uipanelpath . "bulkedit.inc.php");
	require_once($uipanelpath . "categorize.inc.php");
	require_once($uipanelpath . "appsetup.inc.php");
	require_once($uipanelpath . "userguide.inc.php");
	if(isAdminUser())
		require_once($uipanelpath . "useradmin.inc.php");
	else
		require_once($uipanelpath . "userselfadmin.inc.php");
	
	require_once($layoutpath . "bodytail.full.inc.php");
	echo "</body>\n</html>\n";
}

###############################################################################

function show_sdmgr_interface()
{
	$phppath = get_php_folder_path();
	$layoutpath = get_layout_folder_path();
	$uipanelpath = get_ui_config_panels_path();
	$uiblockspath = get_ui_blocks_path();
	check_basics();
	require_once($phppath . "config/displaygroups.php");
	require_once($phppath . "idn/idn.php");
	require_once($phppath . "version.php");
	require_once($layoutpath . "head.sd.inc.php");
	echo "<body>\n";
	require_once($uiblockspath . "header.sd.inc.php");
	require_once($uiblockspath . "sdiface.inc.php");
	require_once($layoutpath . "footer.inc.php");
	
	require_once($uipanelpath . "popmenu.sd.inc.php");
	require_once($uipanelpath . "uisetup.inc.php");
	require_once($uipanelpath . "addsubdomains.inc.php");
	require_once($uipanelpath . "columnsetup.inc.php");
	require_once($uipanelpath . "csvupload.sd.inc.php");
	require_once($uipanelpath . "processqueue.inc.php");
	require_once($uipanelpath . "bulkedit.inc.php");
	require_once($uipanelpath . "categorize.inc.php");
	require_once($uipanelpath . "userguide.inc.php");
	require_once($uipanelpath . "download.inc.php");
	require_once($uipanelpath . "lookupdomains.inc.php");
	require_once($uipanelpath . "navbarmenu.sd.inc.php");
	if(isAdminUser())
		require_once($uipanelpath . "useradmin.inc.php");
	else
		require_once($uipanelpath . "userselfadmin.inc.php");
	
	require_once($layoutpath . "bodytail.sd.inc.php");
	echo "</body>\n</html>\n";
}

###############################################################################

function check_basics()
{
	$phppath = get_php_folder_path();
	require_once($phppath . "tests.php");
	warn_and_quit_on_problems();
}

###############################################################################
?>
